/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.source;

import adams.core.DateUtils;
import adams.data.conversion.Conversion;
import adams.data.conversion.MultiConversion;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.conversion.StringToSpreadSheet;
import adams.data.io.input.SimpleCsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.job.InvestigatorJob;
import adams.gui.tools.wekainvestigator.source.AbstractSource;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.Date;
import weka.core.Instances;

public class Clipboard
extends AbstractSource {
    private static final long serialVersionUID = 5646388990155938153L;
    protected SpreadSheetReader m_LastReader;

    public Clipboard() {
        this.setName("Clipboard...");
        this.setIcon("paste.gif");
    }

    protected GenericObjectEditorDialog createDialog() {
        GenericObjectEditorDialog result = this.getOwner().getParentDialog() != null ? new GenericObjectEditorDialog(this.getOwner().getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getOwner().getParentFrame(), true);
        result.setDefaultCloseOperation(2);
        result.setTitle("Import of clipboard content");
        result.setUISettingsPrefix(SpreadSheetReader.class);
        result.getGOEEditor().setClassType(SpreadSheetReader.class);
        result.getGOEEditor().setCanChangeClassInDialog(true);
        result.setCurrent((Object)this.m_LastReader);
        result.setLocationRelativeTo((Component)((Object)this.getOwner()));
        return result;
    }

    protected void doActionPerformed(ActionEvent e) {
        if (!ClipboardHelper.canPasteStringFromClipboard()) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)"Clipboard empty!");
            return;
        }
        if (this.m_LastReader == null) {
            this.m_LastReader = new SimpleCsvSpreadSheetReader();
            ((SimpleCsvSpreadSheetReader)this.m_LastReader).setNoHeader(true);
            ((SimpleCsvSpreadSheetReader)this.m_LastReader).setSeparator("\\t");
        }
        final GenericObjectEditorDialog dialog = this.createDialog();
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        InvestigatorJob job = new InvestigatorJob(this.getOwner(), "Loading clipboard data"){

            @Override
            protected void doRun() {
                Clipboard.this.m_LastReader = (SpreadSheetReader)dialog.getCurrent();
                StringToSpreadSheet str2sheet = new StringToSpreadSheet();
                str2sheet.setReader(Clipboard.this.m_LastReader);
                str2sheet.setInput((Object)ClipboardHelper.pasteStringFromClipboard());
                SpreadSheetToWekaInstances sheet2weka = new SpreadSheetToWekaInstances();
                MultiConversion multi = new MultiConversion();
                multi.setSubConversions(new Conversion[]{str2sheet, sheet2weka});
                multi.setInput((Object)ClipboardHelper.pasteStringFromClipboard());
                String msg = multi.convert();
                Instances data = null;
                if (msg == null) {
                    data = (Instances)multi.getOutput();
                } else {
                    GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)("Failed to parse clipboard content!\n" + msg));
                }
                multi.cleanUp();
                data.setRelationName("Clipboard - " + DateUtils.getTimestampFormatter().format(new Date()));
                Clipboard.this.addData(new MemoryContainer(data));
            }
        };
        this.getOwner().startExecution(job);
    }
}

