/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.Range;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithDataTable;
import adams.gui.visualization.stats.boxplot.BoxPlotManager;
import adams.ml.data.InstancesView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;

public class BoxPlotTab
extends AbstractInvestigatorTabWithDataTable {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final int NUM_PLOTS_HORIZONTAL = 3;
    protected BoxPlotManager m_LastBoxPlot;
    protected BoxPlotManager m_CurrentBoxPlot;

    @Override
    public String getTitle() {
        return "Box plot";
    }

    @Override
    public String getTabIcon() {
        return "boxplot.png";
    }

    @Override
    protected boolean hasReadOnlyTable() {
        return true;
    }

    @Override
    protected int getDataTableListSelectionMode() {
        return 0;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        super.dataChanged(e);
        this.dataTableSelectionChanged();
    }

    @Override
    protected void dataTableSelectionChanged() {
        if (this.m_Table.getRowCount() > 0 && this.m_Table.getSelectedRow() > -1) {
            this.m_LastBoxPlot = this.m_CurrentBoxPlot;
            int index = this.m_Table.getSelectedRow();
            InstancesView view = new InstancesView(((DataContainer)this.getData().get(index)).getData());
            this.m_CurrentBoxPlot = new BoxPlotManager();
            if (this.m_LastBoxPlot != null) {
                this.m_CurrentBoxPlot.setBoxWidth(this.m_LastBoxPlot.getBoxWidth());
                this.m_CurrentBoxPlot.setBoxHeight(this.m_LastBoxPlot.getBoxHeight());
                this.m_CurrentBoxPlot.setAxisWidth(this.m_LastBoxPlot.getAxisWidth());
                this.m_CurrentBoxPlot.setNumHorizontal(this.m_LastBoxPlot.getNumHorizontal());
                this.m_CurrentBoxPlot.setSameAxis(this.m_LastBoxPlot.getSameAxis());
                this.m_CurrentBoxPlot.setRange(this.m_LastBoxPlot.getRange());
                this.m_CurrentBoxPlot.setFill(this.m_LastBoxPlot.getFill());
                this.m_CurrentBoxPlot.setColor(this.m_LastBoxPlot.getColor());
            } else {
                this.m_CurrentBoxPlot.setBoxWidth(200);
                this.m_CurrentBoxPlot.setBoxHeight(200);
                this.m_CurrentBoxPlot.setAxisWidth(50);
                this.m_CurrentBoxPlot.setNumHorizontal(3);
                this.m_CurrentBoxPlot.setSameAxis(false);
                if (view.getColumnCount() <= 9) {
                    this.m_CurrentBoxPlot.setRange(new Range("first-last"));
                } else {
                    this.m_CurrentBoxPlot.setRange(new Range("1-9"));
                }
                this.m_CurrentBoxPlot.setFill(true);
                this.m_CurrentBoxPlot.setColor(Color.RED);
            }
            this.m_CurrentBoxPlot.setData((SpreadSheet)new InstancesView(((DataContainer)this.getData().get(index)).getData()));
            this.m_CurrentBoxPlot.reset();
            this.m_PanelData.removeAll();
            this.m_PanelData.add((Component)this.m_CurrentBoxPlot, "Center");
            this.m_PanelData.setPreferredSize(new Dimension(200, this.m_DefaultDataTableHeight));
            if (this.m_SplitPane.isBottomComponentHidden()) {
                this.m_SplitPane.setBottomComponentHidden(false);
                this.m_SplitPane.setDividerLocation(this.m_DefaultDataTableHeight);
            }
        } else {
            this.m_PanelData.removeAll();
            this.m_SplitPane.setBottomComponentHidden(true);
        }
        this.invalidate();
        this.revalidate();
        this.doLayout();
    }
}

