/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.MessageCollection;
import adams.core.Range;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.container.DataPoint;
import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.statistics.StatUtils;
import adams.data.weka.WekaAttributeRange;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseList;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextField;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import adams.gui.visualization.report.ReportFactory;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import weka.core.Instances;
import weka.filters.unsupervised.attribute.Remove;

public class CompareTab
extends AbstractInvestigatorTab {
    private static final long serialVersionUID = 6828735730385124766L;
    public static final String KEY_FIRST_DATASET = "dataset1";
    public static final String KEY_SECOND_DATASET = "dataset2";
    public static final String KEY_FIRST_ATTRANGE = "attrange1";
    public static final String KEY_SECOND_ATTRANGE = "attrange2";
    protected BaseComboBox<String> m_ComboBoxFirstDataset;
    protected DefaultComboBoxModel<String> m_ModelFirstDataset;
    protected BaseComboBox<String> m_ComboBoxSecondDataset;
    protected DefaultComboBoxModel<String> m_ModelSecondDataset;
    protected JPanel m_PanelDatasets;
    protected BaseTextField m_TextFirstRange;
    protected BaseTextField m_TextSecondRange;
    protected JPanel m_PanelStructure;
    protected BaseButton m_ButtonStructure;
    protected JPanel m_PanelComparison;
    protected BaseTextArea m_TextStructure;
    protected JPanel m_PanelData;
    protected BaseComboBox<String> m_ComboBoxFirstID;
    protected DefaultComboBoxModel<String> m_ModelFirstID;
    protected BaseComboBox<String> m_ComboBoxSecondID;
    protected DefaultComboBoxModel<String> m_ModelSecondID;
    protected BaseButton m_ButtonData;
    protected BaseTabbedPane m_TabbedPaneData;
    protected BaseTextArea m_TextOnlyFirst;
    protected BaseTextArea m_TextCommon;
    protected BaseTextArea m_TextOnlySecond;
    protected DefaultListModel<String> m_ModelCommonIDs;
    protected BaseList m_ListCommonIDs;
    protected InstancePanel m_PanelBoth;
    protected InstancePanel m_PanelDifference;
    protected ReportFactory.Table m_ReportTable;
    protected Instances m_FirstData;
    protected TIntList m_FirstAttributes;
    protected Instances m_SecondData;
    protected TIntList m_SecondAttributes;
    protected TextFileChooser m_FileChooserIDs;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ModelFirstDataset = new DefaultComboBoxModel();
        this.m_ModelSecondDataset = new DefaultComboBoxModel();
        this.m_FirstAttributes = new TIntArrayList();
        this.m_SecondAttributes = new TIntArrayList();
        this.m_FileChooserIDs = new TextFileChooser();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelDatasets = new JPanel(new FlowLayout(0));
        this.add(this.m_PanelDatasets, "North");
        this.m_ComboBoxFirstDataset = new BaseComboBox(this.m_ModelFirstDataset);
        this.m_ComboBoxFirstDataset.setPreferredSize(new Dimension(150, GUIHelper.getPreferredComboBoxHeight()));
        JLabel label = new JLabel("First");
        label.setDisplayedMnemonic('F');
        label.setLabelFor((Component)this.m_ComboBoxFirstDataset);
        this.m_PanelDatasets.add(label);
        this.m_PanelDatasets.add((Component)this.m_ComboBoxFirstDataset);
        this.m_TextFirstRange = new BaseTextField(10);
        this.m_TextFirstRange.setText("");
        this.m_TextFirstRange.setToolTipText("The attribute range to consider");
        this.m_TextFirstRange.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CompareTab.this.updateWidgets();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CompareTab.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CompareTab.this.updateWidgets();
            }
        });
        this.m_PanelDatasets.add((Component)this.m_TextFirstRange);
        this.m_ComboBoxSecondDataset = new BaseComboBox(this.m_ModelSecondDataset);
        this.m_ComboBoxSecondDataset.setPreferredSize(new Dimension(150, GUIHelper.getPreferredComboBoxHeight()));
        label = new JLabel("Second");
        label.setDisplayedMnemonic('S');
        label.setLabelFor((Component)this.m_ComboBoxSecondDataset);
        this.m_PanelDatasets.add(label);
        this.m_PanelDatasets.add((Component)this.m_ComboBoxSecondDataset);
        this.m_TextSecondRange = new BaseTextField(10);
        this.m_TextSecondRange.setText("");
        this.m_TextSecondRange.setToolTipText("The attribute range to consider");
        this.m_TextSecondRange.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CompareTab.this.updateWidgets();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CompareTab.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CompareTab.this.updateWidgets();
            }
        });
        this.m_PanelDatasets.add((Component)this.m_TextSecondRange);
        this.m_ButtonStructure = new BaseButton("Compare");
        this.m_ButtonStructure.addActionListener(e -> this.compareStructure());
        this.m_PanelDatasets.add((Component)this.m_ButtonStructure);
        this.m_PanelComparison = new JPanel(new BorderLayout());
        this.add(this.m_PanelComparison, "Center");
        this.m_PanelStructure = new JPanel(new BorderLayout());
        this.m_PanelStructure.setBorder(BorderFactory.createTitledBorder("Structure"));
        this.m_TextStructure = new BaseTextArea(3, 40);
        this.m_TextStructure.setEditable(false);
        this.m_TextStructure.setTextFont(Fonts.getMonospacedFont());
        this.m_PanelStructure.add((Component)new BaseScrollPane((Component)this.m_TextStructure), "Center");
        this.m_PanelComparison.add((Component)this.m_PanelStructure, "North");
        this.m_PanelData = new JPanel(new BorderLayout());
        this.m_PanelData.setBorder(BorderFactory.createTitledBorder("Data"));
        this.m_PanelComparison.add((Component)this.m_PanelData, "Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        this.m_PanelData.add((Component)panel, "North");
        this.m_ModelFirstID = new DefaultComboBoxModel();
        this.m_ComboBoxFirstID = new BaseComboBox(this.m_ModelFirstID);
        this.m_ComboBoxFirstID.setPreferredSize(new Dimension(150, GUIHelper.getPreferredComboBoxHeight()));
        label = new JLabel("First");
        label.setLabelFor((Component)this.m_ComboBoxFirstID);
        panel.add(label);
        panel.add((Component)this.m_ComboBoxFirstID);
        this.m_ModelSecondID = new DefaultComboBoxModel();
        this.m_ComboBoxSecondID = new BaseComboBox(this.m_ModelSecondID);
        this.m_ComboBoxSecondID.setPreferredSize(new Dimension(150, GUIHelper.getPreferredComboBoxHeight()));
        label = new JLabel("Second");
        label.setLabelFor((Component)this.m_ComboBoxSecondID);
        panel.add(label);
        panel.add((Component)this.m_ComboBoxSecondID);
        this.m_ButtonData = new BaseButton("Compare");
        this.m_ButtonData.addActionListener(e -> this.compareData());
        panel.add((Component)this.m_ButtonData);
        this.m_TabbedPaneData = new BaseTabbedPane();
        this.m_PanelData.add((Component)this.m_TabbedPaneData, "Center");
        panel = new JPanel(new GridLayout(1, 3));
        this.m_TabbedPaneData.addTab("IDs", (Component)panel);
        this.m_TextOnlyFirst = new BaseTextArea(40, 20);
        this.m_TextOnlyFirst.setEditable(false);
        this.m_TextOnlyFirst.setTextFont(Fonts.getMonospacedFont());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createTitledBorder("Only first"));
        panel2.add((Component)new BaseScrollPane((Component)this.m_TextOnlyFirst), "Center");
        panel2.add((Component)this.createIDInfoPanel(this.m_TextOnlyFirst), "South");
        panel.add(panel2);
        this.m_TextCommon = new BaseTextArea(40, 20);
        this.m_TextCommon.setEditable(false);
        this.m_TextCommon.setTextFont(Fonts.getMonospacedFont());
        panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createTitledBorder("Common"));
        panel2.add((Component)new BaseScrollPane((Component)this.m_TextCommon), "Center");
        panel2.add((Component)this.createIDInfoPanel(this.m_TextCommon), "South");
        panel.add(panel2);
        this.m_TextOnlySecond = new BaseTextArea(40, 20);
        this.m_TextOnlySecond.setEditable(false);
        this.m_TextOnlySecond.setTextFont(Fonts.getMonospacedFont());
        panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createTitledBorder("Only second"));
        panel2.add((Component)new BaseScrollPane((Component)this.m_TextOnlySecond), "Center");
        panel2.add((Component)this.createIDInfoPanel(this.m_TextOnlySecond), "South");
        panel.add(panel2);
        BaseSplitPane splitPane = new BaseSplitPane(1);
        splitPane.setResizeWeight(1.0);
        splitPane.setDividerLocation(600);
        splitPane.setUISettingsParameters(this.getClass(), "Divider");
        this.m_TabbedPaneData.addTab("Values", (Component)splitPane);
        panel2 = new JPanel(new GridLayout(2, 1));
        splitPane.setLeftComponent((Component)panel2);
        this.m_PanelBoth = new InstancePanel("Compare");
        this.m_PanelBoth.setSidePanelVisible(false);
        this.m_PanelBoth.getPlot().getAxis(Axis.BOTTOM).setAxisName("Attribute index (in selected range)");
        this.m_PanelDifference = new InstancePanel("Difference");
        this.m_PanelDifference.setSidePanelVisible(false);
        this.m_PanelDifference.getPlot().getAxis(Axis.BOTTOM).setAxisName("Attribute index (in selected range)");
        panel2.add((Component)((Object)this.m_PanelBoth));
        panel2.add((Component)((Object)this.m_PanelDifference));
        panel2 = new JPanel(new GridLayout(2, 1));
        splitPane.setRightComponent((Component)panel2);
        this.m_ModelCommonIDs = new DefaultListModel();
        this.m_ListCommonIDs = new BaseList(this.m_ModelCommonIDs);
        this.m_ListCommonIDs.addListSelectionListener(e -> this.compareInstances());
        panel2.add((Component)new BaseScrollPane((Component)this.m_ListCommonIDs));
        this.m_ReportTable = ReportFactory.getTable(null);
        this.m_ReportTable.setAutoResizeMode(0);
        this.m_ReportTable.setNumDecimals(3);
        panel2.add((Component)new BaseScrollPane((Component)this.m_ReportTable));
    }

    protected JPanel createIDInfoPanel(final BaseTextArea textArea) {
        JPanel result = new JPanel(new BorderLayout());
        final JLabel labelNumItems = new JLabel("0 IDs");
        result.add((Component)labelNumItems, "West");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        result.add((Component)panelButtons, "East");
        final BaseButton buttonCopy = new BaseButton((Icon)ImageManager.getIcon((String)"copy.gif"));
        buttonCopy.addActionListener(e -> ClipboardHelper.copyToClipboard((String)textArea.getText()));
        panelButtons.add((Component)buttonCopy);
        final BaseButton buttonSave = new BaseButton((Icon)ImageManager.getIcon((String)"save.gif"));
        buttonSave.addActionListener(e -> {
            int retVal = this.m_FileChooserIDs.showSaveDialog((Component)((Object)this.getOwner()));
            if (retVal != 0) {
                return;
            }
            String msg = FileUtils.writeToFileMsg((String)this.m_FileChooserIDs.getSelectedFile().getAbsolutePath(), (Object)textArea.getText(), (boolean)false, null);
            if (msg != null) {
                GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)("Failed to write IDs to:\n" + this.m_FileChooserIDs.getSelectedFile() + "\n" + msg));
            } else {
                this.logMessage("IDs written to: " + this.m_FileChooserIDs.getSelectedFile());
            }
        });
        panelButtons.add((Component)buttonSave);
        textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            protected void update() {
                String text = textArea.getText().trim();
                int lines = 0;
                if (text.length() > 0) {
                    lines = text.split("\n").length;
                }
                labelNumItems.setText(lines + " IDs");
                buttonCopy.setEnabled(lines > 0);
                buttonSave.setEnabled(lines > 0);
            }
        });
        return result;
    }

    protected void finishInit() {
        super.finishInit();
        this.m_TextFirstRange.setText("first-last");
        this.m_TextSecondRange.setText("first-last");
        this.m_TextOnlyFirst.setText("");
        this.m_TextCommon.setText("");
        this.m_TextOnlySecond.setText("");
        this.updateWidgets();
    }

    @Override
    public String getTitle() {
        return "Compare";
    }

    @Override
    public String getTabIcon() {
        return "diff.png";
    }

    protected Instances getStructure(Instances data, String rangeStr, TIntList indices) {
        Instances result = new Instances(data, 0);
        if (rangeStr == null || rangeStr.isEmpty()) {
            rangeStr = "first-last";
        }
        WekaAttributeRange range = new WekaAttributeRange(rangeStr);
        range.setData(data);
        indices.clear();
        indices.addAll(range.getIntIndices());
        if (indices.size() == 0) {
            return result;
        }
        Remove remove = new Remove();
        remove.setAttributeIndicesArray(indices.toArray());
        remove.setInvertSelection(true);
        try {
            remove.setInputFormat(result);
            result = remove.getOutputFormat();
        }
        catch (Exception e) {
            this.logError("Failed to filter instances structure, using: " + rangeStr, e, "Structure filter failure");
        }
        return result;
    }

    protected void compareStructure() {
        Instances secondStructure;
        this.m_FirstData = ((DataContainer)this.getOwner().getData().get(this.m_ComboBoxFirstDataset.getSelectedIndex())).getData();
        this.m_SecondData = ((DataContainer)this.getOwner().getData().get(this.m_ComboBoxSecondDataset.getSelectedIndex())).getData();
        Instances firstStructure = this.getStructure(this.m_FirstData, this.m_TextFirstRange.getText(), this.m_FirstAttributes);
        String structure = firstStructure.equalHeadersMsg(secondStructure = this.getStructure(this.m_SecondData, this.m_TextSecondRange.getText(), this.m_SecondAttributes));
        if (structure == null) {
            structure = "Same structure";
        }
        this.m_TextStructure.setText(structure);
        String oldFirst = (String)this.m_ComboBoxFirstDataset.getSelectedItem();
        this.m_ModelFirstID.removeAllElements();
        boolean match = false;
        for (int i : this.m_FirstAttributes.toArray()) {
            this.m_ModelFirstID.addElement(this.m_FirstData.attribute(i).name());
            if (oldFirst == null || !this.m_FirstData.attribute(i).name().equals(oldFirst)) continue;
            match = true;
        }
        if (match) {
            this.m_ComboBoxFirstID.setSelectedItem((Object)oldFirst);
        }
        String oldSecond = (String)this.m_ComboBoxSecondDataset.getSelectedItem();
        this.m_ModelSecondID.removeAllElements();
        match = false;
        for (int i : this.m_SecondAttributes.toArray()) {
            this.m_ModelSecondID.addElement(this.m_SecondData.attribute(i).name());
            if (oldSecond == null || !this.m_SecondData.attribute(i).name().equals(oldSecond)) continue;
            match = true;
        }
        if (match) {
            this.m_ComboBoxSecondID.setSelectedItem((Object)oldSecond);
        }
        this.m_TextOnlyFirst.setText("");
        this.m_TextCommon.setText("");
        this.m_TextOnlySecond.setText("");
        this.updateWidgets();
    }

    protected List<String> getIDs(Instances dataset, int index) {
        ArrayList<String> result = new ArrayList<String>();
        boolean nominal = dataset.attribute(index).isNominal() || dataset.attribute(index).isString();
        for (int i = 0; i < dataset.numInstances(); ++i) {
            if (nominal) {
                result.add(dataset.instance(i).stringValue(index));
                continue;
            }
            result.add("" + dataset.instance(i).value(index));
        }
        return result;
    }

    protected Instance getInstance(Instances dataset, int index, String id, TIntList attributes) {
        Instance result = null;
        weka.core.Instance inst = null;
        int instIndex = -1;
        boolean nominal = dataset.attribute(index).isNominal() || dataset.attribute(index).isString();
        for (int i = 0; i < dataset.numInstances(); ++i) {
            if (nominal) {
                if (!id.equals(dataset.instance(i).stringValue(index))) continue;
                inst = dataset.instance(i);
                instIndex = i;
                break;
            }
            if (!id.equals("" + dataset.instance(i).value(index))) continue;
            inst = dataset.instance(i);
            instIndex = i;
            break;
        }
        if (inst != null) {
            TIntArrayList actualAtts = new TIntArrayList((TIntCollection)attributes);
            actualAtts.remove(index);
            Range range = new Range();
            range.setIndices(actualAtts.toArray());
            result = new Instance();
            result.set(inst, instIndex, new int[]{index}, range, null);
            result.setID(id);
        }
        return result;
    }

    protected void compareInstances() {
        InstanceContainer cont;
        InstanceContainerManager managerComp = (InstanceContainerManager)this.m_PanelBoth.getContainerManager();
        InstanceContainerManager managerDiff = (InstanceContainerManager)this.m_PanelDifference.getContainerManager();
        managerComp.clear();
        managerDiff.clear();
        this.m_ReportTable.setModel((TableModel)ReportFactory.getModel(null));
        this.m_ReportTable.setOptimalColumnWidth();
        if (this.m_ListCommonIDs.getSelectedIndex() < 1) {
            return;
        }
        String id = "" + this.m_ListCommonIDs.getSelectedValue();
        Instance inst1 = this.getInstance(this.m_FirstData, this.m_ComboBoxFirstID.getSelectedIndex(), id, this.m_FirstAttributes);
        Instance inst2 = this.getInstance(this.m_SecondData, this.m_ComboBoxSecondID.getSelectedIndex(), id, this.m_SecondAttributes);
        managerComp.startUpdate();
        if (inst1 != null) {
            cont = managerComp.newContainer((Comparable)((Object)inst1));
            managerComp.add(cont);
        }
        if (inst2 != null) {
            cont = managerComp.newContainer((Comparable)((Object)inst2));
            managerComp.add(cont);
        }
        managerComp.finishUpdate();
        if (inst1 == null || inst2 == null) {
            this.showStatus("Instance only available in " + (inst1 != null ? "first" : "second") + " dataset!");
        } else if (inst1.size() != inst2.size()) {
            this.showStatus("Instances differ in size: " + inst1.size() + " != " + inst2.size());
        } else {
            this.showStatus("");
            Instance instDiff = new Instance();
            Iterator iter1 = inst1.iterator();
            Iterator iter2 = inst2.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                InstancePoint point1 = (InstancePoint)((Object)iter1.next());
                InstancePoint point2 = (InstancePoint)((Object)iter2.next());
                InstancePoint pointDiff = new InstancePoint(point1.getX(), point1.getY() - point2.getY());
                instDiff.add((DataPoint)pointDiff);
            }
            Report reportDiff = instDiff.getReport();
            double[] values1 = inst1.toDoubleArray();
            double[] values2 = inst2.toDoubleArray();
            Field field = new Field("Correlation coefficient", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.correlationCoefficient((double[])values1, (double[])values2));
            field = new Field("Root mean squared error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.rmse((double[])values1, (double[])values2));
            field = new Field("Root relative squared error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.rrse((double[])values1, (double[])values2));
            field = new Field("Mean absolute error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.mae((double[])values1, (double[])values2));
            field = new Field("Relative absolute error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.rae((double[])values1, (double[])values2));
            managerDiff.startUpdate();
            cont = managerComp.newContainer((Comparable)((Object)instDiff));
            cont.setID((String)this.m_ListCommonIDs.getSelectedValue());
            managerDiff.add(cont);
            managerDiff.finishUpdate();
            this.m_ReportTable.setModel((TableModel)ReportFactory.getModel((Report)reportDiff));
            this.m_ReportTable.setOptimalColumnWidth();
        }
    }

    protected void compareIDs() {
        HashSet<String> setFirst = new HashSet<String>(this.getIDs(this.m_FirstData, this.m_ComboBoxFirstID.getSelectedIndex()));
        HashSet<String> setSecond = new HashSet<String>(this.getIDs(this.m_SecondData, this.m_ComboBoxSecondID.getSelectedIndex()));
        HashSet<String> setCommon = new HashSet<String>(setFirst);
        setCommon.retainAll(setSecond);
        setFirst.removeAll(setCommon);
        setSecond.removeAll(setCommon);
        ArrayList<String> onlyFirst = new ArrayList<String>(setFirst);
        ArrayList<String> common = new ArrayList<String>(setCommon);
        ArrayList<String> onlySecond = new ArrayList<String>(setSecond);
        Collections.sort(onlyFirst);
        Collections.sort(common);
        Collections.sort(onlySecond);
        this.m_TextOnlyFirst.setText(Utils.flatten(onlyFirst, (String)"\n"));
        this.m_TextCommon.setText(Utils.flatten(common, (String)"\n"));
        this.m_TextOnlySecond.setText(Utils.flatten(onlySecond, (String)"\n"));
        this.m_TextOnlyFirst.setCaretPosition(0);
        this.m_TextCommon.setCaretPosition(0);
        this.m_TextOnlySecond.setCaretPosition(0);
        this.m_ModelCommonIDs.removeAllElements();
        for (String com : common) {
            this.m_ModelCommonIDs.addElement(com);
        }
    }

    protected void compareData() {
        this.compareIDs();
        this.compareInstances();
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        List<String> datasets = DatasetHelper.generateDatasetList(this.getOwner().getData());
        boolean changed = false;
        int indexFirst = DatasetHelper.indexOfDataset(this.getOwner().getData(), (String)this.m_ComboBoxFirstDataset.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelFirstDataset)) {
            this.m_ModelFirstDataset = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxFirstDataset.setModel(this.m_ModelFirstDataset);
            if (indexFirst == -1 && this.m_ModelFirstDataset.getSize() > 0) {
                this.m_ComboBoxFirstDataset.setSelectedIndex(0);
                changed = true;
            } else if (indexFirst > -1) {
                this.m_ComboBoxFirstDataset.setSelectedIndex(indexFirst);
            }
        }
        int indexSecond = DatasetHelper.indexOfDataset(this.getOwner().getData(), (String)this.m_ComboBoxSecondDataset.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelSecondDataset)) {
            this.m_ModelSecondDataset = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxSecondDataset.setModel(this.m_ModelSecondDataset);
            if (indexSecond == -1 && this.m_ModelSecondDataset.getSize() > 0) {
                this.m_ComboBoxSecondDataset.setSelectedIndex(0);
                changed = true;
            } else if (indexSecond > -1) {
                this.m_ComboBoxSecondDataset.setSelectedIndex(indexSecond);
            }
        }
        if (changed) {
            this.clear();
        }
        this.updateWidgets();
    }

    protected void clear() {
        this.m_TextStructure.setText("");
        this.m_FirstData = null;
        this.m_FirstAttributes.clear();
        this.m_SecondData = null;
        this.m_SecondAttributes.clear();
        this.m_ModelFirstID.removeAllElements();
        this.m_ModelSecondID.removeAllElements();
        this.m_TextOnlyFirst.setText("");
        this.m_TextCommon.setText("");
        this.m_TextOnlySecond.setText("");
        this.m_ModelCommonIDs.removeAllElements();
    }

    protected void updateWidgets() {
        boolean hasData = this.m_ComboBoxFirstDataset.getSelectedIndex() > -1 && this.m_ComboBoxSecondDataset.getSelectedIndex() > -1;
        this.m_ButtonStructure.setEnabled(hasData);
        this.m_TextStructure.setEnabled(hasData);
        boolean hasIDs = hasData && this.m_ComboBoxFirstID.getSelectedIndex() > -1 && this.m_ComboBoxSecondID.getSelectedIndex() > -1;
        this.m_ButtonData.setEnabled(hasIDs);
        this.m_TextOnlyFirst.setEnabled(hasIDs);
        this.m_TextCommon.setEnabled(hasIDs);
        this.m_TextOnlySecond.setEnabled(hasIDs);
    }

    @Override
    protected Map<String, Object> doSerialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.doSerialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_FIRST_DATASET, this.m_ComboBoxFirstDataset.getSelectedIndex());
            result.put(KEY_SECOND_DATASET, this.m_ComboBoxSecondDataset.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_FIRST_ATTRANGE, this.m_TextFirstRange.getText());
            result.put(KEY_SECOND_ATTRANGE, this.m_TextSecondRange.getText());
        }
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_FIRST_DATASET)) {
            this.m_ComboBoxFirstDataset.setSelectedIndex(((Number)data.get(KEY_FIRST_DATASET)).intValue());
        }
        if (data.containsKey(KEY_SECOND_DATASET)) {
            this.m_ComboBoxSecondDataset.setSelectedIndex(((Number)data.get(KEY_SECOND_DATASET)).intValue());
        }
        if (data.containsKey(KEY_FIRST_ATTRANGE)) {
            this.m_TextFirstRange.setText((String)data.get(KEY_FIRST_ATTRANGE));
        }
        if (data.containsKey(KEY_SECOND_ATTRANGE)) {
            this.m_TextSecondRange.setText((String)data.get(KEY_SECOND_ATTRANGE));
        }
    }
}

