/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.associatetab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.associatetab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.associatetab.output.AbstractOutputGenerator;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import weka.associations.AssociationRule;
import weka.associations.AssociationRulesProducer;

public class Rules
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;

    public String globalInfo() {
        return "Outputs the rules if available (associator must implement " + AssociationRulesProducer.class.getName() + ").";
    }

    @Override
    public String getTitle() {
        return "Rules";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasModel() && item.getModel() instanceof AssociationRulesProducer && ((AssociationRulesProducer)item.getModel()).canProduceRules();
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        if (!item.hasModel()) {
            errors.add("No model available!");
            return null;
        }
        if (!(item.getModel() instanceof AssociationRulesProducer)) {
            errors.add("Model does not implement " + AssociationRulesProducer.class.getName() + "!");
            return null;
        }
        if (!((AssociationRulesProducer)item.getModel()).canProduceRules()) {
            errors.add("Model cannot produce rules!");
            return null;
        }
        AssociationRulesProducer producer = (AssociationRulesProducer)item.getModel();
        StringBuilder rules = new StringBuilder();
        for (AssociationRule rule : producer.getAssociationRules().getRules()) {
            rules.append(rule.toString()).append("\n");
        }
        BaseTextArea text = new BaseTextArea();
        text.setEditable(false);
        text.setTextFont(Fonts.getMonospacedFont());
        text.setText(rules.toString());
        text.setCaretPosition(0);
        return new TextualContentPanel((JTextComponent)text, true);
    }
}

