/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.attseltab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.RunInformationHelper;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.attseltab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.attseltab.output.AbstractOutputGenerator;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class TextStatistics
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    protected boolean m_RunInformation;

    public String globalInfo() {
        return "Generates basic text statistic.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("run-information", "runInformation", (Object)false);
    }

    public void setRunInformation(boolean value) {
        this.m_RunInformation = value;
        this.reset();
    }

    public boolean getRunInformation() {
        return this.m_RunInformation;
    }

    public String runInformationTipText() {
        return "If set to true, then the run information is output as well.";
    }

    @Override
    public String getTitle() {
        return "Statistics";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return true;
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        StringBuilder buffer = new StringBuilder(item.getAttributeSelection().toResultsString());
        try {
            if (item.isCrossValidation()) {
                buffer.append(item.getAttributeSelection().CVResultsString());
            }
        }
        catch (Exception e) {
            errors.add("Failed to generate statistics!", (Throwable)e);
            return null;
        }
        if (this.m_RunInformation && item.hasRunInformation()) {
            buffer.append("\n\n=== Run information ===\n\n");
            buffer.append(RunInformationHelper.toString(item.getRunInformation().toSpreadSheet()));
        }
        BaseTextArea text = new BaseTextArea();
        text.setEditable(false);
        text.setTextFont(Fonts.getMonospacedFont());
        text.setText(buffer.toString());
        text.setCaretPosition(0);
        return new TextualContentPanel((JTextComponent)text, true);
    }
}

