/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.ClassLister;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetView;
import adams.flow.core.Token;
import adams.flow.transformer.SpreadSheetInsertColumn;
import adams.gui.chooser.SelectOptionPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.AbstractEvaluation;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.ml.data.InstancesView;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.time.StopWatch;
import weka.classifiers.Classifier;
import weka.core.Instances;

public abstract class AbstractClassifierEvaluation
extends AbstractEvaluation<ClassifyTab, ResultItem> {
    private static final long serialVersionUID = -5847790432092994409L;

    public abstract String canEvaluate(Classifier var1);

    public abstract ResultItem init(Classifier var1) throws Exception;

    protected abstract void doEvaluate(Classifier var1, ResultItem var2) throws Exception;

    public void evaluate(Classifier classifier, ResultItem item) throws Exception {
        StopWatch watch = new StopWatch();
        watch.start();
        this.doEvaluate(classifier, item);
        watch.stop();
        if (item.hasRunInformation()) {
            item.getRunInformation().add("Total time", (Object)((double)watch.getTime() / 1000.0 + "s"));
        }
    }

    protected void fillWithAttributeNames(SelectOptionPanel select, int index) {
        ArrayList<String> atts = new ArrayList<String>();
        if (index > -1 && index < ((ClassifyTab)this.getOwner()).getData().size()) {
            Instances data = ((DataContainer)((ClassifyTab)this.getOwner()).getData().get(index)).getData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                atts.add(data.attribute(i).name());
            }
            Collections.sort(atts);
        }
        select.setOptions(atts.toArray(new String[atts.size()]));
    }

    protected SpreadSheet transferAdditionalAttributes(SelectOptionPanel select, Instances data) {
        String[] atts = (String[])select.getCurrent();
        TIntArrayList indices = new TIntArrayList();
        for (String att : atts) {
            if (data.attribute(att) == null) continue;
            indices.add(data.attribute(att).index());
        }
        InstancesView iview = new InstancesView(data);
        SpreadSheetView sview = new SpreadSheetView((SpreadSheet)iview, null, indices.toArray());
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.getHeaderRow().assign((Row)sview.getHeaderRow());
        for (Row row : sview.rows()) {
            result.addRow().assign(row);
        }
        SpreadSheetInsertColumn insert = new SpreadSheetInsertColumn();
        insert.setHeader("Instance Index");
        insert.setNoCopy(false);
        insert.setPosition(new SpreadSheetColumnIndex("1"));
        insert.setAfter(false);
        insert.input(new Token((Object)result));
        String msg = insert.execute();
        if (msg != null) {
            this.getLogger().severe("Failed to transfer additional attributes!\n" + msg);
            return null;
        }
        Token token = insert.output();
        result = (SpreadSheet)token.getPayload();
        for (int i = 0; i < result.getRowCount(); ++i) {
            result.getRow(i).getCell(0).setContent(Integer.valueOf(i + 1));
        }
        return result;
    }

    public static Class[] getEvaluations() {
        return ClassLister.getSingleton().getClasses(AbstractClassifierEvaluation.class);
    }
}

