/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.InstancesIndexedSplitsRunsCompatibility;
import adams.data.io.input.AbstractIndexedSplitsRunsReader;
import adams.data.io.input.JsonIndexedSplitsRunsReader;
import adams.data.spreadsheet.MetaData;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.transformer.indexedsplitsrunsevaluation.InstancesIndexedSplitsRunsEvaluation;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.chooser.SelectOptionPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Capabilities;
import weka.core.Instances;

public class IndexedSplitsRunsEvaluation
extends AbstractClassifierEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_FILE = "file";
    public static final String KEY_READER = "reader";
    public static final String KEY_TRAINSPLIT = "train split";
    public static final String KEY_TESTSPLIT = "test split";
    public static final String KEY_LENIENT = "lenient";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected FileChooserPanel m_PanelFile;
    protected GenericObjectEditorPanel m_PanelReader;
    protected BaseTextField m_TextTrainSplitName;
    protected BaseTextField m_TextTestSplitName;
    protected BaseCheckBox m_CheckBoxLenient;
    protected SelectOptionPanel m_SelectAdditionalAttributes;
    protected DefaultComboBoxModel<String> m_ModelDatasets;

    public String globalInfo() {
        return "Performs the evaluation according to the provided indexed splits.";
    }

    @Override
    protected void initGUI() {
        JsonIndexedSplitsRunsReader reader;
        super.initGUI();
        Properties props = IndexedSplitsRunsEvaluation.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_PanelFile = new FileChooserPanel();
        this.m_PanelFile.setCurrentDirectory((File)new PlaceholderFile(props.getPath("Classify.IndexedSplitsRunsFile", "%c")));
        this.m_PanelFile.setAcceptAllFileFilterUsed(true);
        this.m_PanelFile.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Splits file", (Component)this.m_PanelFile);
        try {
            reader = (AbstractIndexedSplitsRunsReader)OptionUtils.forCommandLine(AbstractIndexedSplitsRunsReader.class, (String)props.getProperty("Classify.IndexedSplitsRunsReader", new JsonIndexedSplitsRunsReader().toCommandLine()));
        }
        catch (Exception e2) {
            reader = new JsonIndexedSplitsRunsReader();
        }
        this.m_PanelReader = new GenericObjectEditorPanel(AbstractIndexedSplitsRunsReader.class, (Object)reader, true);
        this.m_PanelReader.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Reader", (Component)this.m_PanelReader);
        this.m_TextTrainSplitName = new BaseTextField(props.getProperty("Classify.IndexedSplitsRunsTrainSplitName", "train"));
        this.m_TextTrainSplitName.setToolTipText("The name of the split to be used for training");
        this.m_PanelParameters.addParameter("Train split", (Component)this.m_TextTrainSplitName);
        this.m_TextTestSplitName = new BaseTextField(props.getProperty("Classify.IndexedSplitsRunsTestSplitName", "test"));
        this.m_TextTestSplitName.setToolTipText("The name of the split to be used for testing");
        this.m_PanelParameters.addParameter("Test split", (Component)this.m_TextTestSplitName);
        this.m_CheckBoxLenient = new BaseCheckBox();
        this.m_CheckBoxLenient.setSelected(props.getBoolean("Classify.IndexedSplitsRunsLenient", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxLenient.setToolTipText("Strict or lenient with checks?");
        this.m_CheckBoxLenient.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Lenient", (Component)this.m_CheckBoxLenient);
        this.m_SelectAdditionalAttributes = new SelectOptionPanel();
        this.m_SelectAdditionalAttributes.setCurrent((Object)new String[0]);
        this.m_SelectAdditionalAttributes.setMultiSelect(true);
        this.m_SelectAdditionalAttributes.setLenient(true);
        this.m_SelectAdditionalAttributes.setDialogTitle("Select additional attributes");
        this.m_SelectAdditionalAttributes.setToolTipText("Additional attributes to make available in plots");
        this.m_PanelParameters.addParameter("Additional attributes", (Component)this.m_SelectAdditionalAttributes);
    }

    @Override
    public String getName() {
        return "Indexed splits runs";
    }

    @Override
    public String canEvaluate(Classifier classifier) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        File file = (File)this.m_PanelFile.getCurrent();
        if (file.isDirectory()) {
            return "Splits file points to directory: " + file;
        }
        if (this.m_PanelReader.getCurrent() == null) {
            return "No splits reader defined!";
        }
        if (this.m_TextTrainSplitName.getText().isEmpty()) {
            return "No train split name provided!";
        }
        if (this.m_TextTestSplitName.getText().isEmpty()) {
            return "No test split name provided!";
        }
        Instances data = ((DataContainer)((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex())).getData();
        Capabilities caps = classifier.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Classifier cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Classifier cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Classifier classifier) throws Exception {
        Instances data = ((DataContainer)((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex())).getData();
        ResultItem result = new ResultItem(classifier, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Classifier classifier, ResultItem item) throws Exception {
        Classifier model = (Classifier)ObjectCopyHelper.copyObject((Object)classifier);
        String msg = this.canEvaluate(model);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate classifier!\n" + msg);
        }
        DataContainer dataCont = (DataContainer)((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        File file = (File)this.m_PanelFile.getCurrent();
        AbstractIndexedSplitsRunsReader reader = (AbstractIndexedSplitsRunsReader)this.m_PanelReader.getCurrent();
        String trainSplit = this.m_TextTrainSplitName.getText();
        String testSplit = this.m_TextTestSplitName.getText();
        boolean lenient = this.m_CheckBoxLenient.isSelected();
        MessageCollection errors = new MessageCollection();
        IndexedSplitsRuns runs = reader.read(file, errors);
        if (runs == null) {
            if (errors.isEmpty()) {
                ((ClassifyTab)this.getOwner()).logError("Failed to load indexed splits runs from: " + file, "Failed to load splits");
            } else {
                ((ClassifyTab)this.getOwner()).logError("Failed to load indexed splits runs from: " + file + "\n" + errors, "Failed to load splits");
            }
            return;
        }
        InstancesIndexedSplitsRunsCompatibility comp = new InstancesIndexedSplitsRunsCompatibility();
        comp.setLenient(lenient);
        msg = comp.isCompatible(data, runs);
        if (msg != null) {
            ((ClassifyTab)this.getOwner()).logError("Loaded indexed splits runs are not compatible with selected dataset!\n" + msg, "Splits not compatible");
            return;
        }
        ((ClassifyTab)this.getOwner()).logMessage("Using '" + dataCont.getID() + "/" + data.relationName() + "' to build " + OptionUtils.getCommandLine((Object)classifier));
        errors = new MessageCollection();
        InstancesIndexedSplitsRunsEvaluation eval = new InstancesIndexedSplitsRunsEvaluation();
        eval.setManualClassifier(classifier);
        eval.setTrainSplitName(trainSplit);
        eval.setTestSplitName(testSplit);
        WekaEvaluationContainer[] conts = (WekaEvaluationContainer[])eval.evaluate(data, runs, errors);
        if (conts == null) {
            if (errors.isEmpty()) {
                ((ClassifyTab)this.getOwner()).logError("Failed to evaluate indexed splits runs!", "Failed to evaluate splits");
            } else {
                ((ClassifyTab)this.getOwner()).logError("Failed to evaluate indexed splits runs:\n" + errors, "Failed to evaluate splits");
            }
            return;
        }
        MetaData runInfo = new MetaData();
        runInfo.add("Classifier", (Object)OptionUtils.getCommandLine((Object)classifier));
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        runInfo.add("Class attribute", (Object)data.classAttribute().name());
        if (conts.length > 1) {
            runInfo.add("Run", (Object)1);
        }
        item.update((Evaluation)conts[0].getValue("Evaluation"), null, runInfo, null, this.transferAdditionalAttributes(this.m_SelectAdditionalAttributes, data));
        if (conts.length > 1) {
            item.setNameSuffix("run #1");
            for (int i = 1; i < conts.length; ++i) {
                runInfo = runInfo.getClone();
                runInfo.add("Run", (Object)(i + 1));
                ResultItem nested = new ResultItem(item.getTemplate(), item.getHeader());
                nested.setNameSuffix("run #" + (i + 1));
                nested.update((Evaluation)conts[i].getValue("Evaluation"), null, runInfo, null, this.transferAdditionalAttributes(this.m_SelectAdditionalAttributes, data));
                item.addNestedItem(item.getName() + "run #" + (i + 1), nested);
            }
        }
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClassifyTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClassifyTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClassifyTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.fillWithAttributeNames(this.m_SelectAdditionalAttributes, this.m_ComboBoxDatasets.getSelectedIndex());
        ((ClassifyTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_FILE, ((File)this.m_PanelFile.getCurrent()).getAbsolutePath());
            result.put(KEY_READER, OptionUtils.getCommandLine((Object)this.m_PanelReader.getCurrent()));
            result.put(KEY_TRAINSPLIT, this.m_TextTrainSplitName.getText());
            result.put(KEY_TESTSPLIT, this.m_TextTestSplitName.getText());
            result.put(KEY_LENIENT, this.m_CheckBoxLenient.isSelected());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_FILE)) {
            this.m_PanelFile.setCurrent((File)new PlaceholderFile((String)data.get(KEY_FILE)));
        }
        if (data.containsKey(KEY_READER)) {
            try {
                this.m_PanelReader.setCurrent((Object)OptionUtils.forCommandLine(AbstractIndexedSplitsRunsReader.class, (String)((String)data.get(KEY_READER))));
            }
            catch (Exception e) {
                errors.add("Failed to parse reader commandline: " + data.get(KEY_READER), (Throwable)e);
            }
        }
        if (data.containsKey(KEY_TRAINSPLIT)) {
            this.m_TextTrainSplitName.setText((String)data.get(KEY_TRAINSPLIT));
        }
        if (data.containsKey(KEY_TESTSPLIT)) {
            this.m_TextTestSplitName.setText((String)data.get(KEY_TESTSPLIT));
        }
        if (data.containsKey(KEY_LENIENT)) {
            this.m_CheckBoxLenient.setSelected(((Boolean)data.get(KEY_LENIENT)).booleanValue());
        }
    }
}

