/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.gui.chooser.SelectOptionPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.classifiers.Classifier;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomSplitGenerator;
import weka.classifiers.TestingHelper;
import weka.core.Capabilities;
import weka.core.Instances;

public class TrainTestSplit
extends AbstractClassifierEvaluation {
    private static final long serialVersionUID = -4460266467650893551L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_PERCENTAGE = "percentage";
    public static final String KEY_SEED = "seed";
    public static final String KEY_PRESERVEORDER = "preserveorder";
    public static final String KEY_ADDITIONAL = "additional";
    public static final String KEY_USEVIEWS = "useviews";
    public static final String KEY_GENERATOR = "generator";
    public static final String KEY_DISCARDPREDICTIONS = "discardpredictions";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected NumberTextField m_TextPercentage;
    protected BaseCheckBox m_CheckBoxPreserveOrder;
    protected NumberTextField m_TextSeed;
    protected SelectOptionPanel m_SelectAdditionalAttributes;
    protected BaseCheckBox m_CheckBoxUseViews;
    protected GenericObjectEditorPanel m_GOEGenerator;
    protected BaseCheckBox m_CheckBoxDiscardPredictions;

    public String globalInfo() {
        return "Generates train/test sets from the selected dataset using the specified split percentage and builds/evaluates the classifier accordingly.";
    }

    @Override
    protected void initGUI() {
        RandomSplitGenerator generator;
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_TextPercentage = new NumberTextField(NumberTextField.Type.DOUBLE, "" + props.getDouble("Classify.TrainPercentage", Double.valueOf(66.0)));
        this.m_TextPercentage.setToolTipText("Percentage for train set (0 < x < 100)");
        this.m_TextPercentage.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Percentage", (Component)this.m_TextPercentage);
        this.m_CheckBoxPreserveOrder = new BaseCheckBox();
        this.m_CheckBoxPreserveOrder.setSelected(props.getBoolean("Classify.PreserveOrder", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxPreserveOrder.setToolTipText("No randomization is performed if checked");
        this.m_CheckBoxPreserveOrder.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Preserve order", (Component)this.m_CheckBoxPreserveOrder);
        this.m_TextSeed = new NumberTextField(NumberTextField.Type.INTEGER, "" + props.getInteger("Classify.Seed", Integer.valueOf(1)));
        this.m_TextSeed.setToolTipText("The seed value for randomizing the data");
        this.m_TextSeed.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Seed", (Component)this.m_TextSeed);
        this.m_SelectAdditionalAttributes = new SelectOptionPanel();
        this.m_SelectAdditionalAttributes.setCurrent((Object)new String[0]);
        this.m_SelectAdditionalAttributes.setMultiSelect(true);
        this.m_SelectAdditionalAttributes.setLenient(true);
        this.m_SelectAdditionalAttributes.setDialogTitle("Select additional attributes");
        this.m_SelectAdditionalAttributes.setToolTipText("Additional attributes to make available in plots");
        this.m_PanelParameters.addParameter("Additional attributes", (Component)this.m_SelectAdditionalAttributes);
        try {
            generator = (RandomSplitGenerator)OptionUtils.forCommandLine(RandomSplitGenerator.class, (String)props.getProperty("Classify.TrainTestSplitGenerator", new DefaultRandomSplitGenerator().toCommandLine()));
        }
        catch (Exception e2) {
            generator = new DefaultRandomSplitGenerator();
        }
        this.m_GOEGenerator = new GenericObjectEditorPanel(RandomSplitGenerator.class, (Object)generator, true);
        this.m_GOEGenerator.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Generator", (Component)this.m_GOEGenerator);
        this.m_CheckBoxUseViews = new BaseCheckBox();
        this.m_CheckBoxUseViews.setSelected(props.getBoolean("Classify.UseViews", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxUseViews.setToolTipText("Save memory by using views instead of creating copies of datasets?");
        this.m_CheckBoxUseViews.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Use views", (Component)this.m_CheckBoxUseViews);
        this.m_CheckBoxDiscardPredictions = new BaseCheckBox();
        this.m_CheckBoxDiscardPredictions.setSelected(props.getBoolean("Classify.DiscardPredictions", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxDiscardPredictions.setToolTipText("Save memory by discarding predictions?");
        this.m_CheckBoxDiscardPredictions.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Discard predictions", (Component)this.m_CheckBoxDiscardPredictions);
    }

    @Override
    public String getName() {
        return "Train/test split";
    }

    @Override
    public String canEvaluate(Classifier classifier) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        if (!Utils.isInteger((String)this.m_TextSeed.getText())) {
            return "Seed value is not an integer!";
        }
        if (!Utils.isDouble((String)this.m_TextPercentage.getText())) {
            return "Percentage is not a number!";
        }
        double perc = Utils.toDouble((String)this.m_TextPercentage.getText());
        if (perc <= 0.0 || perc >= 100.0) {
            return "Percentage must satisfy 0 < x < 100!";
        }
        Instances data = ((DataContainer)((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex())).getData();
        Capabilities caps = classifier.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Classifier cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Classifier cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Classifier classifier) throws Exception {
        Instances data = ((DataContainer)((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex())).getData();
        ResultItem result = new ResultItem(classifier, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(final Classifier classifier, ResultItem item) throws Exception {
        String msg = this.canEvaluate(classifier);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate classifier!\n" + msg);
        }
        DataContainer dataCont = (DataContainer)((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        double perc = this.m_TextPercentage.getValue().doubleValue() / 100.0;
        int seed = this.m_TextSeed.getValue().intValue();
        boolean views = this.m_CheckBoxUseViews.isSelected();
        boolean discard = this.m_CheckBoxDiscardPredictions.isSelected();
        RandomSplitGenerator generator = (RandomSplitGenerator)this.m_GOEGenerator.getCurrent();
        generator.setData(data);
        generator.setSeed(seed);
        generator.setPercentage(perc);
        generator.setPreserveOrder(this.m_CheckBoxPreserveOrder.isSelected());
        generator.setUseViews(views);
        WekaTrainTestSetContainer cont = generator.next();
        Instances train = (Instances)cont.getValue("Train");
        final Instances test = (Instances)cont.getValue("Test");
        MetaData runInfo = new MetaData();
        runInfo.add("Classifier", (Object)OptionUtils.getCommandLine((Object)classifier));
        runInfo.add("Seed", (Object)seed);
        runInfo.add("Split percentage", (Object)perc);
        runInfo.add("Order preserved", (Object)this.m_CheckBoxPreserveOrder.isSelected());
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances (train)", (Object)train.numInstances());
        runInfo.add("# Instances (test)", (Object)test.numInstances());
        runInfo.add("Class attribute", (Object)data.classAttribute().name());
        runInfo.add("Discard predictions", (Object)discard);
        runInfo.add("Use views", (Object)views);
        runInfo.add("Generator", (Object)generator.toCommandLine());
        if (((String[])this.m_SelectAdditionalAttributes.getCurrent()).length > 0) {
            runInfo.add("Additional attributes: ", (Object)Utils.flatten((Object[])((Object[])this.m_SelectAdditionalAttributes.getCurrent()), (String)", "));
        }
        Classifier model = (Classifier)ObjectCopyHelper.copyObject((Object)classifier);
        ((ClassifyTab)this.getOwner()).logMessage("Using " + this.m_TextPercentage.getText() + "% of '" + dataCont.getID() + "/" + train.relationName() + "' to train " + OptionUtils.getCommandLine((Object)classifier));
        model.buildClassifier(train);
        this.addObjectSize(runInfo, "Model size", model);
        ((ClassifyTab)this.getOwner()).logMessage("Using remainder from '" + dataCont.getID() + "/" + test.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)classifier));
        Evaluation eval = new Evaluation(train);
        eval.setDiscardPredictions(discard);
        eval = new Evaluation(train);
        eval.setDiscardPredictions(discard);
        TestingHelper.evaluateModel(model, test, eval, this.getTestingUpdateInterval(), new TestingHelper.TestingUpdateListener(){

            @Override
            public void testingUpdateRequested(Instances data, int numTested, int numTotal) {
                ((ClassifyTab)TrainTestSplit.this.getOwner()).logMessage("Used " + numTested + "/" + numTotal + " of '" + test.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)classifier));
            }
        });
        item.update(eval, model, runInfo, null, this.transferAdditionalAttributes(this.m_SelectAdditionalAttributes, test));
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClassifyTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClassifyTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClassifyTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.fillWithAttributeNames(this.m_SelectAdditionalAttributes, this.m_ComboBoxDatasets.getSelectedIndex());
        ((ClassifyTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_PERCENTAGE, this.m_TextPercentage.getValue().doubleValue());
            result.put(KEY_SEED, this.m_TextSeed.getValue().intValue());
            result.put(KEY_PRESERVEORDER, this.m_CheckBoxPreserveOrder.isSelected());
            result.put(KEY_ADDITIONAL, this.m_SelectAdditionalAttributes.getCurrent());
            result.put(KEY_USEVIEWS, this.m_CheckBoxUseViews.isSelected());
            result.put(KEY_GENERATOR, OptionUtils.getCommandLine((Object)this.m_GOEGenerator.getCurrent()));
            result.put(KEY_DISCARDPREDICTIONS, this.m_CheckBoxDiscardPredictions.isSelected());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_PERCENTAGE)) {
            this.m_TextPercentage.setValue((Number)((Number)data.get(KEY_PERCENTAGE)).doubleValue());
        }
        if (data.containsKey(KEY_SEED)) {
            this.m_TextSeed.setValue((Number)((Number)data.get(KEY_SEED)).intValue());
        }
        if (data.containsKey(KEY_PRESERVEORDER)) {
            this.m_CheckBoxPreserveOrder.setSelected(((Boolean)data.get(KEY_PRESERVEORDER)).booleanValue());
        }
        if (data.containsKey(KEY_ADDITIONAL)) {
            this.m_SelectAdditionalAttributes.setCurrent((Object)this.listOrArray(data.get(KEY_ADDITIONAL)));
        }
        if (data.containsKey(KEY_USEVIEWS)) {
            this.m_CheckBoxUseViews.setSelected(((Boolean)data.get(KEY_USEVIEWS)).booleanValue());
        }
        if (data.containsKey(KEY_GENERATOR)) {
            try {
                this.m_GOEGenerator.setCurrent((Object)OptionUtils.forCommandLine(RandomSplitGenerator.class, (String)((String)data.get(KEY_GENERATOR))));
            }
            catch (Exception e) {
                errors.add("Failed to parse generator commandline: " + data.get(KEY_GENERATOR), (Throwable)e);
            }
        }
        if (data.containsKey(KEY_DISCARDPREDICTIONS)) {
            this.m_CheckBoxDiscardPredictions.setSelected(((Boolean)data.get(KEY_DISCARDPREDICTIONS)).booleanValue());
        }
    }
}

