/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.base.BaseString;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.ConfusionMatrix;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.CellRenderingCustomizer;
import adams.gui.core.spreadsheettable.ConfusionMatrixCellRenderingCustomizer;
import adams.gui.tools.wekainvestigator.output.TableContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.PredictionHelper;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGeneratorWithSeparateFoldsSupport;
import java.util.ArrayList;
import weka.classifiers.Evaluation;

public class ConfusionMatrix
extends AbstractOutputGeneratorWithSeparateFoldsSupport<TableContentPanel> {
    private static final long serialVersionUID = -6829245659118360739L;
    protected ConfusionMatrix.MatrixValues m_MatrixValues;
    protected boolean m_UseProbabilities;
    protected CellRenderingCustomizer m_CellRenderingCustomizer;
    protected int m_NumDecimals;

    public String globalInfo() {
        return "Generates a confusion matrix.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("matrix-values", "matrixValues", (Object)ConfusionMatrix.MatrixValues.COUNTS);
        this.m_OptionManager.add("use-probabilities", "useProbabilities", (Object)false);
        this.m_OptionManager.add("cell-rendering-customizer", "cellRenderingCustomizer", (Object)new ConfusionMatrixCellRenderingCustomizer());
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)-1, (Number)-1, null);
    }

    public void setMatrixValues(ConfusionMatrix.MatrixValues value) {
        this.m_MatrixValues = value;
        this.reset();
    }

    public ConfusionMatrix.MatrixValues getMatrixValues() {
        return this.m_MatrixValues;
    }

    public String matrixValuesTipText() {
        return "The type of values to generate.";
    }

    public void setUseProbabilities(boolean value) {
        this.m_UseProbabilities = value;
        this.reset();
    }

    public boolean getUseProbabilities() {
        return this.m_UseProbabilities;
    }

    public String useProbabilitiesTipText() {
        return "If set to true, the probabilities are used for the counts rather than 0 and 1.";
    }

    public void setCellRenderingCustomizer(CellRenderingCustomizer value) {
        this.m_CellRenderingCustomizer = value;
        this.reset();
    }

    public CellRenderingCustomizer getCellRenderingCustomizer() {
        return this.m_CellRenderingCustomizer;
    }

    public String cellRenderingCustomizerTipText() {
        return "The customizer for the cell rendering.";
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals to use; -1 for automatic.";
    }

    @Override
    public String getTitle() {
        return "Confusion matrix";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null && item.getEvaluation().getHeader() != null && item.getEvaluation().getHeader().classAttribute().isNominal();
    }

    @Override
    protected TableContentPanel createOutput(Evaluation eval, MessageCollection errors) {
        String msg;
        if (!eval.getHeader().classAttribute().isNominal()) {
            return null;
        }
        ArrayList<BaseString> labels = new ArrayList<BaseString>();
        for (int i = 0; i < eval.getHeader().classAttribute().numValues(); ++i) {
            labels.add(new BaseString(eval.getHeader().classAttribute().value(i)));
        }
        SpreadSheet sheet = PredictionHelper.toSpreadSheet((LoggingSupporter)this, errors, eval, null, null, false, false, true, false, false);
        if (sheet == null) {
            if (errors.isEmpty()) {
                errors.add("Failed to generate predictions!");
            }
            return null;
        }
        adams.flow.transformer.ConfusionMatrix matrix = new adams.flow.transformer.ConfusionMatrix();
        matrix.setMatrixValues(this.m_MatrixValues);
        matrix.setActualColumn(new SpreadSheetColumnIndex("Actual"));
        matrix.setPredictedColumn(new SpreadSheetColumnIndex("Predicted"));
        matrix.setClassLabels(labels.toArray(new BaseString[0]));
        if (this.m_UseProbabilities) {
            matrix.setProbabilityColumn(new SpreadSheetColumnIndex("Probability"));
        }
        if ((msg = matrix.setUp()) != null) {
            errors.add(msg);
            return null;
        }
        matrix.input(new Token((Object)sheet));
        msg = matrix.execute();
        if (msg != null) {
            errors.add(msg);
            return null;
        }
        sheet = (SpreadSheet)matrix.output().getPayload(SpreadSheet.class);
        SpreadSheetTable table = new SpreadSheetTable(sheet);
        table.setCellRenderingCustomizer((CellRenderingCustomizer)ObjectCopyHelper.copyObject((Object)this.m_CellRenderingCustomizer));
        table.setNumDecimals(this.m_NumDecimals);
        return new TableContentPanel((SortableAndSearchableTable)table, true, true);
    }
}

