/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.SimplePlot;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGeneratorWithSeparateFoldsSupport;
import java.util.ArrayList;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.Prediction;

public class ResidualsVsFitted
extends AbstractOutputGeneratorWithSeparateFoldsSupport<ComponentContentPanel> {
    private static final long serialVersionUID = -8530631855400627283L;

    public String globalInfo() {
        return "Plots the residuals vs the fitted values (= predictions).";
    }

    @Override
    public String getTitle() {
        return "Residuals vs Fitted";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null && item.getEvaluation().getHeader() != null && item.getEvaluation().getHeader().classAttribute().isNumeric();
    }

    @Override
    protected ComponentContentPanel createOutput(Evaluation eval, MessageCollection errors) {
        ArrayList<SequencePlotterContainer> points = new ArrayList<SequencePlotterContainer>();
        String name = eval.getHeader().relationName();
        for (Prediction pred : eval.predictions()) {
            SequencePlotterContainer point = new SequencePlotterContainer(name, (Comparable)Double.valueOf(pred.predicted()), (Comparable)Double.valueOf(pred.actual() - pred.predicted()));
            points.add(point);
        }
        SimplePlot plot = new SimplePlot();
        plot.setTitle("Residuals vs Fitted");
        plot.getAxisX().setLabel("Fitted");
        plot.getAxisY().setLabel("Residuals");
        AbstractDisplayPanel panel = plot.createDisplayPanel(new Token((Object)points.toArray(new SequencePlotterContainer[0])));
        panel.wrapUp();
        return new ComponentContentPanel((JComponent)panel, plot.displayPanelRequiresScrollPane());
    }
}

