/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.evaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClusterTab;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.evaluation.AbstractClustererEvaluation;
import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.MakeDensityBasedClusterer;
import weka.core.Capabilities;
import weka.core.Instances;

public class CrossValidation
extends AbstractClustererEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_FOLDS = "folds";
    public static final String KEY_SEED = "seed";
    public static final String KEY_FINALMODEL = "finalmodel";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected JSpinner m_SpinnerFolds;
    protected NumberTextField m_TextSeed;
    protected BaseCheckBox m_CheckBoxFinalModel;

    public String globalInfo() {
        return "Cross-validates the clusterer on the selected dataset.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = CrossValidation.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_SpinnerFolds = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerFolds.getModel()).setMinimum(Integer.valueOf(2));
        ((SpinnerNumberModel)this.m_SpinnerFolds.getModel()).setStepSize(1);
        this.m_SpinnerFolds.setValue(props.getInteger("Cluster.NumFolds", Integer.valueOf(10)));
        this.m_SpinnerFolds.setToolTipText("The number of folds to use (>= 2)");
        this.m_SpinnerFolds.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Folds", (Component)this.m_SpinnerFolds);
        this.m_TextSeed = new NumberTextField(NumberTextField.Type.INTEGER, "" + props.getInteger("Cluster.Seed", Integer.valueOf(1)));
        this.m_TextSeed.setToolTipText("The seed value for randomizing the data");
        this.m_TextSeed.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Seed", (Component)this.m_TextSeed);
        this.m_CheckBoxFinalModel = new BaseCheckBox();
        this.m_CheckBoxFinalModel.setSelected(props.getBoolean("Cluster.CrossValidationFinalModel", Boolean.valueOf(true)).booleanValue());
        this.m_CheckBoxFinalModel.setToolTipText("Produce a final model using the full training data?");
        this.m_CheckBoxFinalModel.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Final model", (Component)this.m_CheckBoxFinalModel);
    }

    @Override
    public String getName() {
        return "Cross-validation";
    }

    @Override
    public String canEvaluate(Clusterer clusterer) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        if (!Utils.isInteger((String)this.m_TextSeed.getText())) {
            return "Seed value is not an integer!";
        }
        Instances data = ((DataContainer)((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex())).getData();
        Capabilities caps = clusterer.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Clusterer cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Clusterer cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Clusterer clusterer) throws Exception {
        Instances data = ((DataContainer)((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex())).getData();
        ResultItem result = new ResultItem(clusterer, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Clusterer clusterer, ResultItem item) throws Exception {
        DensityBasedClusterer density;
        String msg = this.canEvaluate(clusterer);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate clusterer!\n" + msg);
        }
        DataContainer dataCont = (DataContainer)((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        boolean finalModel = this.m_CheckBoxFinalModel.isSelected();
        int seed = this.m_TextSeed.getValue().intValue();
        int folds = ((Number)this.m_SpinnerFolds.getValue()).intValue();
        Clusterer cls = (Clusterer)ObjectCopyHelper.copyObject((Object)clusterer);
        if (cls instanceof DensityBasedClusterer) {
            density = (DensityBasedClusterer)cls;
        } else {
            density = new MakeDensityBasedClusterer();
            ((MakeDensityBasedClusterer)density).setClusterer(cls);
        }
        MetaData runInfo = new MetaData();
        runInfo.add("Clusterer", (Object)OptionUtils.getCommandLine((Object)clusterer));
        runInfo.add("Seed", (Object)seed);
        runInfo.add("Folds", (Object)folds);
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        Double logLikeliHood = ClusterEvaluation.crossValidateModel((DensityBasedClusterer)density, (Instances)data, (int)folds, (Random)new Random(seed));
        Clusterer model = null;
        if (finalModel) {
            ((ClusterTab)this.getOwner()).logMessage("Building final model on '" + data.relationName() + "' using " + OptionUtils.getCommandLine((Object)clusterer));
            model = (Clusterer)ObjectCopyHelper.copyObject((Object)clusterer);
            model.buildClusterer(data);
            this.addObjectSize(runInfo, "Final model size", model);
        }
        item.update("Cross-validation", (Serializable)((Object)("Log-likelihood: " + logLikeliHood)), model, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClusterTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClusterTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        ((ClusterTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_FOLDS, this.m_SpinnerFolds.getValue());
            result.put(KEY_SEED, this.m_TextSeed.getValue().intValue());
            result.put(KEY_FINALMODEL, this.m_CheckBoxFinalModel.isSelected());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_FOLDS)) {
            this.m_SpinnerFolds.setValue(data.get(KEY_FOLDS));
        }
        if (data.containsKey(KEY_SEED)) {
            this.m_TextSeed.setValue((Number)((Number)data.get(KEY_SEED)).intValue());
        }
        if (data.containsKey(KEY_FINALMODEL)) {
            this.m_CheckBoxFinalModel.setSelected(((Boolean)data.get(KEY_FINALMODEL)).booleanValue());
        }
    }
}

