/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.setup;

import adams.core.io.PlaceholderFile;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseListWithButtons;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractSetupOptionPanel;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;

public class DatasetPanel
extends AbstractSetupOptionPanel {
    private static final long serialVersionUID = -832431512063524253L;
    protected WekaFileChooser m_FileChooser;
    protected BaseButton m_ButtonAdd;
    protected BaseButton m_ButtonEdit;
    protected BaseButton m_ButtonRemove;
    protected BaseButton m_ButtonRemoveAll;
    protected BaseButton m_ButtonUp;
    protected BaseButton m_ButtonDown;
    protected BaseListWithButtons m_List;
    protected DefaultListModel<File> m_Model;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new WekaFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_FileChooser.setCurrentDirectory(new File(ExperimenterPanel.getProperties().getPath("Datasets.InitialDir", "%c")));
        this.m_Model = new DefaultListModel();
    }

    protected void initGUI() {
        super.initGUI();
        this.m_List = new BaseListWithButtons(this.m_Model);
        this.add((Component)this.m_List, "Center");
        this.m_ButtonAdd = new BaseButton("Add...");
        this.m_ButtonAdd.addActionListener(e -> {
            int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
            if (retVal != 0) {
                return;
            }
            if (this.m_FileChooser.getSelectedFiles().length == 0) {
                return;
            }
            for (File file : this.m_FileChooser.getSelectedFiles()) {
                this.m_Model.addElement(file);
            }
            this.modified();
        });
        this.m_ButtonEdit = new BaseButton("Edit...");
        this.m_ButtonEdit.addActionListener(e -> {
            int index = this.m_List.getSelectedIndex();
            File current = this.m_Model.get(index);
            this.m_FileChooser.setSelectedFile(current);
            int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
            if (retVal != 0) {
                return;
            }
            if (this.m_FileChooser.getSelectedFiles().length != 1) {
                return;
            }
            this.m_Model.set(index, this.m_FileChooser.getSelectedFile());
            this.modified();
        });
        this.m_ButtonRemove = new BaseButton("Remove");
        this.m_ButtonRemove.addActionListener(e -> {
            int[] indices = this.m_List.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.m_Model.remove(indices[i]);
            }
            this.modified();
        });
        this.m_ButtonRemoveAll = new BaseButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(e -> {
            this.m_Model.clear();
            this.modified();
        });
        this.m_ButtonUp = new BaseButton("Up");
        this.m_ButtonUp.addActionListener(e -> {
            this.m_List.moveUp();
            this.modified();
        });
        this.m_ButtonDown = new BaseButton("Down");
        this.m_ButtonDown.addActionListener(e -> {
            this.m_List.moveDown();
            this.modified();
        });
        this.m_List.addToButtonsPanel((Component)this.m_ButtonAdd);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonEdit);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemoveAll);
        this.m_List.addToButtonsPanel((Component)new JLabel(""));
        this.m_List.addToButtonsPanel((Component)this.m_ButtonUp);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonDown);
        this.m_List.setDoubleClickButton(this.m_ButtonEdit);
        this.m_List.addListSelectionListener(e -> this.update());
    }

    @Override
    protected void ownerChanged() {
        super.ownerChanged();
        if (this.getOwner() != null) {
            this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(ExperimenterPanel.getProperties().getPath("DatasetsInitialDir", "%h")).getAbsoluteFile().getAbsoluteFile());
        }
    }

    public void setFiles(File[] value) {
        this.m_IgnoreChanges = true;
        this.m_Model.clear();
        for (File file : value) {
            this.m_Model.addElement(file);
        }
        this.m_IgnoreChanges = false;
    }

    public File[] getFiles() {
        File[] result = new File[this.m_Model.getSize()];
        for (int i = 0; i < this.m_Model.getSize(); ++i) {
            result[i] = this.m_Model.getElementAt(i);
        }
        return result;
    }

    @Override
    protected void update() {
        super.update();
        int[] indices = this.m_List.getSelectedIndices();
        this.m_ButtonEdit.setEnabled(indices.length == 1);
        this.m_ButtonRemove.setEnabled(indices.length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_Model.getSize() > 0);
        this.m_ButtonUp.setEnabled(this.m_List.canMoveUp());
        this.m_ButtonDown.setEnabled(this.m_List.canMoveDown());
    }
}

