/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.inspectionhandler;

import adams.flow.core.EvaluationStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.WekaEvaluationValues;
import adams.gui.visualization.debug.inspectionhandler.AbstractInspectionHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import nz.ac.waikato.cms.locator.ClassLocator;
import weka.classifiers.Evaluation;

public class WekaEvaluation
extends AbstractInspectionHandler {
    public boolean handles(Class cls) {
        return ClassLocator.isSubclass(Evaluation.class, (Class)cls);
    }

    public Hashtable<String, Object> inspect(Object obj) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        Evaluation eval = (Evaluation)obj;
        result.put("header", eval.getHeader());
        result.put("predictions", eval.predictions());
        boolean nominal = eval.getHeader().classAttribute().isNominal();
        boolean numeric = eval.getHeader().classAttribute().isNumeric();
        ArrayList<EvaluationStatistic> stats = new ArrayList<EvaluationStatistic>();
        for (EvaluationStatistic stat : EvaluationStatistic.values()) {
            if (nominal && stat.isOnlyNominal()) {
                stats.add(stat);
                continue;
            }
            if (numeric && stat.isOnlyNumeric()) {
                stats.add(stat);
                continue;
            }
            if (stat.isOnlyNumeric() || stat.isOnlyNominal()) continue;
            stats.add(stat);
        }
        WekaEvaluationValues values = new WekaEvaluationValues();
        values.setStatisticValues(stats.toArray(new EvaluationStatistic[stats.size()]));
        values.input(new Token((Object)eval));
        String msg = values.execute();
        if (msg == null) {
            Token token = values.output();
            if (token != null) {
                result.put("statistics", token.getPayload());
            }
        } else {
            System.err.println(((Object)((Object)this)).getClass().getName() + ": Failed to extract statistics:\n" + msg);
        }
        return result;
    }
}

