/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.AbstractDistanceBasedHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstanceContainerModel;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class InstancePointHitDetector
extends AbstractDistanceBasedHitDetector<List<InstancePoint>, String> {
    private static final long serialVersionUID = 3397379783536355060L;
    protected InstancePanel m_Owner;

    public InstancePointHitDetector(InstancePanel owner) {
        this.m_Owner = owner;
    }

    public String globalInfo() {
        return "Detects selections of instance points in the instance panel.";
    }

    public InstancePanel getOwner() {
        return this.m_Owner;
    }

    protected int[] findEnclosingAttributeIndices(Instance inst, double x) {
        int[] result = new int[]{-1, -1};
        if (Math.floor(x) == x) {
            result[0] = (int)x;
        } else {
            result[0] = (int)Math.floor(x);
            result[1] = (int)Math.ceil(x);
        }
        for (int i = 0; i < 2; ++i) {
            if (result[i] >= 0 && result[i] < inst.size()) continue;
            result[i] = -1;
        }
        return result;
    }

    protected int findClosestAttributeIndex(Instance inst, double x) {
        int result = (int)Math.round(x);
        if (result < 0) {
            result = 0;
        } else if (result > inst.size() - 1) {
            result = inst.size() - 1;
        }
        return result;
    }

    protected InstancePoint findInstancePoint(Instance inst, int index) {
        InstancePoint result = null;
        List list = inst.toList();
        for (int i = 0; i < list.size(); ++i) {
            if (((InstancePoint)((Object)list.get(i))).getX() != index) continue;
            result = (InstancePoint)((Object)list.get(i));
            break;
        }
        return result;
    }

    protected List<InstancePoint> isHit(MouseEvent e) {
        ArrayList<InstancePoint> result = new ArrayList<InstancePoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double y = axisLeft.posToValue(e.getY());
        double x = axisBottom.posToValue(e.getX());
        InstanceContainerModel model = (InstanceContainerModel)this.m_Owner.getContainerList().getContainerModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            InstancePoint ip;
            if (!((InstanceContainer)model.getContainerAt(i)).isVisible()) continue;
            Instance inst = ((InstanceContainer)model.getContainerAt(i)).getData();
            int[] indices = this.findEnclosingAttributeIndices(inst, x);
            if (indices[0] < 0 || indices[1] < 0) {
                int index = this.findClosestAttributeIndex(inst, x);
                ip = this.findInstancePoint(inst, index);
                if (ip == null) {
                    this.getLogger().info("Failed to determine instance point for attribute index #" + index + ": " + inst);
                    continue;
                }
                double diffX = (double)ip.getX().intValue() - x;
                int diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0.0));
                this.getLogger().info("diff timestamp=" + diffPixel);
                if (diffPixel > this.m_MinimumPixelDifference) continue;
                double diffY = ip.getY() - y;
                diffPixel = Math.abs(axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0.0));
                this.getLogger().info("diff abundance=" + diffPixel);
                if (diffPixel > this.m_MinimumPixelDifference) continue;
                result.add(ip);
                continue;
            }
            ip = this.findInstancePoint(inst, indices[0]);
            if (ip == null) {
                this.getLogger().info("Failed to determine instance point for attribute index #" + indices[0] + ": " + inst);
                continue;
            }
            InstancePoint ip2 = this.findInstancePoint(inst, indices[1]);
            if (ip2 == null) {
                this.getLogger().info("Failed to determine instance point for attribute index #" + indices[1] + ": " + inst);
                continue;
            }
            double dist = this.distance(new Point2D.Double(axisBottom.valueToPos((double)ip.getX().intValue()), axisLeft.valueToPos(ip.getY().doubleValue())), new Point2D.Double(axisBottom.valueToPos((double)ip2.getX().intValue()), axisLeft.valueToPos(ip2.getY().doubleValue())), new Point2D.Double(e.getX(), e.getY()));
            this.getLogger().info("dist line=" + dist);
            if (dist > (double)this.m_MinimumPixelDifference) continue;
            result.add(ip);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    protected String processHit(MouseEvent e, List<InstancePoint> hit) {
        Object result = "";
        for (int i = 0; i < hit.size(); ++i) {
            if (i > 0) {
                result = (String)result + ", ";
            }
            Instance inst = (Instance)hit.get(i).getParent();
            InstanceContainer cont = ((InstanceContainerManager)this.m_Owner.getContainerManager()).newContainer((Comparable)((Object)inst));
            result = (String)result + (Object)((Object)hit.get(i)) + " (" + cont.getDisplayID() + ")";
        }
        return result;
    }

    public void cleanUp() {
        this.m_Owner = null;
        super.cleanUp();
    }
}

