/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.data.instance.InstanceUtils;
import adams.data.sequence.XYSequencePoint;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instance.AbstractInstancePaintlet;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class SimpleInstanceLinePaintlet
extends AbstractInstancePaintlet
implements AntiAliasingSupporter {
    private static final long serialVersionUID = -2971846774962333662L;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for generating a line plot for Instance objects (no markers).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public Color getColor(int index) {
        Color result = Color.BLUE;
        AbstractContainer cont = this.getDataContainerPanel().getContainerManager().get(index);
        if (cont instanceof ColorContainer) {
            result = ((ColorContainer)cont).getColor();
        }
        return result;
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    protected void drawData(Graphics g, Instance data, Color color) {
        int end;
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        int start = InstanceUtils.findClosestX(points, (int)Math.floor(axisX.getMinimum()));
        if (start > 0) {
            --start;
        }
        if ((end = InstanceUtils.findClosestX(points, (int)Math.ceil(axisX.getMaximum()))) < data.size() - 1) {
            ++end;
        }
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        int prevX = axisX.valueToPos((double)((InstancePoint)((Object)points.get(start))).getX().intValue());
        int prevY = axisY.valueToPos(((InstancePoint)((Object)points.get(start))).getY().doubleValue());
        for (int i = start; i <= end; ++i) {
            InstancePoint curr = (InstancePoint)((Object)points.get(i));
            currX = axisX.valueToPos(XYSequencePoint.toDouble((Integer)curr.getX()).doubleValue());
            if (i != start && i != end && currX == prevX) continue;
            currY = axisY.valueToPos(XYSequencePoint.toDouble((Double)curr.getY()).doubleValue());
            g.drawLine(prevX, prevY, currX, currY);
            prevX = currX;
            prevY = currY;
        }
    }

    protected void doPerformPaint(Graphics g, PaintEvent.PaintMoment moment) {
        InstanceContainerManager manager = (InstanceContainerManager)this.getDataContainerPanel().getContainerManager();
        for (int i = 0; i < manager.count(); ++i) {
            InstanceContainer cont = (InstanceContainer)manager.get(i);
            if (!cont.isVisible() || manager.isFiltered() && !manager.isFiltered(i)) continue;
            Instance data = (Instance)((Object)cont.getPayload());
            this.drawData(g, data, this.getColor(i));
        }
    }
}

