/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance.plotpopup;

import adams.data.instance.Instance;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.visualization.container.DataContainerPanelWithContainerList;
import adams.gui.visualization.container.datacontainerpanel.plotpopup.AbstractPlotPopupCustomizer;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import weka.core.Instances;
import weka.core.converters.AbstractFileSaver;

public class SaveVisible
extends AbstractPlotPopupCustomizer<Instance, InstanceContainerManager, InstanceContainer> {
    private static final long serialVersionUID = 3295471324320509106L;

    public String getName() {
        return "Save visible";
    }

    public String getGroup() {
        return "export";
    }

    public boolean handles(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel) {
        return panel instanceof InstancePanel;
    }

    public void customize(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel, MouseEvent e, JPopupMenu menu) {
        JMenuItem item = new JMenuItem("Save visible...", ImageManager.getIcon((String)"save.gif"));
        item.addActionListener(ae -> {
            WekaFileChooser fc = new WekaFileChooser();
            int retval = fc.showSaveDialog((Component)panel);
            if (retval != 0) {
                return;
            }
            Instances dataset = null;
            for (InstanceContainer c : panel.getTableModelContainers(true)) {
                if (dataset == null) {
                    dataset = new Instances(c.getData().getDatasetHeader(), 0);
                }
                dataset.add((weka.core.Instance)c.getData().toInstance().copy());
            }
            if (dataset == null) {
                return;
            }
            AbstractFileSaver saver = (AbstractFileSaver)fc.getWriter();
            saver.setInstances(dataset);
            try {
                saver.setFile(fc.getSelectedFile().getAbsoluteFile());
                saver.writeBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                GUIHelper.showErrorMessage((Component)panel, (String)("Error saving instances:\n" + ex));
            }
        });
        menu.add(item);
    }
}

