/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances;

import adams.core.Range;
import adams.data.instances.InstanceComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SortableAndSearchableWrapperTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.core.UndoHandlerWithQuickAccess;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.instances.AttributeValueCellRenderer;
import adams.gui.visualization.instances.InstancesTableModel;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;
import weka.core.Undoable;
import weka.core.converters.AbstractFileSaver;

public class InstancesTable
extends SortableAndSearchableTable
implements Undoable,
SendToActionSupporter {
    private static final long serialVersionUID = -1408763296714340976L;
    protected AttributeValueCellRenderer m_Renderer;
    protected WekaFileChooser m_FileChooser;
    protected HashMap<String, Object> m_LastSetup;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected PopupMenuCustomizer m_HeaderPopupMenuCustomizer;
    protected PopupMenuCustomizer m_CellPopupMenuCustomizer;

    public InstancesTable(Instances data) {
        this(new InstancesTableModel(data));
    }

    public InstancesTable(InstancesTableModel model) {
        super((TableModel)model);
    }

    protected void initGUI() {
        super.initGUI();
        this.m_FileChooser = new WekaFileChooser();
        this.m_Renderer = new AttributeValueCellRenderer();
        this.m_LastSetup = new HashMap();
        this.m_ChangeListeners = new HashSet();
        this.m_HeaderPopupMenuCustomizer = null;
        this.m_CellPopupMenuCustomizer = null;
        this.setAutoResizeMode(0);
        this.addHeaderPopupMenuListener(e -> this.showHeaderPopup(e));
        this.addCellPopupMenuListener(e -> this.showCellPopup(e));
    }

    public synchronized void setModel(TableModel model) {
        if (!(model instanceof InstancesTableModel)) {
            throw new IllegalArgumentException("Model must be derived from " + InstancesTableModel.class.getName() + ", provided: " + model.getClass().getName());
        }
        super.setModel(model);
    }

    protected void afterTableLayoutChanged() {
        this.setOptimalColumnWidth();
    }

    public void setUndoHandler(UndoHandlerWithQuickAccess value) {
        ((InstancesTableModel)this.getUnsortedModel()).setUndoHandler(value);
    }

    public UndoHandlerWithQuickAccess getUndoHandler() {
        return ((InstancesTableModel)this.getUnsortedModel()).getUndoHandler();
    }

    public boolean isUndoEnabled() {
        return ((InstancesTableModel)this.getUnsortedModel()).isUndoEnabled();
    }

    public void setUndoEnabled(boolean enabled) {
        ((InstancesTableModel)this.getUnsortedModel()).setUndoEnabled(enabled);
    }

    public void clearUndo() {
        ((InstancesTableModel)this.getUnsortedModel()).clearUndo();
    }

    public boolean canUndo() {
        return ((InstancesTableModel)this.getUnsortedModel()).canUndo();
    }

    public void undo() {
        ((InstancesTableModel)this.getUnsortedModel()).undo();
        this.afterTableLayoutChanged();
        this.notifyChangeListeners();
    }

    public void addUndoPoint() {
        ((InstancesTableModel)this.getUnsortedModel()).addUndoPoint();
    }

    public boolean isReadOnly() {
        return ((InstancesTableModel)this.getUnsortedModel()).isReadOnly();
    }

    public void setReadOnly(boolean value) {
        ((InstancesTableModel)this.getUnsortedModel()).setReadOnly(value);
    }

    public void setInstances(Instances data) {
        this.setModel(((InstancesTableModel)this.getUnsortedModel()).copy(data));
    }

    public Instances getInstances() {
        return ((InstancesTableModel)this.getUnsortedModel()).getInstances();
    }

    protected int selectionRowToModelRow(int index) {
        return this.getActualRow(index);
    }

    public Instances toInstances(TableRowRange range) {
        return this.toInstances(range, false);
    }

    public Instances toInstances(TableRowRange range, boolean view) {
        Instances result;
        Instances full = this.getInstances();
        switch (range) {
            case ALL: {
                result = full;
                break;
            }
            case SELECTED: {
                int[] indices = this.getSelectedRows();
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = this.selectionRowToModelRow(indices[i]);
                }
                if (view) {
                    result = new InstancesView(full, indices);
                    break;
                }
                result = new Instances(full, indices.length);
                for (int index : indices) {
                    result.add((Instance)full.instance(index).copy());
                }
                break;
            }
            case VISIBLE: {
                int[] indices = new int[this.getRowCount()];
                for (int i = 0; i < this.getRowCount(); ++i) {
                    indices[i] = this.selectionRowToModelRow(i);
                }
                if (view) {
                    result = new InstancesView(full, indices);
                    break;
                }
                result = new Instances(full, indices.length);
                for (int index : indices) {
                    result.add((Instance)full.instance(index).copy());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled row range: " + range);
            }
        }
        return result;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.m_Renderer;
    }

    protected void showHeaderPopup(MouseEvent e) {
        BasePopupMenu menu = this.createHeaderPopup(e);
        menu.showAbsolute((Component)this.getTableHeader(), e);
    }

    protected BasePopupMenu createHeaderPopup(MouseEvent e) {
        JMenuItem menuitem;
        BasePopupMenu menu = new BasePopupMenu();
        TableRowRange range = this.getSelectedRows().length > 0 ? TableRowRange.SELECTED : (this.isAnyColumnFiltered() || this.getSeachString() != null && !this.getSeachString().isEmpty() ? TableRowRange.VISIBLE : TableRowRange.ALL);
        InstancesTablePopupMenuItemHelper.TableState state = InstancesTablePopupMenuItemHelper.getState(this, e, range);
        InstancesTableModel instModel = (InstancesTableModel)this.getUnsortedModel();
        if (instModel.isUndoEnabled()) {
            menuitem = new JMenuItem("Undo", ImageManager.getIcon((String)"undo.gif"));
            menuitem.setEnabled(this.canUndo());
            menuitem.addActionListener(ae -> instModel.undo());
            menu.add(menuitem);
            menu.addSeparator();
        }
        menuitem = new JMenuItem("Rename...", ImageManager.getEmptyIcon());
        menuitem.addActionListener(ae -> {
            String newName = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter new name", (String)this.getInstances().attribute(state.selCol).name());
            if (newName != null) {
                instModel.renameAttributeAt(state.actCol, newName);
                this.afterTableLayoutChanged();
                this.notifyChangeListeners();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Delete", ImageManager.getIcon((String)"delete.gif"));
        menuitem.addActionListener(ae -> {
            int retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)("Delete attribute '" + this.getInstances().attribute(state.actCol).name() + "'?"));
            if (retVal == 0) {
                instModel.deleteAttributeAt(state.actCol);
                this.afterTableLayoutChanged();
                this.notifyChangeListeners();
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        if (this.getShowWeightsColumn()) {
            menuitem = new JMenuItem("Hide weights", ImageManager.getEmptyIcon());
            menuitem.addActionListener(ae -> {
                this.setShowWeightsColumn(false);
                this.setShowAttributeWeights(false);
            });
            menu.add(menuitem);
        } else {
            menuitem = new JMenuItem("Show weights", ImageManager.getEmptyIcon());
            menuitem.addActionListener(ae -> {
                this.setShowWeightsColumn(true);
                this.setShowAttributeWeights(true);
            });
            menu.add(menuitem);
        }
        menuitem = new JMenuItem("Filter", ImageManager.getIcon((String)"filter.png"));
        menuitem.setEnabled(state.actCol > -1);
        menuitem.addActionListener(ae -> {
            String filter = "";
            if (this.getColumnFilter(state.selCol) != null) {
                filter = this.getColumnFilter(state.selCol);
            }
            if ((filter = GUIHelper.showInputDialog((Component)this.getParent(), (String)"Please enter filter string", (String)filter)) == null || filter.isEmpty()) {
                return;
            }
            this.setColumnFilter(state.selCol, filter, false);
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Filter (RegExp)", ImageManager.getEmptyIcon());
        menuitem.setEnabled(state.actCol > -1);
        menuitem.addActionListener(ae -> {
            String filter = "";
            if (this.getColumnFilter(state.selCol) != null) {
                filter = this.getColumnFilter(state.selCol);
            }
            if ((filter = GUIHelper.showInputDialog((Component)this.getParent(), (String)"Please enter regular expression filter", (String)filter)) == null || filter.isEmpty()) {
                return;
            }
            this.setColumnFilter(state.selCol, filter, true);
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Remove filter", ImageManager.getIcon((String)"delete.gif"));
        menuitem.setEnabled(this.isColumnFiltered(state.selCol));
        menuitem.addActionListener(ae -> this.removeColumnFilter(state.selCol));
        menu.add(menuitem);
        menuitem = new JMenuItem("Remove all filters", ImageManager.getIcon((String)"delete_all.gif"));
        menuitem.setEnabled(this.isAnyColumnFiltered());
        menuitem.addActionListener(ae -> this.removeAllColumnFilters());
        menu.add(menuitem);
        InstancesTablePopupMenuItemHelper.addToPopupMenu(state, (JPopupMenu)menu, false);
        if (this.m_HeaderPopupMenuCustomizer != null) {
            this.m_HeaderPopupMenuCustomizer.customizePopupMenu(e, (JPopupMenu)menu);
        }
        return menu;
    }

    protected void showCellPopup(MouseEvent e) {
        BasePopupMenu menu = this.createCellPopup(e);
        menu.showAbsolute((Component)((Object)this), e);
    }

    protected BasePopupMenu createCellPopup(MouseEvent e) {
        JMenuItem menuitem;
        BasePopupMenu menu = new BasePopupMenu();
        TableRowRange rowrange = this.getSelectedRows().length > 0 ? TableRowRange.SELECTED : (this.isAnyColumnFiltered() || this.getSeachString() != null && !this.getSeachString().isEmpty() ? TableRowRange.VISIBLE : TableRowRange.ALL);
        InstancesTablePopupMenuItemHelper.TableState state = InstancesTablePopupMenuItemHelper.getState(this, e, rowrange);
        InstancesTableModel instModel = (InstancesTableModel)this.getUnsortedModel();
        Range range = new Range();
        range.setMax(this.getRowCount());
        range.setIndices(state.selRows);
        if (instModel.isUndoEnabled()) {
            menuitem = new JMenuItem("Undo", ImageManager.getIcon((String)"undo.gif"));
            menuitem.setEnabled(this.canUndo());
            menuitem.addActionListener(ae -> instModel.undo());
            menu.add(menuitem);
        }
        menuitem = new JMenuItem("Invert selection", ImageManager.getEmptyIcon());
        menuitem.addActionListener(ae -> this.invertRowSelection());
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = this.getSelectedRowCount() > 1 ? new JMenuItem("Copy rows") : new JMenuItem("Copy row");
        menuitem.setIcon(ImageManager.getIcon((String)"copy_row.gif"));
        menuitem.setEnabled(this.getSelectedRowCount() > 0);
        menuitem.addActionListener(ae -> this.copyToClipboard());
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy cell");
        menuitem.setIcon(ImageManager.getIcon((String)"copy_cell.gif"));
        menuitem.setEnabled(this.getSelectedRowCount() == 1);
        menuitem.addActionListener(ae -> {
            if (state.selRow == -1) {
                return;
            }
            if (state.selCol == -1) {
                return;
            }
            ClipboardHelper.copyToClipboard((String)("" + this.getValueAt(state.selRow, state.selCol)));
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Delete", ImageManager.getIcon((String)"delete.gif"));
        menuitem.setEnabled(state.selRows.length > 0);
        menuitem.addActionListener(ae -> {
            int retVal;
            Object msg = "Delete row";
            if (state.selRows.length > 1) {
                msg = (String)msg + "s";
            }
            if ((retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)(msg = (String)msg + " " + range.getRange() + "?"))) != 0) {
                return;
            }
            instModel.deleteInstances(state.actRows);
            this.notifyChangeListeners();
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = rowrange == TableRowRange.ALL ? new JMenuItem("Save...") : (rowrange == TableRowRange.SELECTED ? new JMenuItem("Save selected...") : new JMenuItem("Save visible..."));
        menuitem.setIcon(ImageManager.getIcon((String)"save.gif"));
        menuitem.addActionListener(ae -> this.saveAs(rowrange));
        menu.add(menuitem);
        SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JPopupMenu)menu);
        InstancesTablePopupMenuItemHelper.addToPopupMenu(state, (JPopupMenu)menu, true);
        if (this.m_CellPopupMenuCustomizer != null) {
            this.m_CellPopupMenuCustomizer.customizePopupMenu(e, (JPopupMenu)menu);
        }
        return menu;
    }

    public void setHeaderPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_HeaderPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getHeaderPopupMenuCustomizer() {
        return this.m_HeaderPopupMenuCustomizer;
    }

    public void setCellPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_CellPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getCellPopupMenuCustomizer() {
        return this.m_CellPopupMenuCustomizer;
    }

    protected void saveAs(TableRowRange range) {
        Instances data;
        int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        AbstractFileSaver saver = (AbstractFileSaver)this.m_FileChooser.getWriter();
        File file = this.m_FileChooser.getSelectedFile();
        Instances original = this.getInstances();
        switch (range) {
            case ALL: {
                data = original;
                break;
            }
            case SELECTED: {
                data = new Instances(original, 0);
                int[] selRows = this.getSelectedRows();
                for (int i = 0; i < selRows.length; ++i) {
                    data.add((Instance)original.instance(this.getActualRow(selRows[i])).copy());
                }
                break;
            }
            case VISIBLE: {
                data = new Instances(original, 0);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    data.add((Instance)original.instance(this.getActualRow(i)).copy());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled range type: " + range);
            }
        }
        try {
            saver.setFile(file);
            saver.setInstances(data);
            saver.writeBatch();
        }
        catch (Exception ex) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data (" + range + ") to: " + file), (Throwable)ex);
        }
    }

    protected String createLastSetupKey(Class cls, boolean plot, boolean row) {
        return cls.getName() + "-" + (plot ? "plot" : "process") + "-" + (row ? "row" : "column");
    }

    public void addLastSetup(Class cls, boolean plot, boolean row, Object setup) {
        this.m_LastSetup.put(this.createLastSetupKey(cls, plot, row), setup);
    }

    public Object getLastSetup(Class cls, boolean plot, boolean row) {
        return this.m_LastSetup.get(this.createLastSetupKey(cls, plot, row));
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected synchronized void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent((Object)this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }

    protected SpreadSheet modelToSpreadSheet() {
        return ((InstancesTableModel)this.getUnsortedModel()).toSpreadSheet();
    }

    public void setShowWeightsColumn(boolean value) {
        ((InstancesTableModel)this.getUnsortedModel()).setShowWeightsColumn(value);
        ((SortableAndSearchableWrapperTableModel)this.getModel()).fireTableStructureChanged();
    }

    public boolean getShowWeightsColumn() {
        return ((InstancesTableModel)this.getUnsortedModel()).getShowWeightsColumn();
    }

    public void setShowAttributeWeights(boolean value) {
        ((InstancesTableModel)this.getUnsortedModel()).setShowAttributeWeights(value);
        ((SortableAndSearchableWrapperTableModel)this.getModel()).fireTableStructureChanged();
    }

    public boolean getShowAttributeWeights() {
        return ((InstancesTableModel)this.getUnsortedModel()).getShowAttributeWeights();
    }

    public void sort(InstanceComparator comparator) {
        ((InstancesTableModel)this.getUnsortedModel()).getInstances().sort((Comparator)comparator);
        ((SortableAndSearchableWrapperTableModel)this.getModel()).fireTableDataChanged();
    }

    public Class[] getSendToClasses() {
        return new Class[]{JTable.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable((Class[])new Class[]{JTable.class}, (Class[])cls);
    }

    public Object getSendToItem(Class[] cls) {
        InstancesTable result = null;
        if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this;
        }
        return result;
    }
}

