/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Utils;
import adams.gui.core.GUIHelper;
import adams.gui.core.TableRowRange;
import adams.gui.visualization.instances.instancestable.AbstractProcessColumn;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import java.awt.Component;
import javax.swing.event.TableModelEvent;
import weka.core.Attribute;

public class ChangeAttributeWeight
extends AbstractProcessColumn {
    private static final long serialVersionUID = 8866236994813131751L;

    public String globalInfo() {
        return "Allows the user to change the weight of the selected attribute.";
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    @Override
    public String getMenuItem() {
        return "Change attribute weight...";
    }

    @Override
    public String getIconName() {
        return "weight.png";
    }

    @Override
    protected boolean doProcessColumn(InstancesTablePopupMenuItemHelper.TableState state) {
        if (state.actCol == -1) {
            return false;
        }
        Attribute att = state.table.getInstances().attribute(state.actCol);
        double weight = att.weight();
        String newWeightStr = GUIHelper.showInputDialog((Component)state.table.getParent(), (String)("Please enter new weight for '" + att.name() + "': "), (String)("" + weight));
        if (newWeightStr == null) {
            return false;
        }
        if (!Utils.isDouble((String)newWeightStr)) {
            GUIHelper.showErrorMessage((Component)state.table.getParent(), (String)("Weight has to be a valid numnber, provided: " + newWeightStr));
            return false;
        }
        double newWeight = Utils.toDouble((String)newWeightStr);
        if (weight != newWeight) {
            state.table.addUndoPoint();
            att.setWeight(newWeight);
            state.table.tableChanged(new TableModelEvent(state.table.getUnsortedModel(), -1));
        }
        return true;
    }
}

