/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Properties;
import adams.core.option.AbstractOptionHandler;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import adams.data.weka.WekaAttributeRange;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.TableRowRange;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import adams.gui.visualization.statistics.HistogramFactory;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import weka.core.Instances;

public class Histogram
extends AbstractOptionHandler
implements PlotColumn,
PlotRow {
    private static final long serialVersionUID = -2452746814708360637L;
    public static final String KEY_ATTRIBUTES = "attributes";
    public static final String KEY_HISTOGRAM = "histogram";

    public String globalInfo() {
        return "Allows to generate a histogram from either a row or a column from a dataset.";
    }

    @Override
    public String getMenuItem() {
        return "Histogram...";
    }

    @Override
    public String getIconName() {
        return "histogram.png";
    }

    @Override
    public boolean isAvailable(InstancesTablePopupMenuItemHelper.TableState state) {
        return true;
    }

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    protected Properties promptParameters(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        if (!isColumn) {
            panel.addPropertyType(KEY_ATTRIBUTES, PropertiesParameterPanel.PropertyType.RANGE);
            panel.setLabel(KEY_ATTRIBUTES, "Attributes");
            panel.setHelp(KEY_ATTRIBUTES, "The attributes to use for the histogram");
        }
        panel.addPropertyType(KEY_HISTOGRAM, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        panel.setLabel(KEY_HISTOGRAM, "Histogram");
        panel.setHelp(KEY_HISTOGRAM, "How to generate the histogram");
        panel.setChooser(KEY_HISTOGRAM, (AbstractChooserPanel)new GenericObjectEditorPanel(AbstractArrayStatistic.class, (Object)new ArrayHistogram(), false));
        if (!isColumn) {
            panel.setPropertyOrder(new String[]{KEY_ATTRIBUTES, KEY_HISTOGRAM});
        }
        Properties last = new Properties();
        if (!isColumn) {
            last.setProperty(KEY_ATTRIBUTES, "first-last");
        }
        last.setObject(KEY_HISTOGRAM, (Object)new ArrayHistogram());
        dialog.setProperties(last);
        last = (Properties)state.table.getLastSetup(this.getClass(), true, !isColumn);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)state.table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected void plot(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn) {
        Instances data;
        Properties last = this.promptParameters(state, isColumn);
        if (last == null) {
            return;
        }
        ArrayHistogram histo = (ArrayHistogram)last.getObject(KEY_HISTOGRAM, ArrayHistogram.class, (Object)new ArrayHistogram());
        state.table.addLastSetup(this.getClass(), true, !isColumn, last);
        int index = isColumn ? state.actCol : state.actRow;
        TDoubleArrayList list = new TDoubleArrayList();
        if (isColumn) {
            data = state.table.toInstances(state.range, true);
            for (int i = 0; i < data.numInstances(); ++i) {
                if (!data.attribute(index).isNumeric() || data.instance(i).isMissing(index)) continue;
                list.add(data.instance(i).value(index));
            }
        } else {
            data = state.table.getInstances();
            WekaAttributeRange columns = new WekaAttributeRange(last.getProperty(KEY_ATTRIBUTES, "first-last"));
            columns.setData(data);
            int[] cols = columns.getIntIndices();
            for (int i = 0; i < cols.length; ++i) {
                if (!data.attribute(cols[i]).isNumeric() || data.instance(index).isMissing(cols[i])) continue;
                list.add(data.instance(index).value(cols[i]));
            }
        }
        histo.clear();
        HistogramFactory.Dialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? HistogramFactory.getDialog((Dialog)GUIHelper.getParentDialog((Container)((Object)state.table)), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : HistogramFactory.getDialog((Frame)GUIHelper.getParentFrame((Container)((Object)state.table)), (boolean)false);
        dialog.setDefaultCloseOperation(2);
        if (isColumn) {
            dialog.add(histo, list.toArray(), "Column " + (index + 1) + "/" + data.attribute(index).name());
        } else {
            dialog.add(histo, list.toArray(), "Row " + (index + 1));
        }
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)state.table)));
        dialog.setVisible(true);
    }

    @Override
    public boolean plotColumn(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, true);
        return true;
    }

    @Override
    public boolean plotRow(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false);
        return true;
    }
}

