/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.data.instances.InstanceComparator;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.ImageManager;
import adams.gui.event.InstancesSortSetupEvent;
import adams.gui.event.InstancesSortSetupListener;
import adams.gui.visualization.instances.instancestable.InstancesSortDefinitionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import weka.core.Instances;

public class InstancesSortPanel
extends BasePanel {
    private static final long serialVersionUID = 7929780439384161250L;
    protected Instances m_Data;
    protected List<InstancesSortDefinitionPanel> m_Panels;
    protected GridLayout m_Layout;
    protected BasePanel m_PanelDefinitions;
    protected BasePanel m_PanelButtons;
    protected BaseButton m_ButtonReset;
    protected BaseButton m_ButtonAdd;
    protected List<String> m_ColumnNames;
    protected HashSet<InstancesSortSetupListener> m_InstancesSortSetupListeners;

    protected void initialize() {
        super.initialize();
        this.m_Panels = new ArrayList<InstancesSortDefinitionPanel>();
        this.m_ColumnNames = new ArrayList<String>();
        this.m_InstancesSortSetupListeners = new HashSet();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Layout = new GridLayout(0, 1);
        this.m_PanelDefinitions = new BasePanel((LayoutManager)this.m_Layout);
        this.add((Component)this.m_PanelDefinitions, "Center");
        this.m_PanelButtons = new BasePanel((LayoutManager)new FlowLayout(0));
        this.add((Component)this.m_PanelButtons, "North");
        this.m_ButtonReset = new BaseButton((Icon)ImageManager.getIcon((String)"new.gif"));
        this.m_ButtonReset.setToolTipText("Click to reset the conditions");
        this.m_ButtonReset.addActionListener(e -> this.resetDefinitions());
        this.m_PanelButtons.add((Component)this.m_ButtonReset);
        this.m_ButtonAdd = new BaseButton((Icon)ImageManager.getIcon((String)"add.gif"));
        this.m_ButtonAdd.setToolTipText("Click to add a condition");
        this.m_ButtonAdd.addActionListener(e -> this.addDefinition());
        this.m_PanelButtons.add((Component)this.m_ButtonAdd);
    }

    protected void finishInit() {
        super.finishInit();
        this.reset();
    }

    public boolean setInstances(Instances value) {
        boolean mustReset = this.m_Data == null || this.m_Data.equalHeadersMsg(value) != null;
        this.m_Data = value;
        if (mustReset) {
            this.reset();
        }
        return mustReset;
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public List<String> getColumnNames() {
        return this.m_ColumnNames;
    }

    public void resetDefinitions() {
        this.m_Panels.clear();
        InstancesSortDefinitionPanel panel = new InstancesSortDefinitionPanel(this);
        this.m_Panels.add(panel);
        this.update();
        this.notifyInstancesSortSetupListeners(new InstancesSortSetupEvent(this, null, InstancesSortSetupEvent.EventType.RESET));
    }

    public void addDefinition() {
        InstancesSortDefinitionPanel panel = new InstancesSortDefinitionPanel(this);
        this.m_Panels.add(panel);
        this.update();
        this.notifyInstancesSortSetupListeners(new InstancesSortSetupEvent(this, panel, InstancesSortSetupEvent.EventType.ADD));
    }

    public void removeDefinition(InstancesSortDefinitionPanel panel) {
        if (this.m_Panels.remove((Object)panel)) {
            this.update();
            this.notifyInstancesSortSetupListeners(new InstancesSortSetupEvent(this, panel, InstancesSortSetupEvent.EventType.REMOVE));
        }
    }

    public void reset() {
        this.m_Panels.clear();
        this.m_ColumnNames.clear();
        if (this.m_Data != null) {
            for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
                this.m_ColumnNames.add(this.m_Data.attribute(i).name());
            }
        }
        this.update();
        this.notifyInstancesSortSetupListeners(new InstancesSortSetupEvent(this, null, InstancesSortSetupEvent.EventType.RESET));
    }

    public boolean isFirstDefinition(InstancesSortDefinitionPanel panel) {
        return this.m_Panels.size() > 0 && this.m_Panels.get(0) == panel;
    }

    public boolean isLastDefinition(InstancesSortDefinitionPanel panel) {
        return this.m_Panels.size() > 0 && this.m_Panels.get(this.m_Panels.size() - 1) == panel;
    }

    public boolean moveDefinition(InstancesSortDefinitionPanel panel, boolean up) {
        boolean result = false;
        int index = this.m_Panels.indexOf((Object)panel);
        if (up && !this.isFirstDefinition(panel)) {
            this.m_Panels.remove(index);
            this.m_Panels.add(index - 1, panel);
            result = true;
        } else if (!up && !this.isLastDefinition(panel)) {
            this.m_Panels.remove(index);
            this.m_Panels.add(index + 1, panel);
            result = true;
        }
        this.update();
        this.notifyInstancesSortSetupListeners(new InstancesSortSetupEvent(this, panel, InstancesSortSetupEvent.EventType.MOVED));
        return result;
    }

    protected void update() {
        this.m_PanelDefinitions.removeAll();
        this.m_Layout.setRows(this.m_Panels.size());
        for (InstancesSortDefinitionPanel panel : this.m_Panels) {
            this.m_PanelDefinitions.add((Component)((Object)panel));
        }
        this.revalidate();
        if (this.getParentDialog() != null) {
            this.getParentDialog().pack();
        }
        for (InstancesSortDefinitionPanel panel : this.m_Panels) {
            panel.updateButtons();
        }
    }

    public boolean isValidSetup() {
        HashSet<String> names = new HashSet<String>();
        for (InstancesSortDefinitionPanel panel : this.m_Panels) {
            if (names.contains(panel.getColumnName())) {
                return false;
            }
            names.add(panel.getColumnName());
        }
        return names.size() > 0;
    }

    public InstanceComparator getComparator() {
        if (!this.isValidSetup()) {
            return null;
        }
        int[] indices = new int[this.m_Panels.size()];
        boolean[] ascending = new boolean[this.m_Panels.size()];
        for (int i = 0; i < this.m_Panels.size(); ++i) {
            InstancesSortDefinitionPanel panel = this.m_Panels.get(i);
            indices[i] = this.m_ColumnNames.indexOf(panel.getColumnName());
            ascending[i] = panel.isAscending();
        }
        InstanceComparator result = new InstanceComparator(indices, ascending);
        return result;
    }

    public void addInstancesSortSetupListener(InstancesSortSetupListener l) {
        this.m_InstancesSortSetupListeners.add(l);
    }

    public void removeInstancesSortSetupListener(InstancesSortSetupListener l) {
        this.m_InstancesSortSetupListeners.remove(l);
    }

    public void notifyInstancesSortSetupListeners(InstancesSortSetupEvent e) {
        for (InstancesSortSetupListener l : this.m_InstancesSortSetupListeners) {
            l.sortSetupChanged(e);
        }
    }
}

