/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.weka.WekaAttributeRange;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.sink.JFreeChartPlot;
import adams.flow.source.StorageValue;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.TableRowRange;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import adams.gui.visualization.instances.instancestable.PlotSelectedRows;
import adams.gui.visualization.jfreechart.chart.AbstractChartGenerator;
import adams.gui.visualization.jfreechart.chart.XYLineChart;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.swing.SwingWorker;
import weka.core.Instances;

public class JFreeChart
extends AbstractOptionHandler
implements PlotColumn,
PlotRow,
PlotSelectedRows {
    private static final long serialVersionUID = -5624002368001818142L;
    public static final String KEY_COLUMNS = "columns";
    public static final String KEY_PLOT = "plot";
    public static final int MAX_POINTS = 1000;

    public String globalInfo() {
        return "Allows to generate a JFreeChart plot from a spreadsheet row or column";
    }

    @Override
    public String getMenuItem() {
        return "JFreeChart...";
    }

    @Override
    public String getIconName() {
        return "jfreechart.gif";
    }

    @Override
    public boolean isAvailable(InstancesTablePopupMenuItemHelper.TableState state) {
        return true;
    }

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    protected Properties promptParameters(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        if (!isColumn) {
            panel.addPropertyType(KEY_COLUMNS, PropertiesParameterPanel.PropertyType.RANGE);
            panel.setLabel(KEY_COLUMNS, "Columns");
            panel.setHelp(KEY_COLUMNS, "The columns to use for the plot");
        }
        panel.addPropertyType(KEY_PLOT, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        panel.setLabel(KEY_PLOT, "Plot");
        panel.setHelp(KEY_PLOT, "How to display the data");
        panel.setChooser(KEY_PLOT, (AbstractChooserPanel)new GenericObjectEditorPanel(Actor.class, (Object)new JFreeChartPlot(), false));
        if (!isColumn) {
            panel.setPropertyOrder(new String[]{KEY_COLUMNS, KEY_PLOT});
        }
        Properties last = new Properties();
        if (!isColumn) {
            last.setProperty(KEY_COLUMNS, "first-last");
        }
        last.setObject(KEY_PLOT, (Object)new JFreeChartPlot());
        dialog.setProperties(last);
        last = (Properties)state.table.getLastSetup(this.getClass(), true, !isColumn);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)state.table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected void createPlot(final InstancesTable table, final boolean isColumn, final SpreadSheet data, final String title, final int[] spRows) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = new Flow();
                flow.setDefaultCloseOperation(2);
                StorageValue sv = new StorageValue();
                sv.setStorageName(new StorageName("values"));
                flow.add((Actor)sv);
                Properties last = (Properties)table.getLastSetup(JFreeChart.this.getClass(), true, !isColumn);
                JFreeChartPlot plot = (JFreeChartPlot)ObjectCopyHelper.copyObject((Object)((JFreeChartPlot)last.getObject(JFreeChart.KEY_PLOT, JFreeChartPlot.class, (Object)new JFreeChartPlot())));
                if (spRows != null) {
                    DefaultXY dataset = new DefaultXY();
                    dataset.setX(new SpreadSheetColumnIndex("1"));
                    dataset.setY(new SpreadSheetColumnRange(Utils.arrayToString((Object)spRows)));
                    plot.setDataset((AbstractDatasetGenerator)dataset);
                    XYLineChart chart = new XYLineChart();
                    chart.setLegend(true);
                    chart.setTitle(title);
                    plot.setChart((AbstractChartGenerator)chart);
                } else {
                    XYLineChart chart = new XYLineChart();
                    chart.setLegend(false);
                    chart.setTitle(title);
                    plot.setChart((AbstractChartGenerator)chart);
                }
                plot.setShortTitle(true);
                plot.setName(title);
                plot.setX(-2);
                plot.setY(-2);
                flow.add((Actor)plot);
                flow.setUp();
                flow.getStorage().put(new StorageName("values"), (Object)data);
                flow.execute();
                flow.wrapUp();
                return null;
            }
        };
        worker.execute();
    }

    protected void plot(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn, int index, int[] indices) {
        int[] spRows;
        String title;
        ArrayList[] list;
        int n;
        int i;
        int numPoints;
        Instances data = isColumn ? state.table.toInstances(state.range, true) : state.table.getInstances();
        int n2 = numPoints = isColumn ? data.numInstances() : data.numAttributes();
        if (numPoints > 1000) {
            String newPoints = GUIHelper.showInputDialog(null, (String)"More than 1000 data points to plot - enter sample size:", (String)("" + numPoints));
            if (newPoints == null) {
                return;
            }
            if (!Utils.isInteger((String)newPoints)) {
                return;
            }
            numPoints = Integer.parseInt(newPoints) != numPoints ? Integer.parseInt(newPoints) : -1;
        } else {
            numPoints = -1;
        }
        Properties last = this.promptParameters(state, isColumn);
        if (last == null) {
            return;
        }
        state.table.addLastSetup(this.getClass(), true, !isColumn, last);
        ArrayList[] tmp = indices == null ? new ArrayList[]{new ArrayList()} : new ArrayList[indices.length];
        boolean sorted = false;
        boolean asc = state.table.isAscending();
        if (isColumn) {
            sorted = state.table.getSortColumn() == state.selCol;
            for (i = 0; i < data.numInstances(); ++i) {
                if (!data.attribute(state.actCol).isNumeric() || data.instance(i).isMissing(state.actCol)) continue;
                tmp[0].add(data.instance(i).value(state.actCol));
            }
        } else {
            int[] rows = indices == null ? new int[index] : indices;
            WekaAttributeRange columns = new WekaAttributeRange(last.getProperty(KEY_COLUMNS, "first-last"));
            columns.setData(data);
            int[] cols = columns.getIntIndices();
            for (n = 0; n < rows.length; ++n) {
                tmp[n] = new ArrayList();
                int row = rows[n];
                for (i = 0; i < cols.length; ++i) {
                    if (!data.attribute(cols[i]).isNumeric() || data.instance(row).isMissing(cols[i])) continue;
                    tmp[n].add(data.instance(row).value(cols[i]));
                }
            }
        }
        if (numPoints > -1) {
            list = new ArrayList[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                numPoints = Math.min(numPoints, tmp[i].size());
                Collections.shuffle(tmp[i], new Random(1L));
                list[i] = tmp[i].subList(0, numPoints);
            }
        } else {
            list = tmp;
        }
        if (sorted) {
            for (i = 0; i < list.length; ++i) {
                Collections.sort(list[i]);
                if (asc) continue;
                Collections.reverse(list[i]);
            }
        }
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        sheet.getHeaderRow().addCell("x").setContentAsString(isColumn ? "Column" : "Row");
        if (isColumn) {
            sheet.getHeaderRow().addCell("y0").setContentAsString(data.attribute(index).name());
        } else if (indices == null) {
            sheet.getHeaderRow().addCell("y0").setContentAsString("Row " + (index + 1));
        } else {
            for (i = 0; i < indices.length; ++i) {
                sheet.getHeaderRow().addCell("y" + i).setContentAsString("Row " + (indices[i] + 1));
            }
        }
        for (i = 0; i < list[0].size(); ++i) {
            DataRow srow = sheet.addRow();
            srow.addCell("x").setContent(Double.valueOf((double)i + 1.0));
            for (n = 0; n < list.length; ++n) {
                srow.addCell("y" + n).setContent((Double)list[n].get(i));
            }
        }
        if (isColumn) {
            title = "Column " + (index + 1) + "/" + data.attribute(index).name();
            spRows = null;
        } else if (indices == null) {
            title = "Row " + (index + 1);
            spRows = null;
        } else {
            int[] actRows = Utils.adjustIndices((int[])indices, (int)1);
            spRows = new int[indices.length];
            for (i = 0; i < indices.length; ++i) {
                spRows[i] = i + 2;
            }
            title = "Row" + (actRows.length != 1 ? "s" : "") + " " + Shortening.shortenMiddle((String)Utils.arrayToString((Object)actRows), (int)40);
        }
        this.createPlot(state.table, isColumn, (SpreadSheet)sheet, title, spRows);
    }

    @Override
    public boolean plotColumn(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, true, state.actCol, null);
        return true;
    }

    @Override
    public boolean plotRow(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false, state.actRow, null);
        return true;
    }

    @Override
    public int minNumRows() {
        return 1;
    }

    @Override
    public int maxNumRows() {
        return -1;
    }

    @Override
    public boolean plotSelectedRows(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false, state.actRow, state.actRows);
        return true;
    }
}

