/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.genetic;

import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.ThreadLimiter;
import adams.core.io.PlaceholderDirectory;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.data.weka.WekaAttributeIndex;
import adams.data.weka.WekaLabelIndex;
import adams.event.GeneticFitnessChangeNotifier;
import adams.flow.core.Actor;
import adams.flow.standalone.JobRunnerSetup;
import adams.flow.transformer.wekaevaluationpostprocessor.AbstractWekaEvaluationPostProcessor;
import adams.flow.transformer.wekaevaluationpostprocessor.PassThrough;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import adams.multiprocess.LocalJobRunner;
import adams.multiprocess.WekaCrossValidationExecution;
import adams.opt.genetic.AbstractGeneticAlgorithm;
import adams.opt.genetic.Measure;
import adams.opt.genetic.OutputPrefixType;
import adams.opt.genetic.OutputType;
import adams.opt.genetic.setupupload.AbstractSetupUpload;
import adams.opt.genetic.setupupload.Null;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.DefaultCrossValidationFoldGenerator;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Instances;

public abstract class AbstractClassifierBasedGeneticAlgorithm
extends AbstractGeneticAlgorithm
implements GeneticFitnessChangeNotifier {
    private static final long serialVersionUID = 1615849384907266578L;
    public static final String PROPS_RELATION = "relation";
    public static final String PROPS_FILTER = "filter";
    public static final String PROPS_MASK = "mask";
    protected WekaAttributeIndex m_ClassIndex;
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected int m_BitsPerGene;
    protected Classifier m_Classifier;
    protected int m_Folds;
    protected int m_CrossValidationSeed;
    protected CrossValidationFoldGenerator m_Generator;
    protected Measure m_Measure;
    protected WekaLabelIndex m_ClassLabelIndex;
    protected AbstractWekaEvaluationPostProcessor m_EvaluationPostProcessor;
    protected PlaceholderDirectory m_OutputDirectory;
    protected OutputType m_OutputType;
    protected OutputPrefixType m_OutputPrefixType;
    protected String m_SuppliedPrefix;
    protected AbstractSetupUpload m_SetupUpload;
    public Hashtable<String, Double> m_StoredResults = new Hashtable();
    protected transient JobRunnerSetup m_JobRunnerSetup;
    protected Actor m_FlowContext;
    protected JobRunner<ClassifierBasedGeneticAlgorithmJob> m_JobRunner;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bits-per-gene", "bitsPerGene", (Object)1, (Number)1, null);
        this.m_OptionManager.add("class", "classIndex", (Object)new WekaAttributeIndex("last"));
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)2, null);
        this.m_OptionManager.add("cv-seed", "crossValidationSeed", (Object)55);
        this.m_OptionManager.add("generator", "generator", (Object)new DefaultCrossValidationFoldGenerator());
        this.m_OptionManager.add("classifier", "classifier", (Object)this.getDefaultClassifier());
        this.m_OptionManager.add("measure", "measure", (Object)Measure.RMSE);
        this.m_OptionManager.add("class-label-index", "classLabelIndex", (Object)new WekaLabelIndex("first"));
        this.m_OptionManager.add("evaluation-post-processor", "evaluationPostProcessor", (Object)new PassThrough());
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("output-type", "outputType", (Object)this.getDefaultOutputType());
        this.m_OptionManager.add("output-prefix-type", "outputPrefixType", (Object)OutputPrefixType.NONE);
        this.m_OptionManager.add("supplied-prefix", "suppliedPrefix", (Object)"");
        this.m_OptionManager.add("setup-upload", "setupUpload", (Object)new Null());
    }

    public void setClassIndex(WekaAttributeIndex value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public WekaAttributeIndex getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The class index of the dataset, in case no class attribute is set.";
    }

    public void setInstances(Instances value) {
        this.m_Instances = value;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setTestInstances(Instances value) {
        this.m_TestInstances = value;
    }

    public Instances getTestInstances() {
        return this.m_TestInstances;
    }

    public void setFolds(int value) {
        this.m_Folds = value;
        this.reset();
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in cross-validation.";
    }

    public void setCrossValidationSeed(int value) {
        this.m_CrossValidationSeed = value;
        this.reset();
    }

    public int getCrossValidationSeed() {
        return this.m_CrossValidationSeed;
    }

    public String crossValidationSeedTipText() {
        return "The seed value for cross-validation.";
    }

    public void setGenerator(CrossValidationFoldGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public CrossValidationFoldGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The scheme to use for generating the folds; the actor options take precedence over the scheme's ones.";
    }

    protected Classifier getDefaultClassifier() {
        return new ZeroR();
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public void setBitsPerGene(int value) {
        this.m_BitsPerGene = value;
        this.reset();
    }

    public int getBitsPerGene() {
        return this.m_BitsPerGene;
    }

    public String bitsPerGeneTipText() {
        return "The number of bits per gene to use.";
    }

    public void setMeasure(Measure value) {
        this.m_Measure = value;
        this.reset();
    }

    public Measure getMeasure() {
        return this.m_Measure;
    }

    public String measureTipText() {
        return "The measure used for evaluating the fitness.";
    }

    public void setClassLabelIndex(WekaLabelIndex value) {
        this.m_ClassLabelIndex = value;
        this.reset();
    }

    public WekaLabelIndex getClassLabelIndex() {
        return this.m_ClassLabelIndex;
    }

    public String classLabelIndexTipText() {
        return "The index of the class label to use for statistics that work on a per-label-basis.";
    }

    public void setEvaluationPostProcessor(AbstractWekaEvaluationPostProcessor value) {
        this.m_EvaluationPostProcessor = value;
        this.reset();
    }

    public AbstractWekaEvaluationPostProcessor getEvaluationPostProcessor() {
        return this.m_EvaluationPostProcessor;
    }

    public String evaluationPostProcessorTipText() {
        return "The scheme for post-processing the evaluation.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory for storing the generated ARFF files.";
    }

    protected abstract OutputType getDefaultOutputType();

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "The type of output to generate.";
    }

    public void setOutputPrefixType(OutputPrefixType value) {
        this.m_OutputPrefixType = value;
        this.reset();
    }

    public OutputPrefixType getOutputPrefixType() {
        return this.m_OutputPrefixType;
    }

    public String outputPrefixTypeTipText() {
        return "The type of prefix to use for the output.";
    }

    public void setSuppliedPrefix(String value) {
        this.m_SuppliedPrefix = value;
        this.reset();
    }

    public String getSuppliedPrefix() {
        return this.m_SuppliedPrefix;
    }

    public String suppliedPrefixTipText() {
        return "The prefix to use in case of " + OutputPrefixType.SUPPLIED + ".";
    }

    public void setSetupUpload(AbstractSetupUpload value) {
        this.m_SetupUpload = value;
        this.reset();
    }

    public AbstractSetupUpload getSetupUpload() {
        return this.m_SetupUpload;
    }

    public String setupUploadTipText() {
        return "The scheme for uploading the currently best job setup.";
    }

    public void setJobRunnerSetup(JobRunnerSetup value) {
        this.m_JobRunnerSetup = value;
    }

    public JobRunnerSetup getJobRunnerSetup() {
        return this.m_JobRunnerSetup;
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    public double getCurrentFitness() {
        return this.m_Measure.adjust(this.m_BestFitness);
    }

    protected Properties storeSetup(Instances data, AbstractGeneticAlgorithm.GeneticAlgorithmJob job) {
        Properties result = new Properties();
        result.setProperty(PROPS_RELATION, data.relationName());
        result.setProperty(PROPS_FILTER, "");
        return result;
    }

    public Instances updateHeader(Instances data, AbstractGeneticAlgorithm.GeneticAlgorithmJob job) {
        Properties props = this.storeSetup(data, job);
        data.setRelationName(props.toString());
        return data;
    }

    protected synchronized void addResult(String key, Double val) {
        this.m_StoredResults.put(key, val);
    }

    protected synchronized Double getResult(String key) {
        return this.m_StoredResults.get(key);
    }

    protected synchronized void clearResults() {
        this.m_StoredResults.clear();
    }

    protected abstract ClassifierBasedGeneticAlgorithmJob newJob(int var1, int[] var2, Instances var3, Instances var4);

    public void calcFitness() {
        int i;
        this.m_JobRunner = this.m_JobRunnerSetup == null ? new LocalJobRunner() : this.m_JobRunnerSetup.newInstance();
        if (this.m_JobRunner instanceof ThreadLimiter) {
            ((ThreadLimiter)this.m_JobRunner).setNumThreads(this.getNumThreads());
        }
        this.m_JobRunner.setFlowContext(this.getFlowContext());
        JobList jobs = new JobList();
        boolean generateWeights = LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE);
        for (i = 0; i < this.getNumChrom(); ++i) {
            int[] weights = new int[this.getNumGenes()];
            StringBuilder weightStr = new StringBuilder();
            for (int j = 0; j < this.getNumGenes(); ++j) {
                int weight = 0;
                for (int k = 0; k < this.getBitsPerGene(); ++k) {
                    weight <<= 1;
                    if (!this.getGene(i, j * this.getBitsPerGene() + k)) continue;
                    ++weight;
                }
                weights[j] = weight;
                if (!generateWeights) continue;
                weightStr.append("" + weight);
            }
            if (generateWeights) {
                this.getLogger().fine("[" + this.m_CurrentIteration + "] before job: Chromosome " + i + " " + weightStr.toString());
            }
            jobs.add((Job)this.newJob(i, weights, this.m_Instances, this.m_TestInstances));
        }
        this.m_JobRunner.add(jobs);
        this.m_JobRunner.start();
        this.m_JobRunner.stop();
        for (i = 0; i < this.m_JobRunner.getJobs().size(); ++i) {
            ClassifierBasedGeneticAlgorithmJob job = (ClassifierBasedGeneticAlgorithmJob)((Object)this.m_JobRunner.getJobs().get(i));
            this.m_Fitness[job.getChromosome()] = job.getFitness() == null || this.m_Stopped ? Double.NEGATIVE_INFINITY : job.getFitness();
            job.cleanUp();
        }
        this.m_JobRunner.cleanUp();
        this.m_JobRunner.stop();
        this.m_JobRunner = null;
    }

    protected void preRun() {
        super.preRun();
        this.m_ClassIndex.setData(this.m_Instances);
        if (this.m_Instances.classIndex() == -1) {
            this.m_Instances.setClassIndex(this.m_ClassIndex.getIntIndex());
        }
        if (this.m_BestRange.getRange().length() != 0) {
            this.m_BestRange.setMax(this.m_Instances.numAttributes());
        }
        this.m_ClassLabelIndex.setData(this.m_Instances.classAttribute());
        String msg = this.m_Measure.isValid(this.m_Instances, this.m_ClassLabelIndex.getIndex());
        if (msg != null) {
            throw new IllegalArgumentException("Measure '" + this.m_Measure + "' cannot be used: " + msg);
        }
        this.m_SetupUpload.setFlowContext(this.getFlowContext());
        this.m_SetupUpload.start((AbstractGeneticAlgorithm)this);
        this.clearResults();
    }

    protected void postRun(String error) throws Exception {
        super.postRun(error);
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("Measure", (CallSite)((Object)("" + this.getMeasure())));
        this.m_SetupUpload.finish((AbstractGeneticAlgorithm)this, error, params);
    }

    public void stopExecution() {
        super.stopExecution();
        if (this.m_JobRunner != null) {
            this.m_JobRunner.terminate();
        }
    }

    public String toString() {
        return super.toString() + "\n" + this.getCurrentFitness() + " (measure: " + this.getMeasure() + ")";
    }

    public static abstract class ClassifierBasedGeneticAlgorithmJob<T extends AbstractClassifierBasedGeneticAlgorithm>
    extends AbstractGeneticAlgorithm.GeneticAlgorithmJob<T> {
        private static final long serialVersionUID = 8259167463381721274L;
        protected Measure m_Measure;
        protected int m_ClassLabelIndex;
        protected Instances m_Data;
        protected Instances m_TestData;
        protected int m_Seed;
        protected int m_Folds;

        public ClassifierBasedGeneticAlgorithmJob(T g, int chromosome, int[] w, Instances data, Instances testData) {
            super(g, chromosome, w);
            this.m_Measure = ((AbstractClassifierBasedGeneticAlgorithm)((Object)g)).getMeasure();
            this.m_Data = data;
            this.m_TestData = testData;
            this.m_Seed = ((AbstractClassifierBasedGeneticAlgorithm)((Object)g)).getCrossValidationSeed();
            this.m_Folds = ((AbstractClassifierBasedGeneticAlgorithm)((Object)g)).getFolds();
            WekaLabelIndex idx = ((AbstractClassifierBasedGeneticAlgorithm)((Object)g)).getClassLabelIndex().getClone();
            idx.setData(data.classAttribute());
            this.m_ClassLabelIndex = idx.getIntIndex();
        }

        protected Instances getInstances() {
            return this.m_Data;
        }

        protected Instances getTestInstances() {
            return this.m_TestData;
        }

        public Measure getMeasure() {
            return this.m_Measure;
        }

        public int getSeed() {
            return this.m_Seed;
        }

        public int getFolds() {
            return this.m_Folds;
        }

        protected String preProcessCheck() {
            String result = super.preProcessCheck();
            if (result == null && this.getInstances() == null) {
                result = "No instances provided!";
            }
            return result;
        }

        protected Evaluation postProcess(Evaluation eval) {
            if (!(((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getEvaluationPostProcessor() instanceof PassThrough)) {
                List<Evaluation> evals = ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getEvaluationPostProcessor().postProcess(eval);
                if (evals.size() != 1) {
                    throw new IllegalStateException("Expected one Evaluation object from post-processor, but received: " + evals.size());
                }
                eval = evals.get(0);
            }
            return eval;
        }

        protected double evaluateClassifier(Classifier cls, Instances data, int folds, int seed) throws Exception {
            WekaCrossValidationExecution evalExec = new WekaCrossValidationExecution();
            evalExec.setData(data);
            evalExec.setClassifier(cls);
            evalExec.setNumThreads(1);
            evalExec.setGenerator((CrossValidationFoldGenerator)ObjectCopyHelper.copyObject((Object)((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getGenerator()));
            evalExec.setFolds(folds);
            evalExec.setSeed(seed);
            String msg = evalExec.execute();
            if (msg != null) {
                throw new IllegalStateException(msg);
            }
            Evaluation eval = this.postProcess(evalExec.getEvaluation());
            return this.getMeasure().extract(eval, true, this.m_ClassLabelIndex);
        }

        protected double evaluateClassifier(Classifier cls, Instances data, Instances test) throws Exception {
            Evaluation eval = new Evaluation(data);
            cls.buildClassifier(data);
            eval.evaluateModel(cls, test, new Object[0]);
            eval = this.postProcess(eval);
            return this.getMeasure().extract(eval, true, this.m_ClassLabelIndex);
        }

        protected File createFileName(double fitness, Instances data, String ext) {
            String filename = ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputDirectory().getAbsolutePath() + File.separator;
            switch (((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputPrefixType()) {
                case NONE: {
                    break;
                }
                case RELATION: {
                    filename = filename + data.relationName() + "-";
                    break;
                }
                case SUPPLIED: {
                    filename = filename + ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getSuppliedPrefix() + "-";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output prefix type: " + ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputPrefixType());
                }
            }
            filename = filename + Double.toString(this.getMeasure().adjust(fitness)) + "." + ext;
            return new File(filename);
        }

        protected void outputDataset(double fitness, Instances data) throws Exception {
            File file = this.createFileName(fitness, data, "arff");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            Instances header = new Instances(data, 0);
            header = ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).updateHeader(header, this);
            writer.write(header.toString());
            writer.write("\n");
            for (int i = 0; i < data.numInstances(); ++i) {
                writer.write(data.instance(i).toString());
                writer.write("\n");
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }

        protected Map<String, Object> assembleSetup(double fitness, Classifier cls, int chromosome, int[] weights) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("Commandline", OptionUtils.getCommandLine((Object)this.getOwner()));
            result.put("Measure", "" + this.getMeasure());
            result.put("Fitness", fitness);
            result.put("Setup", OptionUtils.getCommandLine((Object)cls));
            result.put("Chromosome", chromosome);
            result.put("Weights", ClassifierBasedGeneticAlgorithmJob.weightsToString((int[])weights));
            return result;
        }

        protected void outputSetup(double fitness, Instances data, Classifier cls, int chromosome, int[] weights) throws Exception {
            File file = this.createFileName(fitness, data, "props.gz");
            Map<String, Object> setup = this.assembleSetup(fitness, cls, chromosome, weights);
            Properties props = AbstractSetupUpload.toProperties(setup);
            if (!props.save(file.getAbsolutePath())) {
                this.getLogger().warning("Failed to write setup to '" + file + "'!");
            }
        }

        protected void generateOutput(double fitness, Instances data, Classifier cls, int chromosome, int[] weights) throws Exception {
            switch (((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputType()) {
                case NONE: {
                    break;
                }
                case SETUP: {
                    this.outputSetup(fitness, data, cls, chromosome, weights);
                    break;
                }
                case DATA: {
                    this.outputDataset(fitness, data);
                    break;
                }
                case ALL: {
                    this.outputDataset(fitness, data);
                    this.outputSetup(fitness, data, cls, chromosome, weights);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output type: " + ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputType());
                }
            }
            String msg = ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getSetupUpload().upload(this.assembleSetup(fitness, cls, chromosome, weights));
            if (msg != null) {
                this.getLogger().warning("Failed to upload setup:\n" + msg);
            }
        }
    }
}

