/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import adams.core.Range;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import adams.data.instancesanalysis.pls.PreprocessingType;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public abstract class AbstractPLSAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    private static final long serialVersionUID = 633205527683462941L;
    protected AbstractSingleClassPLS m_Model;
    protected PreprocessingType m_PreprocessingType = PreprocessingType.NONE;
    protected boolean m_ReplaceMissing = false;
    protected int m_NumComponents = 20;
    protected LoadingsCalculations m_LoadingsCalculations = LoadingsCalculations.USE_FIRST_COMPONENT;
    protected Range m_ComponentRange = new Range("first-last");
    protected double[] m_Ranking;

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSet preprocessing type (default: NONE).\n", "P", 1, "-P <String>"));
        newVector.addElement(new Option("\tReplace missing values (default: false).", "R", 0, "-R"));
        newVector.addElement(new Option("\tSet the number of components (default: 20)", "N", 1, "-N <int>"));
        newVector.addElement(new Option("\tUsing first component or combine a range of components (default: first component)", "combine", 0, "-combine"));
        newVector.addElement(new Option("\tSet the range of components used (default: first-last)", "range", 1, "-range <String>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String preProcessingString = Utils.getOption((char)'P', (String[])options);
        if (preProcessingString.length() != 0) {
            this.setPreprocessingType(PreprocessingType.valueOf(preProcessingString));
        } else {
            this.setPreprocessingType(PreprocessingType.NONE);
        }
        this.setReplaceMissing(Utils.getFlag((String)"R", (String[])options));
        String numComponentsString = Utils.getOption((char)'N', (String[])options);
        if (numComponentsString.length() != 0) {
            this.setNumComponents(Integer.parseInt(numComponentsString));
        } else {
            this.setNumComponents(20);
        }
        if (Utils.getFlag((String)"combine", (String[])options)) {
            this.setLoadingsCalculations(LoadingsCalculations.COMBINE_COMPONENTS);
        } else {
            this.setLoadingsCalculations(LoadingsCalculations.USE_FIRST_COMPONENT);
        }
        String componentRangeString = Utils.getOption((String)"range", (String[])options);
        if (componentRangeString.length() != 0) {
            this.setComponentRange(new Range(componentRangeString));
        }
    }

    public String[] getOptions() {
        Vector<Object> result = new Vector<Object>();
        result.add("-P");
        result.add("" + this.getPreprocessingType());
        if (this.getReplaceMissing()) {
            result.add("-R");
        }
        result.add("-N");
        result.add("" + this.getNumComponents());
        if (this.getLoadingsCalculations() == LoadingsCalculations.COMBINE_COMPONENTS) {
            result.add("-combine -range");
            result.add(this.getComponentRange().getRange());
        }
        return result.toArray(new String[result.size()]);
    }

    public void setPreprocessingType(PreprocessingType value) {
        this.m_PreprocessingType = value;
    }

    public PreprocessingType getPreprocessingType() {
        return this.m_PreprocessingType;
    }

    public String preprocessingTypeTipText() {
        return "The type of preprocessing to perform.";
    }

    public void setReplaceMissing(boolean value) {
        this.m_ReplaceMissing = value;
    }

    public boolean getReplaceMissing() {
        return this.m_ReplaceMissing;
    }

    public String replaceMissingTipText() {
        return "Whether to replace missing values.";
    }

    public void setNumComponents(int value) {
        this.m_NumComponents = value;
    }

    public int getNumComponents() {
        return this.m_NumComponents;
    }

    public String numComponentsTipText() {
        return "The number of components to compute.";
    }

    public void setComponentRange(Range value) {
        this.m_ComponentRange = value;
    }

    public Range getComponentRange() {
        return this.m_ComponentRange;
    }

    public String componentRangeTipText() {
        return "The range of components to be used.";
    }

    public void setLoadingsCalculations(LoadingsCalculations value) {
        this.m_LoadingsCalculations = value;
    }

    public LoadingsCalculations getLoadingsCalculations() {
        return this.m_LoadingsCalculations;
    }

    public String loadingsCalculationsTipText() {
        return "The number of components to compute.";
    }

    protected abstract AbstractSingleClassPLS newModel();

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_Model = this.newModel();
        this.m_Model.setPreprocessingType(this.m_PreprocessingType);
        this.m_Model.setReplaceMissing(this.m_ReplaceMissing);
        this.m_Model.setNumComponents(this.m_NumComponents);
        this.m_Model.determineOutputFormat(instances);
        this.m_Model.transform(instances);
        Matrix coefficientsMatrix = this.m_Model.getLoadings();
        double[] coefficients = new double[coefficientsMatrix.getRowDimension()];
        this.m_ComponentRange.setMax(this.m_NumComponents);
        int[] components = this.m_ComponentRange.getIntIndices();
        switch (this.m_LoadingsCalculations) {
            case USE_FIRST_COMPONENT: {
                for (int i = 0; i < coefficients.length; ++i) {
                    coefficients[i] = Math.abs(coefficientsMatrix.get(i, 0));
                }
                Utils.normalize((double[])coefficients);
                break;
            }
            case COMBINE_COMPONENTS: {
                for (int i = 0; i < coefficients.length; ++i) {
                    for (int j = 0; j < components.length; ++j) {
                        int n = i;
                        coefficients[n] = coefficients[n] + Math.abs(coefficientsMatrix.get(i, components[j]));
                    }
                }
                Utils.normalize((double[])coefficients);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled loadings calculations: " + this.m_LoadingsCalculations);
            }
        }
        this.m_Ranking = coefficients;
    }

    public double evaluateAttribute(int i) throws Exception {
        return this.m_Ranking[i];
    }

    public String toString() {
        return this.m_Model.toString();
    }

    public static enum LoadingsCalculations {
        USE_FIRST_COMPONENT,
        COMBINE_COMPONENTS;

    }
}

