/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.core.DefaultCompare;
import adams.core.ErrorProvider;
import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class AggregateEvaluations
extends LoggingObject
implements ErrorProvider {
    private static final long serialVersionUID = 7021888369517311031L;
    protected String m_RelationName;
    protected List<Prediction> m_Predictions;
    protected transient Evaluation m_Aggregated;
    protected List<String> m_ClassLabels;
    protected boolean m_SortLabels;
    protected Comparator m_Comparator;
    protected boolean m_Reverse;
    protected String m_LastError;

    public AggregateEvaluations() {
        this.initialize();
    }

    protected void initialize() {
        this.m_RelationName = null;
        this.m_Predictions = new ArrayList<Prediction>();
        this.m_Aggregated = null;
        this.m_ClassLabels = null;
        this.m_SortLabels = false;
        this.m_Comparator = new DefaultCompare();
        this.m_Reverse = false;
    }

    public List<Prediction> getPredictions() {
        return this.m_Predictions;
    }

    public void setClassLabels(List<String> value) {
        this.m_ClassLabels = new ArrayList<String>(value);
        if (this.m_SortLabels) {
            this.m_ClassLabels.sort(this.m_Comparator);
            if (this.m_Reverse) {
                Collections.reverse(this.m_ClassLabels);
            }
        }
    }

    public List<String> getClassLabels() {
        return this.m_ClassLabels;
    }

    public void setSortLabels(boolean value) {
        this.m_SortLabels = value;
    }

    public boolean getSortLabels() {
        return this.m_SortLabels;
    }

    public void setComparator(Comparator value) {
        this.m_Comparator = value;
    }

    public Comparator getComparator() {
        return this.m_Comparator;
    }

    public void setReverse(boolean value) {
        this.m_Reverse = value;
    }

    public boolean getReverse() {
        return this.m_Reverse;
    }

    public String add(Prediction pred) {
        if (pred == null) {
            return "Cannot add null object!";
        }
        if (this.m_Predictions.size() > 0 && this.m_Predictions.get(0).getClass() != pred.getClass()) {
            return "Prediction classes differ: " + Utils.classToString((Object)this.m_Predictions.get(0)) + " != " + Utils.classToString((Object)pred);
        }
        this.m_Predictions.add(pred);
        this.m_Aggregated = null;
        return null;
    }

    public String add(Evaluation eval) {
        if (eval.predictions() == null) {
            return "No predictions stored in Evaluation object!";
        }
        if (eval.predictions().size() == 0) {
            return null;
        }
        if (this.m_Predictions.size() > 0) {
            if (this.m_Predictions.get(0).getClass() != ((Prediction)eval.predictions().get(0)).getClass()) {
                return "Prediction classes differ: " + Utils.classToString((Object)this.m_Predictions.get(0)) + " != " + Utils.classToString(eval.predictions().get(0));
            }
        } else {
            this.m_RelationName = eval.getHeader().relationName();
            if (eval.getHeader().classAttribute().isNominal()) {
                this.m_ClassLabels = new ArrayList<String>();
                for (int i = 0; i < eval.getHeader().classAttribute().numValues(); ++i) {
                    this.m_ClassLabels.add(eval.getHeader().classAttribute().value(i));
                }
            }
        }
        this.m_Predictions.addAll(eval.predictions());
        this.m_Aggregated = null;
        return null;
    }

    public String add(SpreadSheet sheet, int colAct, int colPred, int colWeight, int[] colsDist, boolean useColNamesAsLabels) {
        double[] predicted;
        double[] actual;
        int i;
        ArrayList<String> labels = null;
        boolean classification = false;
        double[][] dist = null;
        if (colsDist != null && colsDist.length == 0) {
            colsDist = null;
        }
        if (colsDist != null) {
            dist = new double[colsDist.length][];
            for (i = 0; i < colsDist.length; ++i) {
                dist[i] = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)colsDist[i]);
            }
        }
        if (colWeight == colAct || colWeight == colPred) {
            colWeight = -1;
        }
        if (colsDist != null) {
            for (int col : colsDist) {
                if (colWeight != col) continue;
                colWeight = -1;
                break;
            }
        }
        if (colsDist != null) {
            classification = true;
            labels = new ArrayList<String>();
            for (i = 0; i < dist.length; ++i) {
                if (useColNamesAsLabels) {
                    String name = sheet.getColumnName(colsDist[i]);
                    if (name.startsWith("Distribution (") && name.endsWith(")")) {
                        name = name.substring("Distribution (".length(), name.length() - 1);
                    }
                    labels.add(name);
                    continue;
                }
                labels.add("" + (i + 1));
            }
            this.setClassLabels(labels);
        }
        if (!sheet.isNumeric(colAct)) {
            String[] predictedLabels;
            String[] actualLabels;
            if (labels == null) {
                classification = true;
                labels = new ArrayList();
                for (String label : actualLabels = SpreadSheetUtils.getColumn((SpreadSheet)sheet, (int)colAct, (boolean)true, (boolean)true, (String)"?")) {
                    if (label.equals("?")) continue;
                    labels.add(label);
                }
                for (String label : predictedLabels = SpreadSheetUtils.getColumn((SpreadSheet)sheet, (int)colPred, (boolean)true, (boolean)true, (String)"?")) {
                    if (label.equals("?") || labels.contains(label)) continue;
                    labels.add(label);
                }
                this.setClassLabels(labels);
            }
            actualLabels = SpreadSheetUtils.getColumn((SpreadSheet)sheet, (int)colAct, (boolean)false, (boolean)false, (String)"?");
            actual = new double[actualLabels.length];
            for (i = 0; i < actualLabels.length; ++i) {
                actual[i] = actualLabels[i].equals("?") ? weka.core.Utils.missingValue() : (double)labels.indexOf(actualLabels[i]);
            }
            predictedLabels = SpreadSheetUtils.getColumn((SpreadSheet)sheet, (int)colPred, (boolean)false, (boolean)false, (String)"?");
            predicted = new double[predictedLabels.length];
            for (i = 0; i < predictedLabels.length; ++i) {
                predicted[i] = predictedLabels[i].equals("?") ? weka.core.Utils.missingValue() : (double)labels.indexOf(predictedLabels[i]);
            }
        } else {
            actual = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)colAct);
            predicted = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)colPred);
        }
        if (actual.length != predicted.length) {
            return "Number of actual and predicted values differ: " + actual.length + " != " + predicted.length;
        }
        if (colsDist != null) {
            for (i = 0; i < colsDist.length; ++i) {
                if (actual.length == dist[i].length) continue;
                return "Number of actual and class distribution (col #" + (colsDist[i] + 1) + ") values differ: " + actual.length + " != " + dist[i].length;
            }
        }
        double[] weight = null;
        if (colWeight > -1 && actual.length != (weight = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)colWeight)).length) {
            return "Number of actual and weight values differ: " + actual.length + " != " + weight.length;
        }
        for (i = 0; i < actual.length; ++i) {
            if (classification) {
                double[] clsDist;
                if (dist != null) {
                    clsDist = new double[dist.length];
                    for (int n = 0; n < clsDist.length; ++n) {
                        clsDist[n] = dist[n][i];
                    }
                    if (weight != null) {
                        this.add((Prediction)new NominalPrediction(actual[i], clsDist, weight[i]));
                        continue;
                    }
                    this.add((Prediction)new NominalPrediction(actual[i], clsDist));
                    continue;
                }
                clsDist = new double[labels.size()];
                clsDist[(int)predicted[i]] = 1.0;
                if (weight != null) {
                    this.add((Prediction)new NominalPrediction(actual[i], clsDist, weight[i]));
                    continue;
                }
                this.add((Prediction)new NominalPrediction(actual[i], clsDist));
                continue;
            }
            if (weight != null) {
                this.add((Prediction)new NumericPrediction(actual[i], predicted[i], weight[i]));
                continue;
            }
            this.add((Prediction)new NumericPrediction(actual[i], predicted[i]));
        }
        return null;
    }

    protected Evaluation doAggregate() {
        Evaluation result;
        int i;
        int distLen = 0;
        if (this.m_Predictions.size() > 0 && this.m_Predictions.get(0) instanceof NominalPrediction) {
            distLen = ((NominalPrediction)this.m_Predictions.get(0)).distribution().length;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        if (distLen == 0) {
            atts.add(new Attribute("Actual"));
        } else {
            ArrayList<Object> labels = new ArrayList();
            if (this.m_ClassLabels.size() == distLen) {
                labels = new ArrayList<String>(this.m_ClassLabels);
            } else {
                for (i = 0; i < distLen; ++i) {
                    if (this.m_ClassLabels == null) continue;
                    labels.add("" + (i + 1));
                }
            }
            atts.add(new Attribute("Actual", labels));
        }
        Instances data = new Instances(this.m_RelationName == null ? Environment.getInstance().getProject() : this.m_RelationName, atts, this.m_Predictions.size());
        data.setClassIndex(0);
        for (i = 0; i < this.m_Predictions.size(); ++i) {
            DenseInstance inst = new DenseInstance(this.m_Predictions.get(i).weight(), new double[]{this.m_Predictions.get(i).actual()});
            data.add((Instance)inst);
        }
        try {
            result = new Evaluation(data);
            for (i = 0; i < this.m_Predictions.size(); ++i) {
                if (distLen > 0) {
                    result.evaluateModelOnceAndRecordPrediction(((NominalPrediction)this.m_Predictions.get(i)).distribution(), data.instance(i));
                    continue;
                }
                result.evaluateModelOnceAndRecordPrediction(new double[]{this.m_Predictions.get(i).predicted()}, data.instance(i));
            }
        }
        catch (Exception e) {
            result = null;
            this.m_LastError = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to create 'fake' Evaluation object!", (Throwable)e);
        }
        return result;
    }

    public Evaluation aggregated() {
        if (this.m_Aggregated == null) {
            this.m_Aggregated = this.doAggregate();
        }
        return this.m_Aggregated;
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    public String toString() {
        return "# predictions: " + this.getPredictions().size() + "\nclass labels: " + (this.getClassLabels() != null ? this.getClassLabels() : "-none-") + "\nlast error: " + (this.hasLastError() ? this.getLastError() : "-none-");
    }
}

