/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.core.Utils;
import adams.data.binning.Bin;
import adams.data.binning.Binnable;
import adams.data.binning.BinnableInstances;
import adams.data.binning.algorithm.BinningAlgorithm;
import adams.data.binning.algorithm.BinningAlgorithmUser;
import adams.data.binning.algorithm.ManualBinning;
import adams.data.binning.operation.Bins;
import adams.data.binning.operation.Randomize;
import adams.data.binning.operation.Wrapping;
import adams.data.binning.postprocessing.MinBinSize;
import adams.flow.container.WekaTrainTestSetContainer;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.AbstractSplitGenerator;
import weka.classifiers.RandomSplitGenerator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;

public class BinnedNumericClassRandomSplitGenerator
extends AbstractSplitGenerator
implements RandomSplitGenerator,
BinningAlgorithmUser {
    private static final long serialVersionUID = -4813006743965500489L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;
    protected BinningAlgorithm m_Algorithm;
    protected boolean m_Generated;

    public BinnedNumericClassRandomSplitGenerator() {
    }

    public BinnedNumericClassRandomSplitGenerator(Instances data, long seed, double percentage) {
        this.setData(data);
        this.setSeed(seed);
        this.setPercentage(percentage);
        this.setPreserveOrder(false);
    }

    public BinnedNumericClassRandomSplitGenerator(Instances data, double percentage) {
        this.setData(data);
        this.setSeed(-1L);
        this.setPercentage(percentage);
        this.setPreserveOrder(true);
    }

    public BinnedNumericClassRandomSplitGenerator(Instances data, long seed, double percentage, boolean preserveOrder) {
        this.setData(data);
        this.setSeed(seed);
        this.setPercentage(percentage);
        this.setPreserveOrder(preserveOrder);
    }

    public String globalInfo() {
        return "Generates random splits of datasets with numeric classes. Uses a binning algorithm to obtain similar distribution in splits. Order can be preserved.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new ManualBinning());
    }

    @Override
    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    @Override
    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage to use for training (0-1).";
    }

    @Override
    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    @Override
    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, the order in the data is preserved in the split.";
    }

    public void setAlgorithm(BinningAlgorithm value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public BinningAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The binning algorithm to apply to the data.";
    }

    @Override
    public void setData(Instances value) {
        super.setData(value);
        if (this.m_Data != null) {
            if (this.m_Data.classIndex() == -1) {
                throw new IllegalArgumentException("No class attribute set!");
            }
            if (!this.m_Data.classAttribute().isNumeric()) {
                throw new IllegalArgumentException("Class attribute is not numeric!");
            }
        }
    }

    @Override
    protected boolean canRandomize() {
        return !this.m_PreserveOrder;
    }

    @Override
    protected void doInitializeIterator() {
        if (this.m_Data == null) {
            throw new IllegalStateException("No data available!");
        }
        this.m_Generated = false;
    }

    @Override
    protected boolean checkNext() {
        return !this.m_Generated;
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        Instances testSet;
        Instances trainSet;
        int i;
        List<Binnable<Instance>> binnableInst;
        this.m_Generated = true;
        try {
            binnableInst = BinnableInstances.toBinnableUsingClass(this.m_Data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create binnable Instances!", e);
        }
        Wrapping.addTmpIndex(binnableInst);
        if (this.canRandomize()) {
            Randomize.randomizeData(binnableInst, (long)this.m_Seed);
        }
        List binInst = this.m_Algorithm.generateBins(binnableInst);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Bins: " + Utils.arrayToString((Object)Bins.binSizes((List)binInst)));
        }
        MinBinSize minBinSize = new MinBinSize();
        minBinSize.setMinSize(2);
        binInst = minBinSize.postProcessBins(binInst);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Bins after postprocessing: " + Utils.arrayToString((Object)Bins.binSizes((List)binInst)));
        }
        int maxTotal = (int)Math.round((double)this.m_Data.size() * this.m_Percentage);
        int[] maxPerBin = new int[binInst.size()];
        for (i = 0; i < binInst.size(); ++i) {
            maxPerBin[i] = Math.min(((Bin)binInst.get(i)).size() - 1, (int)Math.round((double)((Bin)binInst.get(i)).size() * this.m_Percentage));
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("max total: " + maxTotal);
            this.getLogger().info("max per bin: " + Utils.arrayToString((Object)maxPerBin));
        }
        ArrayList<Binnable<Instance>> binnableTrain = new ArrayList<Binnable<Instance>>();
        int[] trainPerBin = new int[maxPerBin.length];
        int trainTotal = 0;
        while (trainTotal < maxTotal) {
            boolean added = false;
            for (i = 0; i < trainPerBin.length; ++i) {
                if (trainPerBin[i] >= maxPerBin[i] || trainTotal >= maxTotal) continue;
                binnableTrain.add((Binnable<Instance>)((Binnable)((Bin)binInst.get(i)).get().get(trainPerBin[i])));
                ++trainTotal;
                int n = i;
                trainPerBin[n] = trainPerBin[n] + 1;
                added = true;
            }
            if (added) continue;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("train total: " + trainTotal);
            this.getLogger().info("train per bin: " + Utils.arrayToString((Object)trainPerBin));
        }
        ArrayList<Binnable<Instance>> binnableTest = new ArrayList<Binnable<Instance>>();
        for (i = 0; i < trainPerBin.length; ++i) {
            for (int n = trainPerBin[i]; n < ((Bin)binInst.get(i)).size(); ++n) {
                binnableTest.add((Binnable<Instance>)((Binnable)((Bin)binInst.get(i)).get().get(n)));
            }
        }
        int[] trainRows = Wrapping.getTmpIndices(binnableTrain).toArray();
        int[] testRows = Wrapping.getTmpIndices(binnableTest).toArray();
        if (this.m_UseViews) {
            trainSet = new InstancesView(this.m_Data, trainRows);
            testSet = new InstancesView(this.m_Data, testRows);
        } else {
            trainSet = BinnableInstances.toInstances(binnableTrain);
            testSet = BinnableInstances.toInstances(binnableTest);
        }
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(trainSet, testSet, this.m_Seed, null, null, trainRows, testRows);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", percentage=" + this.m_Percentage;
    }
}

