/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.data.binning.Binnable;
import adams.data.binning.BinnableInstances;
import adams.data.splitgenerator.generic.crossvalidation.CrossValidationGenerator;
import adams.data.splitgenerator.generic.crossvalidation.FoldPair;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomization.Randomization;
import adams.data.splitgenerator.generic.stratification.DefaultStratification;
import adams.data.splitgenerator.generic.stratification.Stratification;
import adams.flow.container.WekaTrainTestSetContainer;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import weka.classifiers.AbstractSplitGenerator;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.CrossValidationHelper;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;

public class DefaultCrossValidationFoldGenerator
extends AbstractSplitGenerator
implements CrossValidationFoldGenerator {
    private static final long serialVersionUID = -8387205583429213079L;
    protected int m_NumFolds;
    protected int m_ActualNumFolds;
    protected boolean m_Stratify;
    protected transient int m_CurrentFold;
    protected String m_RelationName;
    protected boolean m_Randomize;
    protected transient CrossValidationGenerator m_Generator;
    protected transient List<FoldPair<Binnable<Instance>>> m_FoldPairs;

    public DefaultCrossValidationFoldGenerator() {
    }

    public DefaultCrossValidationFoldGenerator(Instances data, int numFolds, long seed, boolean stratify) {
        this(data, numFolds, seed, true, stratify, null);
    }

    public DefaultCrossValidationFoldGenerator(Instances data, int numFolds, long seed, boolean randomize, boolean stratify, String relName) {
        this.setData(data);
        this.setSeed(seed);
        this.setNumFolds(numFolds);
        this.setRelationName(relName);
        this.setStratify(stratify);
        this.setRandomize(randomize);
    }

    public String globalInfo() {
        return "Generates cross-validation fold pairs. Leave-one-out is performed when specified folds <2.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-folds", "numFolds", (Object)10);
        this.m_OptionManager.add("relation-name", "relationName", (Object)"@");
        this.m_OptionManager.add("randomize", "randomize", (Object)true);
        this.m_OptionManager.add("stratify", "stratify", (Object)true);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentFold = 1;
        this.m_ActualNumFolds = -1;
        this.m_FoldPairs = null;
    }

    @Override
    public void setData(Instances value) {
        super.setData(value);
        if (this.m_Data != null && this.getStratify() && this.m_Data.classIndex() == -1) {
            throw new IllegalArgumentException("No class attribute set!");
        }
    }

    @Override
    public void setNumFolds(int value) {
        this.m_NumFolds = value;
        this.reset();
    }

    @Override
    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public String numFoldsTipText() {
        return "The number of folds; use <2 for leave one out (LOO).";
    }

    @Override
    public int getActualNumFolds() {
        return this.m_ActualNumFolds;
    }

    @Override
    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    @Override
    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data is randomized first.";
    }

    @Override
    public void setStratify(boolean value) {
        this.m_Stratify = value;
        this.reset();
    }

    @Override
    public boolean getStratify() {
        return this.m_Stratify;
    }

    public String stratifyTipText() {
        return "If enabled, the folds get stratified in case of a nominal class attribute.";
    }

    @Override
    public void setRelationName(String value) {
        this.m_RelationName = value;
        this.reset();
    }

    @Override
    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return CrossValidationHelper.relationNameTemplateTipText();
    }

    @Override
    protected boolean canRandomize() {
        return this.m_Randomize;
    }

    @Override
    protected boolean checkNext() {
        return this.m_CurrentFold <= this.m_ActualNumFolds;
    }

    @Override
    protected void doInitializeIterator() {
        adams.data.splitgenerator.generic.stratification.PassThrough strat;
        DefaultRandomization rand;
        if (this.m_Data == null) {
            throw new IllegalStateException("No data provided!");
        }
        this.m_ActualNumFolds = this.m_NumFolds < 2 ? this.m_Data.numInstances() : this.m_NumFolds;
        if (this.m_Data.numInstances() < this.m_ActualNumFolds) {
            throw new IllegalArgumentException("Cannot have less data than folds: required=" + this.m_ActualNumFolds + ", provided=" + this.m_Data.numInstances());
        }
        this.m_Generator = new CrossValidationGenerator();
        this.m_Generator.setNumFolds(this.m_NumFolds);
        if (this.canRandomize()) {
            rand = new DefaultRandomization();
            rand.setSeed(this.m_Seed);
            rand.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setRandomization((Randomization)rand);
        } else {
            rand = new PassThrough();
            rand.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setRandomization((Randomization)rand);
        }
        if (this.m_Stratify && this.m_Data.classAttribute().isNominal() && this.m_ActualNumFolds < this.m_Data.numInstances()) {
            strat = new DefaultStratification();
            strat.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setStratification((Stratification)strat);
        } else {
            strat = new adams.data.splitgenerator.generic.stratification.PassThrough();
            strat.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setStratification((Stratification)strat);
        }
        if (this.m_RelationName == null || this.m_RelationName.isEmpty()) {
            this.m_RelationName = "@";
        }
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        Instances test;
        Instances train;
        if (this.m_CurrentFold > this.m_ActualNumFolds) {
            throw new NoSuchElementException("No more folds available!");
        }
        if (this.m_FoldPairs == null) {
            List<Binnable<Instance>> binnableInst;
            try {
                binnableInst = BinnableInstances.toBinnableUsingClass(this.m_Data);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create binnable Instances!", e);
            }
            this.m_FoldPairs = this.m_Generator.generate(binnableInst);
            this.m_OriginalIndices = new TIntArrayList();
            for (FoldPair<Binnable<Instance>> pair : this.m_FoldPairs) {
                this.m_OriginalIndices.addAll((TIntCollection)pair.getTest().getOriginalIndices());
            }
        }
        FoldPair<Binnable<Instance>> foldPair = this.m_FoldPairs.get(this.m_CurrentFold - 1);
        int[] trainRows = foldPair.getTrain().getOriginalIndices().toArray();
        int[] testRows = foldPair.getTest().getOriginalIndices().toArray();
        if (this.m_UseViews) {
            train = new InstancesView(this.m_Data, trainRows);
            test = new InstancesView(this.m_Data, testRows);
        } else {
            train = BinnableInstances.toInstances(foldPair.getTrain().getData());
            test = BinnableInstances.toInstances(foldPair.getTest().getData());
        }
        train.setRelationName(CrossValidationHelper.createRelationName(this.m_Data.relationName(), this.m_RelationName, this.m_CurrentFold, true));
        test.setRelationName(CrossValidationHelper.createRelationName(this.m_Data.relationName(), this.m_RelationName, this.m_CurrentFold, false));
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(train, test, this.m_Seed, this.m_CurrentFold, this.m_ActualNumFolds, trainRows, testRows);
        ++this.m_CurrentFold;
        if (this.m_CurrentFold > this.m_ActualNumFolds) {
            this.m_FoldPairs = null;
        }
        return result;
    }

    @Override
    public int[] crossValidationIndices() {
        return this.m_OriginalIndices.toArray();
    }

    @Override
    public String toString() {
        return super.toString() + ", numFolds=" + this.m_NumFolds + ", stratify=" + this.m_Stratify + ", relName=" + this.m_RelationName;
    }
}

