/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.core.base.BaseRegExp;
import adams.data.binning.Binnable;
import adams.data.binning.BinnableGroup;
import adams.data.binning.BinnableInstances;
import adams.data.binning.operation.Grouping;
import adams.data.binning.operation.Wrapping;
import adams.data.splitgenerator.generic.core.Subset;
import adams.data.splitgenerator.generic.crossvalidation.CrossValidationGenerator;
import adams.data.splitgenerator.generic.crossvalidation.FoldPair;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomization.Randomization;
import adams.data.splitgenerator.generic.stratification.DefaultStratification;
import adams.data.splitgenerator.generic.stratification.Stratification;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.container.WekaTrainTestSetContainer;
import com.github.fracpete.javautils.struct.Struct2;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import weka.classifiers.AbstractSplitGenerator;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.CrossValidationHelper;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;

public class GroupedCrossValidationFoldGenerator
extends AbstractSplitGenerator
implements CrossValidationFoldGenerator {
    private static final long serialVersionUID = -6949071991599401776L;
    protected int m_NumFolds;
    protected int m_ActualNumFolds;
    protected boolean m_Stratify;
    protected int m_CurrentFold;
    protected String m_RelationName;
    protected boolean m_Randomize;
    protected WekaAttributeIndex m_Index;
    protected BaseRegExp m_RegExp;
    protected String m_Group;
    protected transient CrossValidationGenerator m_Generator;
    protected transient List<Binnable<BinnableGroup<Instance>>> m_BinnableGroups;
    protected transient List<FoldPair<Binnable<BinnableGroup<Instance>>>> m_FoldPairs;

    public GroupedCrossValidationFoldGenerator() {
    }

    public GroupedCrossValidationFoldGenerator(Instances data, int numFolds, long seed, boolean stratify, boolean randomize, WekaAttributeIndex index, BaseRegExp regExp, String group) {
        this.setData(data);
        this.setSeed(seed);
        this.setNumFolds(numFolds);
        this.setStratify(stratify);
        this.setRandomize(randomize);
        this.setIndex(index);
        this.setRegExp(regExp);
        this.setGroup(group);
    }

    public String globalInfo() {
        return "Generates cross-validation fold pairs. Leave-one-out is performed when specified folds <2.\nEnsures that groups of instances stay together, determined via a regular expression (eg '^(.*)-([0-9]+)-(.*)$') and a group replacement string (eg '$2').";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-folds", "numFolds", (Object)10);
        this.m_OptionManager.add("relation-name", "relationName", (Object)"@");
        this.m_OptionManager.add("randomize", "randomize", (Object)true);
        this.m_OptionManager.add("stratify", "stratify", (Object)true);
        this.m_OptionManager.add("index", "index", (Object)new WekaAttributeIndex("first"));
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("group", "group", (Object)"$0");
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentFold = 1;
        this.m_ActualNumFolds = -1;
        this.m_FoldPairs = null;
        this.m_BinnableGroups = null;
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the attribute to determine the group from.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression for identifying the group (eg '^(.*)-([0-9]+)-(.*)$').";
    }

    public void setGroup(String value) {
        this.m_Group = value;
        this.reset();
    }

    public String getGroup() {
        return this.m_Group;
    }

    public String groupTipText() {
        return "The replacement string to use as group (eg '$2').";
    }

    @Override
    public void setData(Instances value) {
        super.setData(value);
        if (this.m_Data != null && this.getStratify() && this.m_Data.classIndex() == -1) {
            throw new IllegalArgumentException("No class attribute set!");
        }
    }

    @Override
    public void setNumFolds(int value) {
        this.m_NumFolds = value;
        this.reset();
    }

    @Override
    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public String numFoldsTipText() {
        return "The number of folds; use <2 for leave one out (LOO).";
    }

    @Override
    public int getActualNumFolds() {
        return this.m_ActualNumFolds;
    }

    @Override
    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    @Override
    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data is randomized first.";
    }

    @Override
    public void setStratify(boolean value) {
        this.m_Stratify = value;
        this.reset();
    }

    @Override
    public boolean getStratify() {
        return this.m_Stratify;
    }

    public String stratifyTipText() {
        return "If enabled, the folds get stratified in case of a nominal class attribute.";
    }

    @Override
    public void setRelationName(String value) {
        this.m_RelationName = value;
        this.reset();
    }

    @Override
    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return CrossValidationHelper.relationNameTemplateTipText();
    }

    @Override
    protected boolean canRandomize() {
        return this.m_Randomize;
    }

    @Override
    protected boolean checkNext() {
        return this.m_CurrentFold <= this.m_ActualNumFolds;
    }

    @Override
    protected void doInitializeIterator() {
        adams.data.splitgenerator.generic.stratification.PassThrough strat;
        DefaultRandomization rand;
        if (this.m_Data == null) {
            throw new IllegalStateException("No data provided!");
        }
        try {
            this.m_Index.setData(this.m_Data);
            List binnableInst = BinnableInstances.toBinnableUsingIndex(this.m_Data);
            binnableInst = Wrapping.addTmpIndex(binnableInst);
            List groupedInst = Grouping.groupAsList((List)binnableInst, (Grouping.GroupExtractor)new BinnableInstances.StringAttributeGroupExtractor(this.m_Index.getIntIndex(), this.m_RegExp.getValue(), this.m_Group));
            this.m_BinnableGroups = Wrapping.wrap((Collection)groupedInst, (Wrapping.BinValueExtractor)new BinnableInstances.GroupedClassValueBinValueExtractor());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create binnable Instances!", e);
        }
        this.m_ActualNumFolds = this.m_NumFolds < 2 ? this.m_BinnableGroups.size() : this.m_NumFolds;
        if (this.m_BinnableGroups.size() < this.m_ActualNumFolds) {
            throw new IllegalArgumentException("Cannot have less data than (grouped) folds: required=" + this.m_ActualNumFolds + ", provided=" + this.m_BinnableGroups.size());
        }
        this.m_Generator = new CrossValidationGenerator();
        this.m_Generator.setNumFolds(this.m_NumFolds);
        if (this.canRandomize()) {
            rand = new DefaultRandomization();
            rand.setSeed(this.m_Seed);
            rand.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setRandomization((Randomization)rand);
        } else {
            rand = new PassThrough();
            rand.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setRandomization((Randomization)rand);
        }
        if (this.m_Stratify && this.m_Data.classAttribute().isNominal() && this.m_ActualNumFolds < this.m_BinnableGroups.size()) {
            strat = new DefaultStratification();
            strat.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setStratification((Stratification)strat);
        } else {
            strat = new adams.data.splitgenerator.generic.stratification.PassThrough();
            strat.setLoggingLevel(this.m_LoggingLevel);
            this.m_Generator.setStratification((Stratification)strat);
        }
        if (this.m_RelationName == null || this.m_RelationName.isEmpty()) {
            this.m_RelationName = "@";
        }
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        Instances testSet;
        Instances trainSet;
        if (this.m_CurrentFold > this.m_ActualNumFolds) {
            throw new NoSuchElementException("No more folds available!");
        }
        if (this.m_FoldPairs == null) {
            this.m_FoldPairs = this.m_Generator.generate(this.m_BinnableGroups);
            this.m_OriginalIndices = new TIntArrayList();
            for (FoldPair<Binnable<BinnableGroup<Instance>>> pair : this.m_FoldPairs) {
                this.m_OriginalIndices.addAll((TIntCollection)Subset.extractIndicesAndBinnable((Subset)pair.getTest()).value1);
            }
        }
        FoldPair<Binnable<BinnableGroup<Instance>>> foldPair = this.m_FoldPairs.get(this.m_CurrentFold - 1);
        Struct2 subsetTrain = Subset.extractIndicesAndBinnable((Subset)foldPair.getTrain());
        Struct2 subsetTest = Subset.extractIndicesAndBinnable((Subset)foldPair.getTest());
        int[] trainRows = ((TIntList)subsetTrain.value1).toArray();
        int[] testRows = ((TIntList)subsetTest.value1).toArray();
        if (this.m_UseViews) {
            trainSet = new InstancesView(this.m_Data, trainRows);
            testSet = new InstancesView(this.m_Data, testRows);
        } else {
            trainSet = BinnableInstances.toInstances((List)subsetTrain.value2);
            testSet = BinnableInstances.toInstances((List)subsetTest.value2);
        }
        trainSet.setRelationName(CrossValidationHelper.createRelationName(this.m_Data.relationName(), this.m_RelationName, this.m_CurrentFold, true));
        testSet.setRelationName(CrossValidationHelper.createRelationName(this.m_Data.relationName(), this.m_RelationName, this.m_CurrentFold, false));
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(trainSet, testSet, this.m_Seed, this.m_CurrentFold, this.m_NumFolds, trainRows, testRows);
        ++this.m_CurrentFold;
        if (this.m_CurrentFold > this.m_ActualNumFolds) {
            this.m_FoldPairs = null;
        }
        return result;
    }

    @Override
    public int[] crossValidationIndices() {
        return this.m_OriginalIndices.toArray();
    }

    @Override
    public String toString() {
        return super.toString() + ", numFolds=" + this.m_NumFolds + ", stratify=" + this.m_Stratify + ", relName=" + this.m_RelationName + ", index=" + this.m_Index + ", regexp=" + this.m_RegExp + ", group=" + this.m_Group;
    }
}

