/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.util.Arrays;
import java.util.List;
import weka.classifiers.evaluation.AbstractEvaluationMetric;
import weka.classifiers.evaluation.InformationRetrievalEvaluationMetric;
import weka.classifiers.evaluation.StandardEvaluationMetric;
import weka.core.Instance;
import weka.core.Utils;

public class Dice
extends AbstractEvaluationMetric
implements StandardEvaluationMetric,
InformationRetrievalEvaluationMetric {
    private static final long serialVersionUID = -6174771017324139350L;
    public static final String NAME = "Dice";

    public String getMetricName() {
        return NAME;
    }

    public String getMetricDescription() {
        return "S\u00f8rensen\u2013Dice coefficient: DSC = 2TP / (2TP + FP + FN); calculated for the first class label.";
    }

    public boolean appliesToNominalClass() {
        return true;
    }

    public boolean appliesToNumericClass() {
        return false;
    }

    public List<String> getStatisticNames() {
        return Arrays.asList(NAME);
    }

    public double getStatistic(String statName) {
        return this.getStatistic(statName, 0);
    }

    public double getStatistic(String statName, int classIndex) {
        if (statName.equals(NAME)) {
            return 2.0 * this.m_baseEvaluation.numTruePositives(classIndex) / (2.0 * this.m_baseEvaluation.numTruePositives(classIndex) + this.m_baseEvaluation.numFalsePositives(classIndex) + this.m_baseEvaluation.numFalseNegatives(classIndex));
        }
        return Utils.missingValue();
    }

    public double getClassWeightedAverageStatistic(String statName) {
        return Utils.missingValue();
    }

    public String toSummaryString() {
        return Utils.padRight((String)NAME, (int)41) + Utils.doubleToString((double)this.getStatistic(NAME), (int)4) + "\n";
    }

    public void updateStatsForClassifier(double[] predictedDistribution, Instance instance) throws Exception {
    }

    public void updateStatsForPredictor(double predictedValue, Instance instance) throws Exception {
    }
}

