/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUnorderedColumnRange;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import weka.classifiers.simple.AbstractSimpleClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class FromPredictions
extends AbstractSimpleClassifier {
    private static final long serialVersionUID = 3788758906281773914L;
    protected PlaceholderFile m_PredictionsFile;
    protected SpreadSheetReader m_Reader;
    protected SpreadSheetColumnIndex m_Actual;
    protected int m_ActualIndex;
    protected SpreadSheetColumnIndex m_Predicted;
    protected int m_PredictedIndex;
    protected SpreadSheetColumnIndex m_Weight;
    protected int m_WeightIndex;
    protected SpreadSheetUnorderedColumnRange m_ClassDistribution;
    protected int[] m_ClassDistributionIndices;
    protected SpreadSheetColumnRange m_Additional;
    protected int[] m_AdditionalIndices;
    protected SpreadSheet m_Predictions;

    public String globalInfo() {
        return "Encapsulates predictions from a spreadsheet. Dummy classifier for the Investigator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("predictions-file", "predictionsFile", (Object)new PlaceholderFile());
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("actual", "actual", (Object)new SpreadSheetColumnIndex("Actual"));
        this.m_OptionManager.add("predicted", "predicted", (Object)new SpreadSheetColumnIndex("Predicted"));
        this.m_OptionManager.add("weight", "weight", (Object)new SpreadSheetColumnIndex(""));
        this.m_OptionManager.add("class-distribution", "classDistribution", (Object)new SpreadSheetUnorderedColumnRange(""));
        this.m_OptionManager.add("additional", "additional", (Object)new SpreadSheetColumnRange(""));
    }

    public void setPredictionsFile(PlaceholderFile value) {
        this.m_PredictionsFile = value;
        this.reset();
    }

    public PlaceholderFile getPredictionsFile() {
        return this.m_PredictionsFile;
    }

    public String predictionsFileTipText() {
        return "The spreadsheet file with the predictions.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The spreadsheet reader to use.";
    }

    public void setActual(SpreadSheetColumnIndex value) {
        this.m_Actual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActual() {
        return this.m_Actual;
    }

    public String actualTipText() {
        return "The column with the actual values.";
    }

    public void setPredicted(SpreadSheetColumnIndex value) {
        this.m_Predicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredicted() {
        return this.m_Predicted;
    }

    public String predictedTipText() {
        return "The column with the predicted values.";
    }

    public void setWeight(SpreadSheetColumnIndex value) {
        this.m_Weight = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getWeight() {
        return this.m_Weight;
    }

    public String weightTipText() {
        return "The column with the weight values.";
    }

    public void setClassDistribution(SpreadSheetUnorderedColumnRange value) {
        this.m_ClassDistribution = value;
        this.reset();
    }

    public SpreadSheetUnorderedColumnRange getClassDistribution() {
        return this.m_ClassDistribution;
    }

    public String classDistributionTipText() {
        return "The columns containing the class distribution.";
    }

    public void setAdditional(SpreadSheetColumnRange value) {
        this.m_Additional = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAdditional() {
        return this.m_Additional;
    }

    public String additionalTipText() {
        return "The additional columns to add to the plot containers.";
    }

    public SpreadSheet getPredictions() {
        return this.m_Predictions;
    }

    public int getActualIndex() {
        return this.m_ActualIndex;
    }

    public int getPredictedIndex() {
        return this.m_PredictedIndex;
    }

    public int getWeightIndex() {
        return this.m_WeightIndex;
    }

    public int[] getClassDistributionIndices() {
        return this.m_ClassDistributionIndices;
    }

    public int[] getAdditionalIndices() {
        return this.m_AdditionalIndices;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.m_ActualIndex = -1;
        this.m_PredictedIndex = -1;
        this.m_WeightIndex = -1;
        this.m_ClassDistributionIndices = new int[0];
        this.m_AdditionalIndices = new int[0];
        this.m_Predictions = this.m_Reader.read((File)this.m_PredictionsFile);
        if (this.m_Predictions == null) {
            throw new IllegalStateException("Failed to load predictions from: " + this.m_PredictionsFile);
        }
        this.m_Actual.setData((Object)this.m_Predictions);
        if (this.m_Actual.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate actual column: " + this.m_Actual.getIndex());
        }
        this.m_Predicted.setData((Object)this.m_Predictions);
        if (this.m_Predicted.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate predicted column: " + this.m_Predicted.getIndex());
        }
        if (!this.m_Weight.isEmpty()) {
            this.m_Weight.setData((Object)this.m_Predictions);
            if (this.m_Weight.getIntIndex() == -1) {
                throw new IllegalStateException("Failed to locate weight column: " + this.m_Weight.getIndex());
            }
        }
        this.m_PredictedIndex = this.m_Predicted.getIntIndex();
        this.m_ActualIndex = this.m_Actual.getIntIndex();
        this.m_WeightIndex = this.m_Weight.getIntIndex();
        if (this.m_WeightIndex == this.m_PredictedIndex || this.m_WeightIndex == this.m_ActualIndex) {
            this.m_WeightIndex = -1;
        }
        if (!this.m_ClassDistribution.isEmpty()) {
            this.m_ClassDistribution.setData((Object)this.m_Predictions);
            for (int index : this.m_ClassDistributionIndices = this.m_ClassDistribution.getIntIndices()) {
                if (index != this.m_WeightIndex) continue;
                this.m_WeightIndex = -1;
                break;
            }
        }
        if (!this.m_Additional.isEmpty()) {
            this.m_Additional.setData((Object)this.m_Predictions);
            TIntArrayList additional = new TIntArrayList(this.m_Additional.getIntIndices());
            additional.remove(this.m_ActualIndex);
            additional.remove(this.m_PredictedIndex);
            additional.remove(this.m_WeightIndex);
            for (int index : this.m_ClassDistributionIndices) {
                additional.remove(index);
            }
            this.m_AdditionalIndices = additional.toArray();
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        return 0.0;
    }
}

