/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableMultipleClassifiersCombiner;
import weka.classifiers.meta.Vote;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class AbstainVote
extends RandomizableMultipleClassifiersCombiner
implements WeightedInstancesHandler,
AbstainingClassifier {
    static final long serialVersionUID = -637891196294399624L;
    public static final int AVERAGE_RULE = 1;
    public static final int PRODUCT_RULE = 2;
    public static final int MAJORITY_VOTING_RULE = 3;
    public static final int MIN_RULE = 4;
    public static final int MAX_RULE = 5;
    public static final int MEDIAN_RULE = 6;
    public static final Tag[] TAGS_RULES = new Tag[]{new Tag(1, "AVG", "Average of Probabilities"), new Tag(2, "PROD", "Product of Probabilities"), new Tag(3, "MAJ", "Majority Voting"), new Tag(4, "MIN", "Minimum Probability"), new Tag(5, "MAX", "Maximum Probability"), new Tag(6, "MED", "Median")};
    protected int m_CombinationRule = 1;
    protected Random m_Random;
    protected double m_MaxDifference;
    protected double[] m_MaxDifferences;
    protected double[] m_Mins;
    protected double[] m_Maxes;
    protected boolean[] m_IsPercent;
    protected String m_MaxDifferences_string = "";

    public String globalInfo() {
        return "Class for combining classifiers. Different combinations of probability estimates for classification are available.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe combination rule to use\n\t(default: AVG)", "R", 1, "-R " + Tag.toOptionList((Tag[])TAGS_RULES)));
        result.addElement(new Option("\tMaximum acceptable difference between classifiers\n\t(default: 10)\n", "E", 1, "-E <String>"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<Object> result = new Vector<Object>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-R");
        result.add("" + this.getCombinationRule());
        result.add("-E");
        result.add(this.getMaxDifference());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'R', (String[])options);
        if (tmpStr.length() != 0) {
            this.setCombinationRule(new SelectedTag(tmpStr, TAGS_RULES));
        } else {
            this.setCombinationRule(new SelectedTag(1, TAGS_RULES));
        }
        String curropt = Utils.getOption((char)'E', (String[])options);
        if (curropt.length() != 0) {
            this.setMaxDifference(curropt);
        } else {
            this.setMaxDifference("0-100,10");
        }
        super.setOptions(options);
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ludmila I. Kuncheva");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining Pattern Classifiers: Methods and Algorithms");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "John Wiley and Sons, Inc.");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "J. Kittler and M. Hatef and Robert P.W. Duin and J. Matas");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "On combining classifiers");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        additional.setValue(TechnicalInformation.Field.VOLUME, "20");
        additional.setValue(TechnicalInformation.Field.NUMBER, "3");
        additional.setValue(TechnicalInformation.Field.PAGES, "226-239");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        if (this.m_CombinationRule == 2 || this.m_CombinationRule == 3) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enableDependency(Capabilities.Capability.NOMINAL_CLASS);
        } else if (this.m_CombinationRule == 6) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NUMERIC_CLASS);
            result.enableDependency(Capabilities.Capability.NUMERIC_CLASS);
        }
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.parseString(this.getMaxDifference());
        Instances newData = new Instances(data);
        newData.deleteWithMissingClass();
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            this.getClassifier(i).buildClassifier(newData);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        double result;
        switch (this.m_CombinationRule) {
            case 1: {
                if (instance.classAttribute().isNumeric()) {
                    return this.classificationNumericAverage(instance);
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                double[] dist = this.distributionForInstance(instance);
                if (instance.classAttribute().isNominal()) {
                    int index = Utils.maxIndex((double[])dist);
                    if (dist[index] == 0.0) {
                        result = Utils.missingValue();
                        break;
                    }
                    result = index;
                    break;
                }
                if (instance.classAttribute().isNumeric()) {
                    result = dist[0];
                    break;
                }
                result = Utils.missingValue();
                break;
            }
            case 6: {
                result = this.classifyInstanceMedian(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        return result;
    }

    protected double classifyInstanceMedian(Instance instance) throws Exception {
        if (instance.classAttribute().isNumeric()) {
            return this.classificationNumericMedian(instance);
        }
        double[] results = new double[this.m_Classifiers.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.m_Classifiers[i].classifyInstance(instance);
        }
        double result = results.length == 0 ? 0.0 : (results.length == 1 ? results[0] : Utils.kthSmallestValue((double[])results, (int)(results.length / 2)));
        return result;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = new double[instance.numClasses()];
        switch (this.m_CombinationRule) {
            case 1: {
                result = this.distributionForInstanceAverage(instance);
                break;
            }
            case 2: {
                result = this.distributionForInstanceProduct(instance);
                break;
            }
            case 3: {
                result = this.distributionForInstanceMajorityVoting(instance);
                break;
            }
            case 4: {
                result = this.distributionForInstanceMin(instance);
                break;
            }
            case 5: {
                result = this.distributionForInstanceMax(instance);
                break;
            }
            case 6: {
                result[0] = this.classifyInstance(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        if (!instance.classAttribute().isNumeric() && Utils.sum((double[])result) > 0.0) {
            Utils.normalize((double[])result);
        }
        return result;
    }

    protected double classificationNumericMedian(Instance instance) throws Exception {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        double[] results = new double[this.m_Classifiers.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.m_Classifiers[i].classifyInstance(instance);
            if (results[i] > max) {
                max = results[i];
            }
            if (!(results[i] < min)) continue;
            min = results[i];
        }
        if (Math.abs(max - min) > this.m_MaxDifference) {
            return Utils.missingValue();
        }
        double result = results.length == 0 ? 0.0 : (results.length == 1 ? results[0] : Utils.kthSmallestValue((double[])results, (int)(results.length / 2)));
        return result;
    }

    protected boolean checkOK(double avgPrediction, double difference) {
        for (int i = 0; i < this.m_MaxDifferences.length; ++i) {
            if (!(avgPrediction >= this.m_Mins[i]) || !(avgPrediction <= this.m_Maxes[i])) continue;
            if (this.m_IsPercent[i]) {
                return difference / avgPrediction <= this.m_MaxDifferences[i];
            }
            return difference <= this.m_MaxDifferences[i];
        }
        return false;
    }

    protected void parseString(String input) {
        if (input == null) {
            return;
        }
        String[] entries = input.split(";");
        this.m_Mins = new double[entries.length];
        this.m_Maxes = new double[entries.length];
        this.m_MaxDifferences = new double[entries.length];
        this.m_IsPercent = new boolean[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            String[] entry = entries[i].split(",");
            String[] range = entry[0].split("-");
            double val1 = Double.parseDouble(range[0]);
            double val2 = Double.parseDouble(range[1]);
            double diff = Double.MAX_VALUE;
            if (entry[1].matches(".*%")) {
                String d = entry[1].replaceAll("%", "");
                diff = Double.parseDouble(d) / 100.0;
                this.m_IsPercent[i] = true;
            } else {
                diff = Double.parseDouble(entry[1]);
                this.m_IsPercent[i] = false;
            }
            this.m_Mins[i] = Math.min(val1, val2);
            this.m_Maxes[i] = Math.max(val1, val2);
            this.m_MaxDifferences[i] = diff;
        }
    }

    protected String diffToString() {
        Object res = "";
        if (this.m_MaxDifferences == null) {
            return "";
        }
        for (int i = 0; i < this.m_MaxDifferences.length; ++i) {
            if (i != 0) {
                res = (String)res + ";";
            }
            res = (String)res + this.m_Mins[i] + "-" + this.m_Maxes[i] + ",";
            res = this.m_IsPercent[i] ? (String)res + this.m_MaxDifferences[i] * 100.0 + "%" : (String)res + this.m_MaxDifferences[i];
        }
        return res;
    }

    protected double classificationNumericAverage(Instance instance) throws Exception {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        double sum = 0.0;
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            double pred = this.getClassifier(i).classifyInstance(instance);
            if (pred > max) {
                max = pred;
            }
            if (pred < min) {
                min = pred;
            }
            sum += pred;
        }
        double result = sum / (double)this.m_Classifiers.length;
        double difference = Math.abs(max - min);
        if (!this.checkOK(result, difference)) {
            return Utils.missingValue();
        }
        return result;
    }

    protected double[] distributionForInstanceAverage(Instance instance) throws Exception {
        if (instance.classAttribute().isNumeric()) {
            double[] ret = new double[]{this.classificationNumericAverage(instance)};
            return ret;
        }
        double[] probs = this.getClassifier(0).distributionForInstance(instance);
        probs = (double[])probs.clone();
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            for (int j = 0; j < dist.length; ++j) {
                int n = j;
                probs[n] = probs[n] + dist[j];
            }
        }
        int j = 0;
        while (j < probs.length) {
            int n = j++;
            probs[n] = probs[n] / (double)this.m_Classifiers.length;
        }
        return probs;
    }

    protected double[] distributionForInstanceProduct(Instance instance) throws Exception {
        double[] probs = this.getClassifier(0).distributionForInstance(instance);
        probs = (double[])probs.clone();
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            for (int j = 0; j < dist.length; ++j) {
                int n = j;
                probs[n] = probs[n] * dist[j];
            }
        }
        return probs;
    }

    protected double[] distributionForInstanceMajorityVoting(Instance instance) throws Exception {
        double[] probs = new double[instance.classAttribute().numValues()];
        double[] votes = new double[probs.length];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            int j;
            probs = this.getClassifier(i).distributionForInstance(instance);
            int maxIndex = 0;
            for (j = 0; j < probs.length; ++j) {
                if (!(probs[j] > probs[maxIndex])) continue;
                maxIndex = j;
            }
            for (j = 0; j < probs.length; ++j) {
                if (probs[j] != probs[maxIndex]) continue;
                int n = j;
                votes[n] = votes[n] + 1.0;
            }
        }
        int tmpMajorityIndex = 0;
        for (int k = 1; k < votes.length; ++k) {
            if (!(votes[k] > votes[tmpMajorityIndex])) continue;
            tmpMajorityIndex = k;
        }
        Vector<Integer> majorityIndexes = new Vector<Integer>();
        for (int k = 0; k < votes.length; ++k) {
            if (votes[k] != votes[tmpMajorityIndex]) continue;
            majorityIndexes.add(k);
        }
        int majorityIndex = (Integer)majorityIndexes.get(this.m_Random.nextInt(majorityIndexes.size()));
        probs = new double[probs.length];
        probs[majorityIndex] = 1.0;
        return probs;
    }

    protected double[] distributionForInstanceMax(Instance instance) throws Exception {
        double[] max = this.getClassifier(0).distributionForInstance(instance);
        max = (double[])max.clone();
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            for (int j = 0; j < dist.length; ++j) {
                if (!(max[j] < dist[j])) continue;
                max[j] = dist[j];
            }
        }
        return max;
    }

    protected double[] distributionForInstanceMin(Instance instance) throws Exception {
        double[] min = this.getClassifier(0).distributionForInstance(instance);
        min = (double[])min.clone();
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            for (int j = 0; j < dist.length; ++j) {
                if (!(dist[j] < min[j])) continue;
                min[j] = dist[j];
            }
        }
        return min;
    }

    public String combinationRuleTipText() {
        return "The combination rule used.";
    }

    public SelectedTag getCombinationRule() {
        return new SelectedTag(this.m_CombinationRule, TAGS_RULES);
    }

    public void setCombinationRule(SelectedTag newRule) {
        if (newRule.getTags() == TAGS_RULES) {
            this.m_CombinationRule = newRule.getSelectedTag().getID();
        }
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Vote: No model built yet.";
        }
        Object result = "Vote combines";
        result = (String)result + " the probability distributions of these base learners:\n";
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            result = (String)result + "\t" + this.getClassifierSpec(i) + "\n";
        }
        result = (String)result + "using the '";
        switch (this.m_CombinationRule) {
            case 1: {
                result = (String)result + "Average of Probabilities";
                break;
            }
            case 2: {
                result = (String)result + "Product of Probabilities";
                break;
            }
            case 3: {
                result = (String)result + "Majority Voting";
                break;
            }
            case 4: {
                result = (String)result + "Minimum Probability";
                break;
            }
            case 5: {
                result = (String)result + "Maximum Probability";
                break;
            }
            case 6: {
                result = (String)result + "Median Probability";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        result = (String)result + "' combination rule \n";
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 7930 $");
    }

    public static void main(String[] argv) {
        AbstainVote.runClassifier((Classifier)new Vote(), (String[])argv);
    }

    @Override
    public boolean canAbstain() {
        return true;
    }

    @Override
    public double getAbstentionClassification(Instance inst) throws Exception {
        return this.classifyInstance(inst);
    }

    @Override
    public double[] getAbstentionDistribution(Instance inst) throws Exception {
        return new double[]{this.getAbstentionClassification(inst)};
    }

    public String maxDifferenceTipText() {
        return "Max difference, else abstain.";
    }

    public String getMaxDifference() {
        return this.m_MaxDifferences_string;
    }

    public void setMaxDifference(String s) {
        this.m_MaxDifferences_string = s;
    }
}

