/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.ObjectCopyHelper;
import adams.core.option.OptionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.GPD;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class Fallback
extends AbstractClassifier {
    private static final long serialVersionUID = 2724955696815687608L;
    protected Classifier m_Base = this.getDefaultBase();
    protected Classifier m_ActualBase;
    protected Classifier m_Fallback = this.getDefaultFallback();
    protected Classifier m_ActualFallback;

    public String globalInfo() {
        return "In case the base classifier fails to make predictions, uses fallback one.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tBase classifier.\n\t(default: " + OptionUtils.getCommandLine((Object)this.getDefaultBase()) + ")", "base", 1, "-base <classname+options>"));
        result.addElement(new Option("\tFallback classifier.\n\t(default: " + OptionUtils.getCommandLine((Object)this.getDefaultBase()) + ")", "fallback", 1, "-fallback <classname+options>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to base classifier " + this.getBase().getClass().getName() + ":"));
        result.addAll(Collections.list(((OptionHandler)this.getBase()).listOptions()));
        result.addElement(new Option("", "", 0, "\nOptions specific to fallback classifier " + this.getFallback().getClass().getName() + ":"));
        result.addAll(Collections.list(((OptionHandler)this.getFallback()).listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String opt = Utils.getOption((String)"base", (String[])options);
        if (opt.isEmpty()) {
            this.setBase(this.getDefaultBase());
        } else {
            this.setBase((Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)opt));
        }
        opt = Utils.getOption((String)"fallback", (String[])options);
        if (opt.isEmpty()) {
            this.setFallback(this.getDefaultFallback());
        } else {
            this.setFallback((Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)opt));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-base");
        result.add(OptionUtils.getCommandLine((Object)this.getBase()));
        result.add("-fallback");
        result.add(OptionUtils.getCommandLine((Object)this.getFallback()));
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[0]);
    }

    protected Classifier getDefaultBase() {
        return new GPD();
    }

    public void setBase(Classifier value) {
        this.m_Base = value;
    }

    public Classifier getBase() {
        return this.m_Base;
    }

    public String baseTipText() {
        return "The base classifier to use for making predictions.";
    }

    protected Classifier getDefaultFallback() {
        return new ZeroR();
    }

    public void setFallback(Classifier value) {
        this.m_Fallback = value;
    }

    public Classifier getFallback() {
        return this.m_Fallback;
    }

    public String fallbackTipText() {
        return "The fallback classifier to use for making predictions.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = (Capabilities)this.m_Base.getCapabilities().clone();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setOwner((CapabilitiesHandler)this);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_ActualBase = null;
        this.m_ActualFallback = null;
        try {
            if (this.getDebug()) {
                System.out.println("Training base classifier");
            }
            this.m_ActualBase = (Classifier)ObjectCopyHelper.copyObject((Object)this.m_Base);
            this.m_ActualBase.buildClassifier(data);
        }
        catch (Exception e) {
            System.err.println("Failed to build base classifier: " + OptionUtils.getCommandLine((Object)this.m_Base));
            e.printStackTrace();
            this.m_ActualBase = null;
        }
        if (this.getDebug()) {
            System.out.println("Training fallback classifier");
        }
        this.m_ActualFallback = (Classifier)ObjectCopyHelper.copyObject((Object)this.m_Fallback);
        this.m_ActualFallback.buildClassifier(data);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_ActualBase == null) {
            return this.m_ActualFallback.classifyInstance(instance);
        }
        try {
            return this.m_ActualBase.classifyInstance(instance);
        }
        catch (Exception e) {
            if (this.getDebug()) {
                System.err.println("Falling back, classifyInstance failed on: " + instance);
            }
            return this.m_ActualFallback.classifyInstance(instance);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ActualBase == null) {
            return this.m_ActualFallback.distributionForInstance(instance);
        }
        try {
            return this.m_ActualBase.distributionForInstance(instance);
        }
        catch (Exception e) {
            if (this.getDebug()) {
                System.err.println("Falling back, distributionForInstance failed on: " + instance);
            }
            return this.m_ActualFallback.distributionForInstance(instance);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Base\n").append("====\n\n").append("" + this.m_ActualBase);
        result.append("\n");
        result.append("Fallback\n").append("========\n\n").append("" + this.m_ActualFallback);
        return result.toString();
    }
}

