/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.option.WekaCommandLineHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class HighLowSplit
extends SingleClassifierEnhancer
implements WeightedInstancesHandler {
    private static final long serialVersionUID = -1948204213212845838L;
    protected Classifier m_hiClassifier = new ZeroR();
    protected Classifier m_loClassifier = new ZeroR();
    protected double m_hiLopoint = 10.0;
    protected double m_loHipoint = 15.0;
    protected double m_splitpoint = 12.5;

    public String globalInfo() {
        return "Uses base classifier to get guess, then get prediction from either lo/hi classifier";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.rules.ZeroR";
    }

    protected String[] defaultClassifierOptions() {
        return new String[0];
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        newVector.addElement(new Option("\tLowest value for hi classifier\n\t(default: 10)\n", "S", 1, "-S <dbl>"));
        newVector.addElement(new Option("\tHighest value for lo classifier\n\t(default: 15)\n", "P", 1, "-P <dbl>"));
        newVector.addElement(new Option("\tDecision boundary for hi/lo classifier\n\t(default: 12.5)\n", "E", 1, "-E <dbl>"));
        newVector.addElement(new Option("\tFull name of hi classifier.\n\t(default: " + this.defaultClassifierString() + (String)(this.defaultClassifierOptions().length > 0 ? " with options " + Utils.joinOptions((String[])this.defaultClassifierOptions()) + ")" : ")"), "F", 1, "-F"));
        newVector.addAll(Collections.list(super.listOptions()));
        newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_hiClassifier.getClass().getName() + ":"));
        newVector.addAll(Collections.list(((OptionHandler)this.m_hiClassifier).listOptions()));
        newVector.addElement(new Option("\tFull name of lo classifier.\n\t(default: " + this.defaultClassifierString() + (String)(this.defaultClassifierOptions().length > 0 ? " with options " + Utils.joinOptions((String[])this.defaultClassifierOptions()) + ")" : ")"), "G", 1, "-G"));
        newVector.addAll(Collections.list(super.listOptions()));
        newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_loClassifier.getClass().getName() + ":"));
        newVector.addAll(Collections.list(((OptionHandler)this.m_loClassifier).listOptions()));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String curropt = Utils.getOption((char)'S', (String[])options);
        if (curropt.length() != 0) {
            this.setHiLopoint(Double.parseDouble(curropt));
        } else {
            this.setHiLopoint(10.0);
        }
        curropt = Utils.getOption((char)'P', (String[])options);
        if (curropt.length() != 0) {
            this.setLoHipoint(Double.parseDouble(curropt));
        } else {
            this.setLoHipoint(15.0);
        }
        curropt = Utils.getOption((char)'E', (String[])options);
        if (curropt.length() != 0) {
            this.setSplitpoint(Double.parseDouble(curropt));
        } else {
            this.setSplitpoint(12.5);
        }
        WekaCommandLineHandler handler = new WekaCommandLineHandler();
        curropt = Utils.getOption((char)'F', (String[])options);
        if (!curropt.isEmpty()) {
            this.setHiClassifier((Classifier)handler.fromCommandLine(curropt));
        } else {
            this.setHiClassifier((Classifier)handler.fromCommandLine(this.defaultClassifierString() + " " + Utils.joinOptions((String[])this.defaultClassifierOptions())));
        }
        curropt = Utils.getOption((char)'G', (String[])options);
        if (!curropt.isEmpty()) {
            this.setLoClassifier((Classifier)handler.fromCommandLine(curropt));
        } else {
            this.setLoClassifier((Classifier)handler.fromCommandLine(this.defaultClassifierString() + " " + Utils.joinOptions((String[])this.defaultClassifierOptions())));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("-S");
        result.add("" + this.getHiLopoint());
        result.add("-P");
        result.add("" + this.getLoHipoint());
        result.add("-E");
        result.add("" + this.getSplitpoint());
        result.add("-F");
        result.add(Utils.toCommandLine((Object)this.getHiClassifier()));
        result.add("-G");
        result.add(Utils.toCommandLine((Object)this.getLoClassifier()));
        for (String option : super.getOptions()) {
            result.add(option);
        }
        return result.toArray(new String[result.size()]);
    }

    public double getHiLopoint() {
        return this.m_hiLopoint;
    }

    public void setHiLopoint(double h) {
        this.m_hiLopoint = h;
    }

    public String hiLopointTipText() {
        return "high-low point";
    }

    public double getLoHipoint() {
        return this.m_loHipoint;
    }

    public void setLoHipoint(double l) {
        this.m_loHipoint = l;
    }

    public String loHipointTipText() {
        return "low-high point";
    }

    public double getSplitpoint() {
        return this.m_splitpoint;
    }

    public void setSplitpoint(double s) {
        this.m_splitpoint = s;
    }

    public String splitpointTipText() {
        return "split point";
    }

    public Classifier getHiClassifier() {
        return this.m_hiClassifier;
    }

    public void setHiClassifier(Classifier c) {
        this.m_hiClassifier = c;
    }

    public String hiClassifierTipText() {
        return "hi classifier";
    }

    public Classifier getLoClassifier() {
        return this.m_loClassifier;
    }

    public void setLoClassifier(Classifier c) {
        this.m_loClassifier = c;
    }

    public String loClassifierTipText() {
        return "lo classifier";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.setMinimumNumberInstances(1);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
        Instances hi = new Instances(data, 0);
        Instances lo = new Instances(data, 0);
        for (Instance i : data) {
            DenseInstance in;
            if (i.classValue() <= this.m_loHipoint) {
                in = new DenseInstance(i);
                in.setDataset(lo);
                lo.add((Instance)in);
            }
            if (!(i.classValue() >= this.m_hiLopoint)) continue;
            in = new DenseInstance(i);
            in.setDataset(hi);
            hi.add((Instance)in);
        }
        this.m_hiClassifier.buildClassifier(hi);
        this.m_loClassifier.buildClassifier(lo);
    }

    public double classifyInstance(Instance inst) throws Exception {
        double value = this.m_Classifier.classifyInstance(inst);
        if (value < this.getSplitpoint()) {
            return this.m_loClassifier.classifyInstance(inst);
        }
        return this.m_hiClassifier.classifyInstance(inst);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("High-Low point: " + this.getHiLopoint() + "\n");
        result.append("Low-High point: " + this.getLoHipoint() + "\n");
        result.append("\nClassifier:\n" + this.m_Classifier + "\n");
        result.append("\nBelow " + this.m_splitpoint + ":\n" + this.m_loClassifier + "\n");
        result.append("\nElse:\n" + this.m_hiClassifier);
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 6936 $");
    }

    public static void main(String[] argv) {
        HighLowSplit.runClassifier((Classifier)new HighLowSplit(), (String[])argv);
    }
}

