/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.EnumHelper;
import adams.core.Utils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.WeightedInstancesHandler;

public class MinMaxLimits
extends SingleClassifierEnhancer
implements WeightedInstancesHandler,
AbstainingClassifier {
    private static final long serialVersionUID = 1233549562504476266L;
    public static final LimitHandling DEFAULT_MIN_HANDLING = LimitHandling.AS_IS;
    public static final double DEFAULT_MIN_MANUAL = 0.0;
    public static final double DEFAULT_MIN_CLASS_RANGE_PERCENTAGE = 0.0;
    public static final LimitHandling DEFAULT_MAX_HANDLING = LimitHandling.AS_IS;
    public static final double DEFAULT_MAX_MANUAL = 0.0;
    public static final double DEFAULT_MAX_CLASS_RANGE_PERCENTAGE = 0.0;
    protected LimitHandling m_MinHandling = DEFAULT_MIN_HANDLING;
    protected double m_MinManual = 0.0;
    protected double m_MinClassRangePercentage = 0.0;
    protected Double m_MinActual;
    protected LimitHandling m_MaxHandling = DEFAULT_MAX_HANDLING;
    protected double m_MaxManual = 0.0;
    protected double m_MaxClassRangePercentage = 0.0;
    protected Double m_MaxActual;
    protected boolean m_CanAbstain = false;

    public String globalInfo() {
        return "Allows to influence the handling of lower/upper limits of the built classifier when making predictions.\nThe following types of handling are available: " + Utils.flatten((Object[])EnumHelper.getValues(LimitHandling.class), (String)", ") + "\nDetails on the types:\n- " + LimitHandling.AS_IS + ": prediction does not get changed\n- " + LimitHandling.MANUAL + ": applies the manual limit, ie at most this limit is output\n- " + LimitHandling.CLASS_RANGE + ": applies the percentage leeway to the class attribute range of the training set to determine the actual limit value.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tHow the lower limit is handled.\n\t(default: " + DEFAULT_MIN_HANDLING + ")", "min-handling", 1, "-min-handling <" + Utils.flatten((Object[])EnumHelper.getValues(LimitHandling.class), (String)"|") + ">"));
        result.addElement(new Option("\tThe manual lower limit\n\t(default: 0.0)", "min-manual", 1, "-min-manual <num>"));
        result.addElement(new Option("\tThe class range percentage leeway for the lower limit\n\t0-1 = 0-100%\n\t(default: 0.0)", "min-class-percentage", 1, "-min-class-percentage <num>"));
        result.addElement(new Option("\tHow the upper limit is handled.\n\t(default: " + DEFAULT_MAX_HANDLING + ")", "max-handling", 1, "-max-handling <" + Utils.flatten((Object[])EnumHelper.getValues(LimitHandling.class), (String)"|") + ">"));
        result.addElement(new Option("\tThe manual upper limit\n\t(default: 0.0)", "max-manual", 1, "-max-manual <num>"));
        result.addElement(new Option("\tThe class range percentage leeway for the upper limit\n\t0-1 = 0-100%\n\t(default: 0.0)", "max-class-percentage", 1, "-max-class-percentage <num>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = weka.core.Utils.getOption((String)"min-handling", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMinHandling(LimitHandling.valueOf(tmpStr));
        } else {
            this.setMinHandling(DEFAULT_MIN_HANDLING);
        }
        tmpStr = weka.core.Utils.getOption((String)"min-manual", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMinManual(Double.parseDouble(tmpStr));
        } else {
            this.setMinManual(0.0);
        }
        tmpStr = weka.core.Utils.getOption((String)"min-class-percentage", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMinClassRangePercentage(Double.parseDouble(tmpStr));
        } else {
            this.setMinClassRangePercentage(0.0);
        }
        tmpStr = weka.core.Utils.getOption((String)"max-handling", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMaxHandling(LimitHandling.valueOf(tmpStr));
        } else {
            this.setMaxHandling(DEFAULT_MAX_HANDLING);
        }
        tmpStr = weka.core.Utils.getOption((String)"max-manual", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMaxManual(Double.parseDouble(tmpStr));
        } else {
            this.setMaxManual(0.0);
        }
        tmpStr = weka.core.Utils.getOption((String)"max-class-percentage", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMaxClassRangePercentage(Double.parseDouble(tmpStr));
        } else {
            this.setMaxClassRangePercentage(0.0);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<Object> result = new Vector<Object>();
        result.add("-min-handling");
        result.add("" + this.getMinHandling());
        if (this.getMinHandling() == LimitHandling.MANUAL) {
            result.add("-min-manual");
            result.add("" + this.getMinManual());
        }
        if (this.getMinHandling() == LimitHandling.CLASS_RANGE) {
            result.add("-min-class-percentage");
            result.add("" + this.getMinClassRangePercentage());
        }
        result.add("-max-handling");
        result.add("" + this.getMaxHandling());
        if (this.getMaxHandling() == LimitHandling.MANUAL) {
            result.add("-max-manual");
            result.add("" + this.getMaxManual());
        }
        if (this.getMaxHandling() == LimitHandling.CLASS_RANGE) {
            result.add("-max-class-percentage");
            result.add("" + this.getMaxClassRangePercentage());
        }
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setMinHandling(LimitHandling value) {
        this.m_MinHandling = value;
    }

    public LimitHandling getMinHandling() {
        return this.m_MinHandling;
    }

    public String minHandlingTipText() {
        return "Determines how the lower limit is handled.";
    }

    public void setMinManual(double value) {
        this.m_MinManual = value;
    }

    public double getMinManual() {
        return this.m_MinManual;
    }

    public String minManualTipText() {
        return "In case of " + LimitHandling.MANUAL + ", defines the lower limit.";
    }

    public void setMinClassRangePercentage(double value) {
        this.m_MinClassRangePercentage = value;
    }

    public double getMinClassRangePercentage() {
        return this.m_MinClassRangePercentage;
    }

    public String minClassRangePercentageTipText() {
        return "In case of " + LimitHandling.CLASS_RANGE + ", defines the leeway to apply to the lower limit determine by the class attribute in the training data (0-1 = 0-100%).";
    }

    public void setMaxHandling(LimitHandling value) {
        this.m_MaxHandling = value;
    }

    public LimitHandling getMaxHandling() {
        return this.m_MaxHandling;
    }

    public String maxHandlingTipText() {
        return "Determaxes how the upper limit is handled.";
    }

    public void setMaxManual(double value) {
        this.m_MaxManual = value;
    }

    public double getMaxManual() {
        return this.m_MaxManual;
    }

    public String maxManualTipText() {
        return "In case of " + LimitHandling.MANUAL + ", defines the upper limit.";
    }

    public void setMaxClassRangePercentage(double value) {
        this.m_MaxClassRangePercentage = value;
    }

    public double getMaxClassRangePercentage() {
        return this.m_MaxClassRangePercentage;
    }

    public String maxClassRangePercentageTipText() {
        return "In case of " + LimitHandling.CLASS_RANGE + ", defines the leeway to apply to the upper limit determaxe by the class attribute in the training data (0-1 = 0-100%).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        AttributeStats stats = data.attributeStats(data.classIndex());
        double min = stats.numericStats.min;
        double max = stats.numericStats.max;
        double range = max - min;
        if (this.getDebug()) {
            System.out.println("Min: " + min);
            System.out.println("Max: " + max);
            System.out.println("Range: " + range);
        }
        switch (this.m_MinHandling) {
            case AS_IS: {
                this.m_MinActual = null;
                break;
            }
            case MANUAL: {
                this.m_MinActual = this.m_MinManual;
                break;
            }
            case CLASS_RANGE: {
                this.m_MinActual = min - range * this.m_MinClassRangePercentage;
            }
        }
        if (this.getDebug()) {
            System.out.println("Actual lower limit: " + (String)(this.m_MinActual == null ? "-none-" : "" + this.m_MinActual));
        }
        switch (this.m_MaxHandling) {
            case AS_IS: {
                this.m_MaxActual = null;
                break;
            }
            case MANUAL: {
                this.m_MaxActual = this.m_MaxManual;
                break;
            }
            case CLASS_RANGE: {
                this.m_MaxActual = max + range * this.m_MaxClassRangePercentage;
            }
        }
        if (this.getDebug()) {
            System.out.println("Actual upper limit: " + (String)(this.m_MaxActual == null ? "-none-" : "" + this.m_MaxActual));
        }
        this.m_Classifier.buildClassifier(data);
        this.m_CanAbstain = this.m_Classifier instanceof AbstainingClassifier && ((AbstainingClassifier)this.m_Classifier).canAbstain();
    }

    public double classifyInstance(Instance inst) throws Exception {
        double result = this.m_Classifier.classifyInstance(inst);
        if (this.m_MinActual != null && result < this.m_MinActual) {
            if (this.getDebug()) {
                System.out.println(result + " < " + this.m_MinActual + " -> " + this.m_MinActual);
            }
            result = this.m_MinActual;
        }
        if (this.m_MaxActual != null && result > this.m_MaxActual) {
            if (this.getDebug()) {
                System.out.println(result + " > " + this.m_MaxActual + " -> " + this.m_MaxActual);
            }
            result = this.m_MaxActual;
        }
        return result;
    }

    @Override
    public boolean canAbstain() {
        return this.m_CanAbstain;
    }

    @Override
    public double getAbstentionClassification(Instance inst) throws Exception {
        if (this.m_CanAbstain) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionClassification(inst);
        }
        return weka.core.Utils.missingValue();
    }

    @Override
    public double[] getAbstentionDistribution(Instance inst) throws Exception {
        if (this.m_CanAbstain) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(inst);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MinMax\n");
        result.append("======\n\n");
        result.append("Lower limit:\n");
        result.append("- handling: " + this.m_MinHandling + "\n");
        result.append("- actual limit: " + (Serializable)(this.m_MinActual == null ? "N/A" : this.m_MinActual) + "\n");
        result.append("Upper limit\n");
        result.append("- handling: " + this.m_MaxHandling + "\n");
        result.append("- actual limit: " + (Serializable)(this.m_MaxActual == null ? "N/A" : this.m_MaxActual) + "\n");
        result.append("\n\n");
        result.append(this.m_Classifier.toString());
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        MinMaxLimits.runClassifier((Classifier)new MinMaxLimits(), (String[])args);
    }

    public static enum LimitHandling {
        AS_IS,
        MANUAL,
        CLASS_RANGE;

    }
}

