/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.data.weka.WekaLabelIndex;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ModelOutputHandler;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class ThresholdedBinaryClassification
extends SingleClassifierEnhancer
implements ModelOutputHandler {
    private static final long serialVersionUID = -4208248826900762835L;
    public static final String LABEL = "label";
    public static final String MIN_PROBABILITY = "min-probability";
    public static final String SUPPRESS_MODEL_OUTPUT = "suppress-model-output";
    protected WekaLabelIndex m_Label = new WekaLabelIndex("first");
    protected int m_ActualLabel;
    protected int m_OtherLabel;
    protected double m_MinProbability = this.getDefaultMinProbability();
    protected boolean m_SuppressModelOutput = false;

    public String globalInfo() {
        return "Meta classifier for binary classification problems that allows to specify a minimum probability threshold for one of the labels. If this label achieves at least this probability then this label gets chosen, otherwise the other one.";
    }

    protected WekaLabelIndex getDefaultLabel() {
        return new WekaLabelIndex("first");
    }

    public void setLabel(WekaLabelIndex value) {
        this.m_Label = value;
    }

    public WekaLabelIndex getLabel() {
        return this.m_Label;
    }

    public String labelTipText() {
        return "The index of the label to check.";
    }

    protected double getDefaultMinProbability() {
        return 0.5;
    }

    public void setMinProbability(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_MinProbability = value;
        } else {
            System.err.println("Minimum probability must satisfy 0 <= x <= 1.0, provided: " + value);
        }
    }

    public double getMinProbability() {
        return this.m_MinProbability;
    }

    public String minProbabilityTipText() {
        return "The minimum probability for the label (0-1).";
    }

    @Override
    public void setSuppressModelOutput(boolean value) {
        this.m_SuppressModelOutput = value;
    }

    @Override
    public boolean getSuppressModelOutput() {
        return this.m_SuppressModelOutput;
    }

    @Override
    public String suppressModelOutputTipText() {
        return "If enabled, suppresses any large model output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.labelTipText(), this.getDefaultLabel().getIndex(), LABEL);
        WekaOptionUtils.addOption(result, this.minProbabilityTipText(), "" + this.getDefaultMinProbability(), MIN_PROBABILITY);
        WekaOptionUtils.addFlag(result, this.suppressModelOutputTipText(), SUPPRESS_MODEL_OUTPUT);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setLabel(new WekaLabelIndex(WekaOptionUtils.parse(options, LABEL, this.getDefaultLabel().getIndex())));
        this.setMinProbability(WekaOptionUtils.parse(options, MIN_PROBABILITY, this.getDefaultMinProbability()));
        this.setSuppressModelOutput(Utils.getFlag((String)SUPPRESS_MODEL_OUTPUT, (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, LABEL, this.getLabel().getIndex());
        WekaOptionUtils.add(result, MIN_PROBABILITY, this.getMinProbability());
        WekaOptionUtils.add(result, SUPPRESS_MODEL_OUTPUT, this.getSuppressModelOutput());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.disable(Capabilities.Capability.UNARY_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
        this.m_Label.setData(data.classAttribute());
        this.m_ActualLabel = this.m_Label.getIntIndex();
        this.m_OtherLabel = this.m_ActualLabel == 0 ? 1 : 0;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = this.m_Classifier.distributionForInstance(instance);
        if (result[this.m_ActualLabel] >= this.m_MinProbability) {
            result = new double[2];
            result[this.m_ActualLabel] = 1.0;
        } else {
            result = new double[2];
            result[this.m_OtherLabel] = 1.0;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=") + "\n\n");
        result.append("Label: " + this.m_Label.getIndex() + "\n");
        result.append("Actual label index: " + this.m_ActualLabel + "\n");
        result.append("Min probability: " + this.m_MinProbability + "\n");
        result.append("\n");
        if (this.m_SuppressModelOutput) {
            result.append("Model suppressed");
        } else {
            result.append(this.m_Classifier.toString());
        }
        return result.toString();
    }
}

