/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.FileUtils;
import adams.data.DateFormatString;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.env.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.converters.AbstractFileLoader;

public class SimpleArffLoader
extends AbstractFileLoader
implements WeightedInstancesHandler,
OptionHandler,
EncodingSupporter {
    private static final long serialVersionUID = 8692708185900983930L;
    public static final String KEYWORD_RELATION = "@relation";
    public static final String KEYWORD_ATTRIBUTE = "@attribute";
    public static final String KEYWORD_DATA = "@data";
    protected Instances m_Data;
    protected boolean m_ForceCompression;
    protected BaseCharset m_Encoding = new BaseCharset();

    public SimpleArffLoader() {
        this.m_useRelativePath = false;
    }

    public String globalInfo() {
        return "Simple ARFF loading functionality of ADAMS. No incremental loading possible. Does not support relational attributes.";
    }

    public void setForceCompression(boolean value) {
        this.m_ForceCompression = value;
    }

    public boolean getForceCompression() {
        return this.m_ForceCompression;
    }

    public String forceCompressionTipText() {
        return "If enabled, the file gets interpreted as gzip-compressed ARFF file.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when reading the file, use empty string for default.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tTreat file as gzip-compressed.", "force-compression", 0, "-force-compression"));
        result.add(new Option("\tCharacter set to use for reading the file.", "encoding", 1, "-encoding <charset>"));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getForceCompression()) {
            result.add("-force-compression");
        }
        result.add("-encoding");
        result.add(this.getEncoding().stringValue());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        this.setForceCompression(Utils.getFlag((String)"force-compression", (String[])options));
        String tmpStr = Utils.getOption((String)"encoding", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setEncoding(new BaseCharset());
        } else {
            if (!new BaseCharset().isValid(tmpStr)) {
                throw new IllegalArgumentException("Invalid file encoding: " + tmpStr);
            }
            this.setEncoding(new BaseCharset(tmpStr));
        }
    }

    public String getFileExtension() {
        return this.getFileExtensions()[0];
    }

    public String[] getFileExtensions() {
        return new String[]{".arff", ".arff.gz"};
    }

    public String getFileDescription() {
        return "Simple ARFF data files";
    }

    public void reset() throws IOException {
        super.reset();
        this.m_Data = null;
    }

    public void setFile(File file) throws IOException {
        this.m_sourceFile = file;
        this.reset();
    }

    public void setSource(File file) throws IOException {
        this.setFile(file);
    }

    public File retrieveFile() {
        return this.m_sourceFile;
    }

    public void setUseRelativePath(boolean rp) {
        this.m_useRelativePath = false;
    }

    protected String removeAttributeType(String current) {
        return current.substring(current.indexOf(" ") + 1).trim();
    }

    protected int indexOfUnescaped(String s, char chr, int start) {
        int result = -1;
        char curr = '\u0000';
        for (int i = start; i < s.length(); ++i) {
            char last = curr;
            curr = s.charAt(i);
            if (curr != chr || last == '\\') continue;
            result = i;
            break;
        }
        return result;
    }

    protected String unquoteAttribute(String name) {
        if (name.startsWith("'") && name.endsWith("'")) {
            if ((name = adams.core.Utils.unquote((String)name)).startsWith("'") && name.endsWith("'")) {
                name = adams.core.Utils.unquote((String)name);
            }
        } else if (name.startsWith("\"") && name.endsWith("\"") && (name = adams.core.Utils.unDoubleQuote((String)name)).startsWith("\"") && name.endsWith("\"")) {
            name = adams.core.Utils.unDoubleQuote((String)name);
        }
        return name;
    }

    protected Map<String, String> parseAttribute(String line) {
        String lower;
        boolean quoted;
        HashMap<String, String> result = new HashMap<String, String>();
        String current = line.replace("\t", " ");
        if ((current = current.substring(KEYWORD_ATTRIBUTE.length() + 1).trim()).startsWith("'")) {
            quoted = true;
            result.put("name", current.substring(0, this.indexOfUnescaped(current, '\'', 1) + 1).trim());
        } else if (current.startsWith("\"")) {
            quoted = true;
            result.put("name", current.substring(0, this.indexOfUnescaped(current, '\"', 1) + 1).trim());
        } else {
            quoted = false;
            result.put("name", current.substring(0, current.indexOf(32, 1)).trim());
        }
        current = current.substring(((String)result.get("name")).length()).trim();
        if (quoted) {
            result.put("name", this.unquoteAttribute((String)result.get("name")));
        }
        if ((lower = current.toLowerCase()).startsWith("numeric") || lower.startsWith("real") || lower.startsWith("integer")) {
            result.put("type", "0");
        } else if (lower.startsWith("string")) {
            result.put("type", "2");
        } else if (lower.startsWith("date")) {
            result.put("type", "3");
        } else if (lower.startsWith("{")) {
            result.put("type", "1");
        } else {
            throw new IllegalStateException("Unsupported attribute: " + current);
        }
        if (((String)result.get("type")).equals("0")) {
            current = this.removeAttributeType(current);
        }
        if (((String)result.get("type")).equals("2")) {
            current = this.removeAttributeType(current);
        }
        if (((String)result.get("type")).equals("3")) {
            String format = current = this.removeAttributeType(current);
            if (format.endsWith("}")) {
                format = format.substring(0, format.indexOf(123)).trim();
            }
            if (format.startsWith("'")) {
                format = adams.core.Utils.unquote((String)format);
            } else if (format.startsWith("\"")) {
                format = adams.core.Utils.unDoubleQuote((String)format);
            }
            if (!new DateFormatString().isValid(format)) {
                throw new IllegalStateException("Invalid date format: " + format);
            }
            result.put("format", format);
            if (current.endsWith("}")) {
                current = current.substring(current.indexOf(123)).trim();
            }
        }
        if (((String)result.get("type")).equals("1")) {
            String values = current;
            values = values.substring(values.indexOf(123) + 1);
            values = values.substring(0, values.indexOf(125));
            result.put("values", values.trim());
            current = current.substring(current.indexOf(125) + 1);
        }
        if (current.matches("[ ]*\\{-?\\d*\\.?\\d*\\}$")) {
            result.put("weight", current.substring(current.indexOf(123) + 1, current.lastIndexOf(125)));
        }
        return result;
    }

    protected Attribute createAttribute(String line) {
        Attribute result = null;
        Map<String, String> data = this.parseAttribute(line);
        int type = Integer.parseInt(data.get("type"));
        switch (type) {
            case 0: {
                result = new Attribute(data.get("name"));
                break;
            }
            case 3: {
                if (!data.containsKey("format")) {
                    throw new IllegalStateException("No format specified for date attribute: " + line);
                }
                result = new Attribute(data.get("name"), data.get("format"));
                break;
            }
            case 1: {
                if (!data.containsKey("values")) {
                    throw new IllegalStateException("No values listed for nominal attribute: " + line);
                }
                String[] values = SpreadSheetUtils.split((String)data.get("values"), (char)',', (boolean)false, (char)'\'', (boolean)true);
                for (int i = 0; i < values.length; ++i) {
                    values[i] = adams.core.Utils.unquote((String)values[i].trim());
                }
                result = new Attribute(data.get("name"), new ArrayList<String>(Arrays.asList(values)));
                break;
            }
            case 2: {
                result = new Attribute(data.get("name"), (List)null);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported attribute type " + Attribute.typeToString((int)type) + ": " + line);
            }
        }
        if (data.containsKey("weight")) {
            if (adams.core.Utils.isDouble((String)data.get("weight"))) {
                result.setWeight(adams.core.Utils.toDouble((String)data.get("weight")).doubleValue());
            } else {
                throw new IllegalStateException("Invalid weight for attribute " + result.name() + ": " + data.get("weight"));
            }
        }
        return result;
    }

    protected Instance parseSparse(Instances header, String line) throws Exception {
        double weight = 1.0;
        if (line.matches(".*}[ ]*\\{-?\\d*\\.?\\d*\\}$")) {
            String weightStr = line.substring(line.lastIndexOf(123) + 1, line.length() - 1);
            line = line.substring(0, line.lastIndexOf(123));
            try {
                weight = Double.parseDouble(weightStr);
            }
            catch (Exception e) {
                System.err.println("Failed to parse weight string: " + line);
            }
        }
        line = line.substring(1, line.length() - 1);
        String[] cells = SpreadSheetUtils.split((String)line, (char)',', (boolean)false, (char)'\'', (boolean)true);
        double[] values = new double[cells.length];
        int[] indices = new int[cells.length];
        Arrays.fill(values, 0.0);
        block8: for (int i = 0; i < cells.length; ++i) {
            indices[i] = Integer.parseInt(cells[i].substring(0, cells[i].indexOf(32)));
            String value = cells[i].substring(cells[i].indexOf(32) + 1);
            switch (header.attribute(indices[i]).type()) {
                case 0: {
                    values[i] = Double.parseDouble(value);
                    continue block8;
                }
                case 1: {
                    values[i] = header.attribute(indices[i]).indexOfValue(value);
                    continue block8;
                }
                case 2: {
                    values[i] = header.attribute(indices[i]).addStringValue(value);
                    continue block8;
                }
                case 3: {
                    values[i] = header.attribute(indices[i]).parseDate(value);
                }
            }
        }
        return new SparseInstance(weight, values, indices, header.numAttributes());
    }

    protected Instance parseDense(Instances header, String line) throws Exception {
        double weight = 1.0;
        if (line.endsWith("}") && line.matches(".*,[ ]*\\{-?\\d*\\.?\\d*\\}$")) {
            String weightStr = line.substring(line.lastIndexOf(123) + 1, line.length() - 1);
            line = line.substring(0, line.lastIndexOf(123) - 1);
            try {
                weight = Double.parseDouble(weightStr);
            }
            catch (Exception e) {
                System.err.println("Failed to parse weight string: " + line);
            }
        }
        String[] cells = SpreadSheetUtils.split((String)line, (char)',', (boolean)false, (char)'\'', (boolean)true);
        double[] values = new double[header.numAttributes()];
        block8: for (int i = 0; i < cells.length && i < values.length; ++i) {
            values[i] = Utils.missingValue();
            cells[i] = cells[i].trim();
            if (cells[i].equals("?")) continue;
            cells[i] = adams.core.Utils.unquote((String)cells[i]);
            switch (header.attribute(i).type()) {
                case 0: {
                    values[i] = Double.parseDouble(cells[i]);
                    continue block8;
                }
                case 1: {
                    values[i] = header.attribute(i).indexOfValue(cells[i]);
                    continue block8;
                }
                case 2: {
                    values[i] = header.attribute(i).addStringValue(cells[i]);
                    continue block8;
                }
                case 3: {
                    values[i] = header.attribute(i).parseDate(cells[i]);
                }
            }
        }
        return new DenseInstance(weight, values);
    }

    protected Instances read(BufferedReader reader) {
        Instances result = null;
        int lineIndex = 0;
        boolean header = true;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        String relName = this.m_sourceFile.getName();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Instance inst;
                ++lineIndex;
                if ((line = line.trim()).isEmpty() || line.startsWith("%")) continue;
                if (header) {
                    String lower = line.toLowerCase();
                    if (lower.startsWith(KEYWORD_RELATION)) {
                        relName = line.substring(KEYWORD_RELATION.length()).trim();
                        relName = adams.core.Utils.unquote((String)relName);
                        continue;
                    }
                    if (lower.startsWith(KEYWORD_ATTRIBUTE)) {
                        Attribute att = this.createAttribute(line);
                        atts.add(att);
                        continue;
                    }
                    if (!lower.startsWith(KEYWORD_DATA)) continue;
                    header = false;
                    result = new Instances(relName, atts, 0);
                    continue;
                }
                if (line.startsWith("{")) {
                    inst = this.parseSparse(result, line);
                    result.add(inst);
                    continue;
                }
                inst = this.parseDense(result, line);
                result.add(inst);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read ARFF data from reader (line #" + (lineIndex + 1) + ")!");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public Instances getStructure() throws IOException {
        if (this.m_Data == null) {
            return new Instances(this.getDataSet(), 0);
        }
        return new Instances(this.m_Data, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instances getDataSet() throws IOException {
        Instances result;
        if (this.m_Data != null) {
            return this.m_Data;
        }
        if (!this.m_sourceFile.exists()) {
            throw new IOException("File does not exist: " + this.m_sourceFile);
        }
        if (this.m_sourceFile.isDirectory()) {
            throw new IOException("File points to directory: " + this.m_sourceFile);
        }
        BufferedReader breader = null;
        InputStreamReader isr = null;
        GZIPInputStream gis = null;
        FileInputStream fis = null;
        Charset charset = this.m_Encoding.charsetValue();
        try {
            if (this.m_sourceFile.getName().endsWith(".gz") || this.m_ForceCompression) {
                fis = new FileInputStream(this.m_sourceFile.getAbsolutePath());
                gis = new GZIPInputStream(fis);
                isr = new InputStreamReader((InputStream)gis, charset.newDecoder());
                breader = new BufferedReader(isr);
            } else {
                fis = new FileInputStream(this.m_sourceFile.getAbsolutePath());
                isr = new InputStreamReader((InputStream)fis, charset.newDecoder());
                breader = new BufferedReader(isr);
            }
            result = this.read(breader);
        }
        catch (Exception e) {
            try {
                System.err.println("Failed to read: " + this.m_sourceFile);
                e.printStackTrace();
                result = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly(isr);
                FileUtils.closeQuietly(gis);
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly(breader);
            FileUtils.closeQuietly(isr);
            FileUtils.closeQuietly((InputStream)gis);
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)isr);
        FileUtils.closeQuietly((InputStream)gis);
        FileUtils.closeQuietly((InputStream)fis);
        return result;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("Incremental mode not supported!");
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 11506 $");
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SimpleArffLoader.runFileLoader((AbstractFileLoader)new SimpleArffLoader(), (String[])args);
    }
}

