/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;

public class SimpleArffSaver
extends AbstractFileSaver
implements BatchConverter,
WeightedInstancesHandler,
EncodingSupporter {
    private static final long serialVersionUID = -6155802217430401683L;
    public static final int DEFAULT_MAX_DECIMAL_PLACES = 6;
    protected File m_OutputFile;
    protected int m_MaxDecimalPlaces = 6;
    protected BaseCharset m_Encoding = new BaseCharset();

    public SimpleArffSaver() {
        this.setFileExtension(".arff");
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes the Instances to an ARFF file in batch mode.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tThe maximum number of digits to print after the decimal\n\tplace for numeric values (default: 6)", "decimal", 1, "-decimal <num>"));
        result.add(new Option("\tCharacter set to use for writing the file.", "encoding", 1, "-encoding <charset>"));
        return result.elements();
    }

    public void resetOptions() {
        super.resetOptions();
        this.m_OutputFile = null;
    }

    public String[] getOptions() {
        Vector<Object> result = new Vector<Object>();
        result.add("-decimal");
        result.add("" + this.getMaxDecimalPlaces());
        result.add("-encoding");
        result.add(this.getEncoding().stringValue());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"decimal", (String[])options);
        if (tmpStr.length() > 0) {
            this.setMaxDecimalPlaces(Integer.parseInt(tmpStr));
        } else {
            this.setMaxDecimalPlaces(6);
        }
        tmpStr = Utils.getOption((String)"encoding", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setEncoding(new BaseCharset());
        } else {
            if (!new BaseCharset().isValid(tmpStr)) {
                throw new IllegalArgumentException("Invalid file encoding: " + tmpStr);
            }
            this.setEncoding(new BaseCharset(tmpStr));
        }
        super.setOptions(options);
    }

    public void setMaxDecimalPlaces(int value) {
        this.m_MaxDecimalPlaces = value;
    }

    public int getMaxDecimalPlaces() {
        return this.m_MaxDecimalPlaces;
    }

    public String maxDecimalPlacesTipText() {
        return "The maximum number of digits to print after the decimal point for numeric values";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when reading the file, use empty string for default.";
    }

    public String getFileDescription() {
        return "Simple ARFF data files";
    }

    public String[] getFileExtensions() {
        return new String[]{".arff", ".arff.gz"};
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void setDestination(File file) throws IOException {
        this.m_OutputFile = file;
    }

    public void setDestination(OutputStream output) throws IOException {
        throw new IOException("Writing to an outputstream not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBatch() throws IOException {
        block12: {
            if (this.getInstances() == null) {
                throw new IOException("No instances to save!");
            }
            if (this.m_OutputFile == null) {
                throw new IOException("No output file set!");
            }
            if (this.getRetrieval() == 2) {
                throw new IOException("Batch and incremental saving cannot be mixed.");
            }
            this.setRetrieval(1);
            this.setWriteMode(0);
            FileOutputStream fos = null;
            GZIPOutputStream gos = null;
            OutputStreamWriter ow = null;
            BufferedWriter bw = null;
            Instances data = this.getInstances();
            Charset charset = this.m_Encoding.charsetValue();
            try {
                int i;
                fos = new FileOutputStream(this.m_OutputFile.getAbsoluteFile());
                if (this.m_OutputFile.getName().endsWith(".gz")) {
                    gos = new GZIPOutputStream(fos);
                    ow = new OutputStreamWriter((OutputStream)gos, charset.newEncoder());
                    bw = new BufferedWriter(ow);
                } else {
                    ow = new OutputStreamWriter((OutputStream)fos, charset.newEncoder());
                    bw = new BufferedWriter(ow);
                }
                bw.write("@relation");
                bw.write(" ");
                bw.write(Utils.quote((String)data.relationName()));
                bw.write("\n\n");
                for (i = 0; i < data.numAttributes(); ++i) {
                    bw.write(data.attribute(i).toString());
                    bw.write("\n");
                }
                bw.write("\n");
                bw.write("@data");
                bw.write("\n");
                for (i = 0; i < data.numInstances(); ++i) {
                    bw.write(data.instance(i).toStringMaxDecimalDigits(this.m_MaxDecimalPlaces));
                    bw.write("\n");
                }
                FileUtils.closeQuietly((Writer)bw);
            }
            catch (Exception e) {
                System.err.println("Failed to write data to: " + this.m_OutputFile);
                e.printStackTrace();
                break block12;
            }
            finally {
                FileUtils.closeQuietly(bw);
                FileUtils.closeQuietly(ow);
                FileUtils.closeQuietly(gos);
                FileUtils.closeQuietly((OutputStream)fos);
            }
            FileUtils.closeQuietly((Writer)ow);
            FileUtils.closeQuietly((OutputStream)gos);
            FileUtils.closeQuietly((OutputStream)fos);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) throws Exception {
        SimpleArffSaver.runFileSaver((AbstractFileSaver)new SimpleArffSaver(), (String[])args);
    }
}

