/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.weka.WekaAttributeRange;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;

public class AnyToString
extends SimpleStreamFilter {
    private static final long serialVersionUID = -183001278236751069L;
    protected WekaAttributeRange m_Range = new WekaAttributeRange("first");
    protected TIntSet m_Indices;

    public String globalInfo() {
        return "Turns the selected range of attributes into string ones.\nFor numeric attributes, it just uses the Java functionality to turn a number into a string.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe attribute range to process.\n\t(default: first)", "R", 1, "-R <range specification>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setRange(new WekaAttributeRange(tmpStr));
        } else {
            this.setRange(new WekaAttributeRange("last"));
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-R");
        result.add(this.getRange().getRange());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setRange(WekaAttributeRange value) {
        this.m_Range = value;
        this.reset();
    }

    public WekaAttributeRange getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The range of attributes to process";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected void reset() {
        super.reset();
        this.m_Indices = null;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_Range.setData(inputFormat);
        this.m_Indices = new TIntHashSet(this.m_Range.getIntIndices());
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            Attribute att = inputFormat.attribute(i);
            if (this.m_Indices.contains(i)) {
                atts.add(new Attribute(att.name(), (List)null));
                continue;
            }
            atts.add((Attribute)att.copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        Object value;
        double[] values = instance.toDoubleArray();
        for (int index : this.m_Indices.toArray()) {
            switch (instance.attribute(index).type()) {
                case 0: {
                    value = "" + values[index];
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    value = instance.stringValue(index);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((Attribute)instance.attribute(index)));
                }
            }
            values[index] = this.outputFormatPeek().attribute(index).addStringValue((String)value);
        }
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (this.m_Indices.contains(i) || !instance.attribute(i).isString()) continue;
            value = instance.stringValue(i);
            values[i] = this.outputFormatPeek().attribute(i).addStringValue((String)value);
        }
        Instance result = instance.copy(values);
        result.setDataset(this.outputFormatPeek());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        AnyToString.runFilter((Filter)new AnyToString(), (String[])args);
    }
}

