/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.base.BaseObject;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.weka.columnfinder.ByName;
import adams.data.weka.columnfinder.ColumnFinder;
import adams.data.weka.columnfinder.NullFinder;
import adams.data.weka.datasetsplitter.ColumnSplitter;
import adams.data.weka.datasetsplitter.RowSplitter;
import adams.data.weka.rowfinder.RowFinder;
import adams.flow.transformer.wekadatasetsmerge.Simple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PrincipalComponentsJ;

public class AttributeSummaryTransferFilter
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 741929497853488506L;
    protected RowFinder m_RowFinder = this.getDefaultRowFinder();
    protected ColumnFinder m_ColumnFinder = this.getDefaultColumnFinder();
    protected Filter m_SummaryFilter = this.getDefaultSummaryFilter();
    protected boolean m_PreserveIDColumn;
    protected BaseString m_ClassName = this.getDefaultClassName();
    protected boolean m_KeepSupervisedClass;
    protected Simple m_Merger;
    protected RowSplitter m_RowSplitter;
    protected ColumnSplitter m_ColumnSplitter;
    protected ColumnSplitter m_IDSplitter;
    protected ColumnSplitter m_SupervisedClassSplitter;

    public String globalInfo() {
        return "Filter which trains another filter to summarise a sub-set of the data's attributes. The trained filter should be a supervised or unsupervised attribute filter. Trains the summary filter on a large set of unannotated data so it can be applied to a relatively small set which is annotated with other information.";
    }

    public Enumeration<Option> listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.rowFinderTipText(), OptionUtils.getCommandLine((Object)this.getDefaultRowFinder()), "row-finder");
        WekaOptionUtils.addOption(result, this.columnFinderTipText(), OptionUtils.getCommandLine((Object)this.getDefaultColumnFinder()), "column-finder");
        WekaOptionUtils.addOption(result, this.summaryFilterTipText(), OptionUtils.getCommandLine((Object)this.getDefaultSummaryFilter()), "summary-filter");
        WekaOptionUtils.addOption(result, this.preserveIDColumnTipText(), "off", "preserve-id-column");
        WekaOptionUtils.addOption(result, this.classNameTipText(), this.getDefaultClassName().getValue(), "class-name");
        WekaOptionUtils.addOption(result, this.keepSupervisedClassTipText(), "off", "keep-supervised-class");
        WekaOptionUtils.add(result, super.listOptions());
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, "row-finder", (OptionHandler)this.getRowFinder());
        WekaOptionUtils.add(result, "column-finder", (OptionHandler)this.getColumnFinder());
        WekaOptionUtils.add(result, "summary-filter", (weka.core.OptionHandler)this.getSummaryFilter());
        WekaOptionUtils.add(result, "preserve-id-column", this.getPreserveIDColumn());
        WekaOptionUtils.add(result, "class-name", (BaseObject)this.getClassName());
        WekaOptionUtils.add(result, "keep-supervised-class", this.getKeepSupervisedClass());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[0]);
    }

    public void setOptions(String[] options) throws Exception {
        this.setRowFinder((RowFinder)WekaOptionUtils.parse(options, "row-finder", (OptionHandler)this.getDefaultRowFinder()));
        this.setColumnFinder((ColumnFinder)WekaOptionUtils.parse(options, "column-finder", (OptionHandler)this.getDefaultColumnFinder()));
        this.setSummaryFilter((Filter)WekaOptionUtils.parse(options, "summary-filter", (weka.core.OptionHandler)this.getDefaultSummaryFilter()));
        this.setPreserveIDColumn(Utils.getFlag((String)"preserve-id-column", (String[])options));
        this.setClassName((BaseString)WekaOptionUtils.parse(options, "class-name", (BaseObject)this.getDefaultClassName()));
        this.setKeepSupervisedClass(Utils.getFlag((String)"keep-supervised-class", (String[])options));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public RowFinder getDefaultRowFinder() {
        return new adams.data.weka.rowfinder.NullFinder();
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public String rowFinderTipText() {
        return "Row finder which selects rows for training the attribute-summarising filter.";
    }

    public ColumnFinder getDefaultColumnFinder() {
        return new NullFinder();
    }

    public void setColumnFinder(ColumnFinder value) {
        this.m_ColumnFinder = value;
    }

    public ColumnFinder getColumnFinder() {
        return this.m_ColumnFinder;
    }

    public String columnFinderTipText() {
        return "Column finder which selects attributes to summarise.";
    }

    public Filter getDefaultSummaryFilter() {
        PrincipalComponentsJ filter = new PrincipalComponentsJ();
        filter.setSimpleAttributeNames(true);
        return filter;
    }

    public void setSummaryFilter(Filter value) {
        this.m_SummaryFilter = value;
    }

    public Filter getSummaryFilter() {
        return this.m_SummaryFilter;
    }

    public String summaryFilterTipText() {
        return "The filter to use to summarise the attributes.";
    }

    public void setPreserveIDColumn(boolean value) {
        this.m_PreserveIDColumn = value;
    }

    public boolean getPreserveIDColumn() {
        return this.m_PreserveIDColumn;
    }

    public String preserveIDColumnTipText() {
        return "Whether the first column of the test data should be treated as a sample ID and kept in the first position of the output.";
    }

    public BaseString getDefaultClassName() {
        return new BaseString("");
    }

    public void setClassName(BaseString value) {
        this.m_ClassName = value;
    }

    public BaseString getClassName() {
        return this.m_ClassName;
    }

    public String classNameTipText() {
        return "The name of the attribute to treat as the class for supervised filters.";
    }

    public void setKeepSupervisedClass(boolean value) {
        this.m_KeepSupervisedClass = value;
    }

    public boolean getKeepSupervisedClass() {
        return this.m_KeepSupervisedClass;
    }

    public String keepSupervisedClassTipText() {
        return "Whether the class value for supervised filters should be kept in the resultant dataset or discarded.";
    }

    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_RowSplitter = new RowSplitter();
        this.m_RowSplitter.setRowFinder(this.m_RowFinder);
        this.m_ColumnSplitter = new ColumnSplitter();
        this.m_ColumnSplitter.setColumnFinder(this.m_ColumnFinder);
        Instances[] rowSplit = this.m_RowSplitter.split(inputFormat);
        Instances[] columnSplit = this.m_ColumnSplitter.split(rowSplit[0]);
        Instances summaryInput = columnSplit[0];
        if (this.m_ClassName.length() != 0) {
            summaryInput.setClass(summaryInput.attribute(this.m_ClassName.getValue()));
            summaryInput.deleteWithMissingClass();
        }
        this.m_SummaryFilter.setInputFormat(summaryInput);
        Filter.useFilter((Instances)summaryInput, (Filter)this.m_SummaryFilter);
        Instances summaryOutputFormat = this.m_SummaryFilter.getOutputFormat();
        Instances restOutputFormat = new Instances(columnSplit[1], 0);
        this.m_Merger = new Simple();
        return this.formatOutput(summaryOutputFormat, restOutputFormat);
    }

    protected Instances process(Instances instances) throws Exception {
        Instances data = this.m_RowSplitter.split(instances)[1];
        Instances[] columnSplit = this.m_ColumnSplitter.split(data);
        Instances summarised = Filter.useFilter((Instances)columnSplit[0], (Filter)this.m_SummaryFilter);
        return this.formatOutput(summarised, columnSplit[1]);
    }

    protected Instances formatOutput(Instances filterOutput, Instances theRest) {
        if (!this.m_KeepSupervisedClass && this.m_ClassName.length() > 0) {
            if (this.m_SupervisedClassSplitter == null) {
                this.m_SupervisedClassSplitter = new ColumnSplitter();
                ByName classNameFinder = new ByName();
                classNameFinder.setRegExp(new BaseRegExp("^" + this.m_ClassName + "$"));
                this.m_SupervisedClassSplitter.setColumnFinder(classNameFinder);
            }
            filterOutput = this.m_SupervisedClassSplitter.split(filterOutput)[1];
        }
        if (!this.m_PreserveIDColumn) {
            return this.m_Merger.merge(new Instances[]{filterOutput, theRest});
        }
        if (this.m_IDSplitter == null) {
            this.m_IDSplitter = new ColumnSplitter();
            ByName idNameFinder = new ByName();
            idNameFinder.setRegExp(new BaseRegExp("^" + theRest.attribute(0).name() + "$"));
            this.m_IDSplitter.setColumnFinder(idNameFinder);
        }
        Instances[] idSplit = this.m_IDSplitter.split(theRest);
        return this.m_Merger.merge(new Instances[]{idSplit[0], filterOutput, idSplit[1]});
    }
}

