/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.detrend.AbstractDetrend;
import weka.filters.unsupervised.attribute.detrend.RangeBased;

public class Detrend
extends SimpleBatchFilter {
    private static final long serialVersionUID = -9044105839662849793L;
    public static final String ATT_REGEXP = "att-regexp";
    protected BaseRegExp m_AttRegExp = this.getDefaultAttRegExp();
    public static final String WAVENO_REGEXP = "waveno-regexp";
    protected BaseRegExp m_WaveNoRegExp = new BaseRegExp("amplitude-(.*)");
    public static final String CORRECTION = "correction";
    protected AbstractDetrend m_Correction = this.getDefaultCorrection();
    protected TIntList m_AttIndices = null;
    protected TIntSet m_AttIndicesSet = null;
    protected double[] m_WaveNo = null;

    public String globalInfo() {
        return "Performs Detrend, using the specified correction scheme.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.attRegExpTipText(), this.getDefaultAttRegExp().stringValue(), ATT_REGEXP);
        WekaOptionUtils.addOption(result, this.waveNoRegExpTipText(), this.getDefaultWaveNoRegExp().stringValue(), WAVENO_REGEXP);
        WekaOptionUtils.addOption(result, this.correctionTipText(), this.getDefaultCorrection().toCommandLine(), CORRECTION);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setAttRegExp((BaseRegExp)WekaOptionUtils.parse(options, ATT_REGEXP, (BaseObject)this.getDefaultAttRegExp()));
        this.setWaveNoRegExp((BaseRegExp)WekaOptionUtils.parse(options, WAVENO_REGEXP, (BaseObject)this.getDefaultWaveNoRegExp()));
        this.setCorrection((AbstractDetrend)WekaOptionUtils.parse(options, CORRECTION, (OptionHandler)this.getDefaultCorrection()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, ATT_REGEXP, (BaseObject)this.getAttRegExp());
        WekaOptionUtils.add(result, WAVENO_REGEXP, (BaseObject)this.getWaveNoRegExp());
        WekaOptionUtils.add(result, CORRECTION, (OptionHandler)this.getCorrection());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected BaseRegExp getDefaultAttRegExp() {
        return new BaseRegExp(".*");
    }

    public void setAttRegExp(BaseRegExp value) {
        this.m_AttRegExp = value;
        this.reset();
    }

    public BaseRegExp getAttRegExp() {
        return this.m_AttRegExp;
    }

    public String attRegExpTipText() {
        return "The regular expression used to identify the attributes to process.";
    }

    protected BaseRegExp getDefaultWaveNoRegExp() {
        return new BaseRegExp("amplitude-(.*)");
    }

    public void setWaveNoRegExp(BaseRegExp value) {
        this.m_WaveNoRegExp = value;
        this.reset();
    }

    public BaseRegExp getWaveNoRegExp() {
        return this.m_WaveNoRegExp;
    }

    public String waveNoRegExpTipText() {
        return "The regular expression used to for extracting the wave numbers from the attribute name (using the first group).";
    }

    protected AbstractDetrend getDefaultCorrection() {
        return new RangeBased();
    }

    public void setCorrection(AbstractDetrend value) {
        this.m_Correction = value;
        this.reset();
    }

    public AbstractDetrend getCorrection() {
        return this.m_Correction;
    }

    public String correctionTipText() {
        return "The correction scheme to apply.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected void reset() {
        super.reset();
        this.m_AttIndices = null;
        this.m_AttIndicesSet = null;
        this.m_WaveNo = null;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        this.m_AttIndices = new TIntArrayList();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (!this.m_AttRegExp.isMatch(inputFormat.attribute(i).name())) continue;
            this.m_AttIndices.add(i);
        }
        if (this.m_AttIndices.size() == 0) {
            throw new IllegalStateException("No attributes identified using regexp: " + this.m_AttRegExp.getValue());
        }
        if (this.getDebug()) {
            System.err.println(((Object)((Object)this)).getClass().getName() + ": Identified indices: " + Utils.arrayToString((Object)this.m_AttIndices.toArray()));
        }
        this.m_AttIndicesSet = new TIntHashSet((TIntCollection)this.m_AttIndices);
        this.m_WaveNo = new double[this.m_AttIndices.size()];
        for (i = 0; i < this.m_AttIndices.size(); ++i) {
            try {
                String waveNoStr = inputFormat.attribute(this.m_AttIndices.get(i)).name().replaceAll(this.m_WaveNoRegExp.getValue(), "$1");
                this.m_WaveNo[i] = Double.parseDouble(waveNoStr);
                continue;
            }
            catch (Exception e) {
                if (this.getDebug()) {
                    System.err.println("Failed to extract wave number from '" + inputFormat.attribute(this.m_AttIndices.get(i)).name() + "' using '" + this.m_WaveNoRegExp.getValue() + "':");
                    e.printStackTrace();
                }
                this.m_WaveNo[i] = i + 1;
            }
        }
        if (this.getDebug()) {
            System.err.println(((Object)((Object)this)).getClass().getName() + ": Extracted wave numbers: " + Utils.arrayToString((Object)this.m_WaveNo));
        }
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        if (instances.numInstances() == 0) {
            return instances;
        }
        Instances result = new Instances(instances, instances.numInstances());
        for (int n = 0; n < instances.numInstances(); ++n) {
            int i;
            Instance inst = instances.instance(n);
            double[] data = new double[this.m_AttIndices.size()];
            for (i = 0; i < this.m_AttIndices.size(); ++i) {
                data[i] = inst.value(this.m_AttIndices.get(i));
            }
            data = this.m_Correction.correct(this.m_WaveNo, data);
            double[] values = inst.toDoubleArray();
            for (i = 0; i < this.m_AttIndices.size(); ++i) {
                values[this.m_AttIndices.get((int)i)] = data[i];
            }
            Instance instNew = inst.copy(values);
            this.copyValues(instNew, true, inst.dataset(), this.getOutputFormat());
            result.add(instNew);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        Detrend.runFilter((Filter)new Detrend(), (String[])args);
    }
}

