/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import JSci.maths.Complex;
import JSci.maths.FourierMath;
import adams.data.padding.PaddingHelper;
import adams.data.padding.PaddingType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class FFT
extends SimpleStreamFilter
implements TechnicalInformationHandler,
UnsupervisedFilter {
    private static final long serialVersionUID = 2244583826137735498L;
    protected PaddingType m_PaddingType;
    protected boolean m_InverseTransform;
    protected boolean m_Real;

    public String globalInfo() {
        return "A filter that transforms the data with Fast Fourier Transform.\n\nPads with zeroes.\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mark Hale");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.TITLE, "JSci - A science API for Java");
        result.setValue(TechnicalInformation.Field.HTTP, "http://jsci.sourceforge.net/");
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tWhether to compute the inverse.\n\t(default: no)", "inverse", 0, "-inverse"));
        result.addElement(new Option("\tWhether to return imaginary or real part is returned.\n\t(default: imaginary)", "real", 0, "-real"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        this.setInverseTransform(Utils.getFlag((String)"inverse", (String[])options));
        this.setReal(Utils.getFlag((String)"real", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_InverseTransform) {
            result.add("-inverse");
        }
        if (this.m_Real) {
            result.add("-real");
        }
        return result.toArray(new String[0]);
    }

    public void setInverseTransform(boolean value) {
        this.m_InverseTransform = value;
        this.reset();
    }

    public boolean getInverseTransform() {
        return this.m_InverseTransform;
    }

    public String inverseTransformTipText() {
        return "If enabled, the inverse transform is computed.";
    }

    public void setReal(boolean value) {
        this.m_Real = value;
        this.reset();
    }

    public boolean getReal() {
        return this.m_Real;
    }

    public String realTipText() {
        return "If enabled, the real part instead of imaginary one is returned.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        boolean hasClass = inputFormat.classIndex() > -1;
        int count = inputFormat.numAttributes();
        if (hasClass) {
            --count;
        }
        count = PaddingHelper.nextPowerOf2((int)count);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < count; ++i) {
            atts.add(new Attribute((this.m_Real ? "real" : "img") + (i + 1)));
        }
        if (hasClass) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (hasClass) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        int i;
        boolean hasClass = instance.classIndex() > -1;
        int count = instance.numAttributes();
        if (hasClass) {
            --count;
        }
        double[] valuesOld = new double[count];
        int n = 0;
        for (i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            valuesOld[n] = instance.value(i);
            ++n;
        }
        valuesOld = PaddingHelper.padPow2((double[])valuesOld, (PaddingType)PaddingType.ZERO);
        Complex[] transformed = this.m_InverseTransform ? FourierMath.inverseTransform((double[])valuesOld) : FourierMath.transform((double[])valuesOld);
        double[] values = new double[valuesOld.length + (hasClass ? 1 : 0)];
        for (i = 0; i < transformed.length; ++i) {
            values[i] = this.m_Real ? transformed[i].real() : transformed[i].imag();
        }
        if (hasClass) {
            values[values.length - 1] = instance.classIsMissing() ? Utils.missingValue() : instance.classValue();
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(this.getOutputFormat());
        this.copyValues((Instance)result, false, instance.dataset(), this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        FFT.runFilter((Filter)new FFT(), (String[])args);
    }
}

