/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.Range;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.detrend.AbstractDetrend;
import weka.filters.unsupervised.attribute.detrend.RangeBased;

public class SimpleDetrend
extends SimpleBatchFilter {
    private static final long serialVersionUID = -9044105839662849793L;
    public static final String ATTRIBUTE_RANGE = "R";
    protected Range m_AttributeRange = this.getDefaultAttributeRange();
    public static final String CORRECTION = "correction";
    protected AbstractDetrend m_Correction = this.getDefaultCorrection();
    protected int[] m_AttIndices = null;
    protected double[] m_WaveNo = null;

    public String globalInfo() {
        return "Performs Detrend, using the specified correction scheme.\nSimply enumerates the selected attributes and uses that as wave number (starting at 0).";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.attributeRangeTipText(), this.getDefaultAttributeRange().getRange(), ATTRIBUTE_RANGE);
        WekaOptionUtils.addOption(result, this.correctionTipText(), this.getDefaultCorrection().toCommandLine(), CORRECTION);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setAttributeRange(WekaOptionUtils.parse(options, ATTRIBUTE_RANGE, this.getDefaultAttributeRange()));
        this.setCorrection((AbstractDetrend)WekaOptionUtils.parse(options, CORRECTION, (OptionHandler)this.getDefaultCorrection()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, ATTRIBUTE_RANGE, this.getAttributeRange());
        WekaOptionUtils.add(result, CORRECTION, (OptionHandler)this.getCorrection());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected Range getDefaultAttributeRange() {
        return new Range("first-last");
    }

    public void setAttributeRange(Range value) {
        this.m_AttributeRange = value;
        this.reset();
    }

    public Range getAttributeRange() {
        return this.m_AttributeRange;
    }

    public String attributeRangeTipText() {
        return "The range of attributes to detrend; " + this.m_AttributeRange.getExample();
    }

    protected AbstractDetrend getDefaultCorrection() {
        return new RangeBased();
    }

    public void setCorrection(AbstractDetrend value) {
        this.m_Correction = value;
        this.reset();
    }

    public AbstractDetrend getCorrection() {
        return this.m_Correction;
    }

    public String correctionTipText() {
        return "The correction scheme to apply.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected void reset() {
        super.reset();
        this.m_AttIndices = null;
        this.m_WaveNo = null;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AttributeRange.setMax(inputFormat.numAttributes());
        this.m_AttIndices = this.m_AttributeRange.getIntIndices();
        if (this.m_AttIndices.length == 0) {
            throw new Exception("No attributes identified using range: " + this.m_AttributeRange.getRange());
        }
        if (this.getDebug()) {
            System.err.println(((Object)((Object)this)).getClass().getName() + ": Identified indices: " + Utils.arrayToString((Object)this.m_AttIndices));
        }
        this.m_WaveNo = new double[this.m_AttIndices.length];
        for (int i = 0; i < this.m_AttIndices.length; ++i) {
            this.m_WaveNo[i] = i;
        }
        if (this.getDebug()) {
            System.err.println(((Object)((Object)this)).getClass().getName() + ": Fake wave numbers: " + Utils.arrayToString((Object)this.m_WaveNo));
        }
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        if (instances.numInstances() == 0) {
            return instances;
        }
        Instances result = new Instances(instances, instances.numInstances());
        for (int n = 0; n < instances.numInstances(); ++n) {
            int i;
            Instance inst = instances.instance(n);
            double[] data = new double[this.m_AttIndices.length];
            for (i = 0; i < this.m_AttIndices.length; ++i) {
                data[i] = inst.value(this.m_AttIndices[i]);
            }
            data = this.m_Correction.correct(this.m_WaveNo, data);
            double[] values = inst.toDoubleArray();
            for (i = 0; i < this.m_AttIndices.length; ++i) {
                values[this.m_AttIndices[i]] = data[i];
            }
            Instance instNew = inst.copy(values);
            this.copyValues(instNew, true, inst.dataset(), this.getOutputFormat());
            result.add(instNew);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SimpleDetrend.runFilter((Filter)new SimpleDetrend(), (String[])args);
    }
}

