/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveWithWeights
extends SimpleBatchFilter
implements UnsupervisedFilter,
WeightedInstancesHandler {
    private static final long serialVersionUID = -6784901276150528252L;
    protected double m_DropAbove = 1.0;
    protected double m_DropBelow = 0.0;

    public String globalInfo() {
        return "Removes instances with weights outside the defined limits.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe threshold for the weight above which instances\n\tget dropped.\n\tdefault: 1.0", "drop-above", 1, "-drop-above <0.0-1.0>"));
        result.addElement(new Option("\tThe threshold for the weight below which instances\n\tget dropped.\n\tdefault: 0.0", "drop-below", 1, "-drop-below <0.0-1.0>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"drop-above", (String[])options);
        if (tmpStr.length() == 0) {
            this.setDropAbove(0.0);
        } else {
            this.setDropAbove(Double.parseDouble(tmpStr));
        }
        tmpStr = Utils.getOption((String)"drop-below", (String[])options);
        if (tmpStr.length() == 0) {
            this.setDropBelow(0.0);
        } else {
            this.setDropBelow(Double.parseDouble(tmpStr));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("-drop-above");
        result.add("" + this.getDropAbove());
        result.add("-drop-below");
        result.add("" + this.getDropBelow());
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[0]);
    }

    public void setDropAbove(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_DropAbove = value;
        } else {
            System.err.println("'drop-above' threshold must be within [0;1], provided: " + value);
        }
    }

    public double getDropAbove() {
        return this.m_DropAbove;
    }

    public String dropAboveTipText() {
        return "The threshold of the weights above which to drop instances (0-1).";
    }

    public void setDropBelow(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_DropBelow = value;
        } else {
            System.err.println("'drop-below' threshold must be within [0;1], provided: " + value);
        }
    }

    public double getDropBelow() {
        return this.m_DropBelow;
    }

    public String dropBelowTipText() {
        return "The threshold of the weights below which to drop instances (0-1).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        if (this.m_FirstBatchDone) {
            return new Instances(instances);
        }
        if (this.getDebug()) {
            System.err.println("Dataset size (before): " + instances.numInstances());
        }
        Instances result = new Instances(instances, instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (instances.instance(i).weight() > this.m_DropAbove || instances.instance(i).weight() < this.m_DropBelow) continue;
            result.add((Instance)instances.instance(i).copy());
        }
        result.compactify();
        if (this.getDebug()) {
            System.err.println("Dataset size (after): " + result.numInstances());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        RemoveWithWeights.runFilter((Filter)new RemoveWithWeights(), (String[])args);
    }
}

