/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance.multirowprocessor.selection;

import adams.core.Index;
import adams.core.base.BaseObject;
import adams.core.base.BaseRegExp;
import adams.data.weka.WekaAttributeIndex;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import weka.core.Instances;
import weka.core.WekaOptionUtils;
import weka.filters.unsupervised.instance.multirowprocessor.selection.AbstractRowSelection;

public class GroupExpression
extends AbstractRowSelection {
    private static final long serialVersionUID = -8519118208205929299L;
    protected static String INDEX = "index";
    protected WekaAttributeIndex m_Index = this.getDefaultIndex();
    protected static String REGEXP = "regexp";
    protected BaseRegExp m_RegExp = this.getDefaultRegExp();
    protected static String GROUP = "group";
    public static final String DEFAULT_GROUP = "$0";
    protected String m_Group = "$0";

    @Override
    public String globalInfo() {
        return "Identifies groups in strings using regular expressions.\nIf the group attribute is numeric, then the values get turned into strings first.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.indexTipText(), (Index)this.getDefaultIndex(), INDEX);
        WekaOptionUtils.addOption(result, this.regExpTipText(), this.getDefaultRegExp().getValue(), REGEXP);
        WekaOptionUtils.addOption(result, this.groupTipText(), DEFAULT_GROUP, GROUP);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setIndex((WekaAttributeIndex)WekaOptionUtils.parse(options, INDEX, (Index)this.getDefaultIndex()));
        this.setRegExp((BaseRegExp)WekaOptionUtils.parse(options, REGEXP, (BaseObject)this.getDefaultRegExp()));
        this.setGroup(WekaOptionUtils.parse(options, GROUP, DEFAULT_GROUP));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, INDEX, (Index)this.getIndex());
        WekaOptionUtils.add(result, REGEXP, (BaseObject)this.getRegExp());
        WekaOptionUtils.add(result, GROUP, this.getGroup());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected WekaAttributeIndex getDefaultIndex() {
        return new WekaAttributeIndex("first");
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the attribute to determine the group from.";
    }

    protected BaseRegExp getDefaultRegExp() {
        return new BaseRegExp(".*");
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression for identifying the group (eg '^(.*)-([0-9]+)-(.*)$').";
    }

    public void setGroup(String value) {
        this.m_Group = value;
        this.reset();
    }

    public String getGroup() {
        return this.m_Group;
    }

    public String groupTipText() {
        return "The replacement string to use as group (eg '$2').";
    }

    @Override
    protected List<int[]> doSelectRows(Instances data) throws Exception {
        this.m_Index.setData(data);
        int index = this.m_Index.getIntIndex();
        if (index == -1) {
            throw new Exception("Group attribute not found: " + this.m_Index.getIndex());
        }
        boolean numeric = data.attribute(index).isNumeric();
        ArrayList<int[]> result = new ArrayList<int[]>();
        HashMap<Object, TIntArrayList> groups = new HashMap<Object, TIntArrayList>();
        boolean all = this.m_Group.equals(DEFAULT_GROUP);
        for (int i = 0; i < data.numInstances(); ++i) {
            Object group = numeric ? "" + data.instance(i).value(index) : data.instance(i).stringValue(index);
            if (!all) {
                group = ((String)group).replaceAll(this.m_RegExp.getValue(), this.m_Group);
            }
            if (!groups.containsKey(group)) {
                groups.put(group, new TIntArrayList());
            }
            ((TIntList)groups.get(group)).add(i);
        }
        if (this.getDebug()) {
            this.debugMsg("Groups: " + groups);
        }
        for (String g : groups.keySet()) {
            result.add(((TIntList)groups.get(g)).toArray());
        }
        Collections.sort(result, Comparator.comparingInt(o -> o[0]));
        return result;
    }
}

