/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.util.ArrayList;
import java.util.Hashtable;
import weka.gui.explorer.AbstractExplorerPanelHandler;
import weka.gui.explorer.ClustererPanel;
import weka.gui.explorer.Explorer;

public class ClustererHandler
extends AbstractExplorerPanelHandler {
    private static final long serialVersionUID = 2284676357783882049L;
    public static final String KEY_TEST = "test";
    public static final String KEY_PERCENTAGE_SPLIT = "percentage-split";
    public static final String KEY_CLASS_INDEX = "class index";
    public static final String KEY_IGNORED_ATTRIBUTES = "ignored attributes";
    public static final String KEY_STORE_CLUSTERS = "store clusters";
    public static final String VALUE_PERCENTAGE_SPLIT = "percentage split";
    public static final String VALUE_SUPPLIED_TEST_SET = "supplied test set";
    public static final String VALUE_TRAINING_SET = "training set";
    public static final String VALUE_CLASSES_TO_CLUSTERS = "classes to clusters";

    @Override
    public boolean handles(Explorer.ExplorerPanel panel) {
        return panel instanceof ClustererPanel;
    }

    @Override
    public Object serialize(Explorer.ExplorerPanel panel) {
        ClustererPanel pnl = (ClustererPanel)panel;
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.serialize(pnl.m_ClustererEditor));
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        if (pnl.m_TrainBut.isSelected()) {
            options.put(KEY_TEST, VALUE_TRAINING_SET);
        } else if (pnl.m_TestSplitBut.isSelected()) {
            options.put(KEY_TEST, VALUE_SUPPLIED_TEST_SET);
        } else if (pnl.m_PercentBut.isSelected()) {
            options.put(KEY_TEST, VALUE_PERCENTAGE_SPLIT);
        } else if (pnl.m_ClassesToClustersBut.isSelected()) {
            options.put(KEY_TEST, VALUE_CLASSES_TO_CLUSTERS);
        }
        options.put(KEY_PERCENTAGE_SPLIT, pnl.m_PercentText.getText());
        options.put(KEY_CLASS_INDEX, pnl.m_ClassCombo.getSelectedIndex());
        options.put(KEY_STORE_CLUSTERS, pnl.m_StorePredictionsBut.isSelected());
        options.put(KEY_IGNORED_ATTRIBUTES, pnl.m_ignoreKeyList.getSelectedIndices());
        result.add(options);
        result.add(this.serialize(pnl.m_History));
        return result;
    }

    @Override
    public void deserialize(Explorer.ExplorerPanel panel, Object data) {
        ClustererPanel pnl = (ClustererPanel)panel;
        ArrayList list = (ArrayList)data;
        this.deserialize(list.get(0), pnl.m_ClustererEditor);
        Hashtable options = (Hashtable)list.get(1);
        String tmp = (String)options.get(KEY_TEST);
        if (tmp.equals(VALUE_TRAINING_SET)) {
            pnl.m_TrainBut.setSelected(true);
        } else if (tmp.equals(VALUE_SUPPLIED_TEST_SET)) {
            pnl.m_TestSplitBut.setSelected(true);
        } else if (tmp.equals(VALUE_PERCENTAGE_SPLIT)) {
            pnl.m_PercentBut.setSelected(true);
        } else if (tmp.equals(VALUE_CLASSES_TO_CLUSTERS)) {
            pnl.m_ClassesToClustersBut.setSelected(true);
        }
        this.restoreSelectedIndex(options, KEY_CLASS_INDEX, -1, pnl.m_ClassCombo);
        this.restoreText(options, KEY_PERCENTAGE_SPLIT, "66", pnl.m_PercentText);
        this.restoreSelectedState(options, KEY_STORE_CLUSTERS, true, pnl.m_StorePredictionsBut);
        this.restoreSelectedIndices(options, KEY_IGNORED_ATTRIBUTES, new int[0], pnl.m_ignoreKeyList);
        this.deserialize(list.get(2), pnl.m_History);
    }
}

