/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import adams.core.logging.LoggingHelper;
import adams.env.Environment;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import weka.core.Memory;
import weka.core.Utils;
import weka.core.logging.Logger;
import weka.gui.GenericObjectEditor;
import weka.gui.LookAndFeel;
import weka.gui.explorer.ExplorerEntryPanel;
import weka.gui.explorer.ExplorerExt;
import weka.gui.explorer.WorkspaceHelper;

public class MultiExplorer
extends BasePanel
implements AbstractNamedHistoryPanel.HistoryEntrySelectionListener {
    private static final long serialVersionUID = -20320489406680254L;
    public static final String DEFAULT_NAME = "Session";
    protected JSplitPane m_SplitPane;
    protected ExplorerEntryPanel m_History;
    protected BasePanel m_PanelExplorer;
    protected BasePanel m_PanelHistory;
    protected BasePanel m_PanelButtons;
    protected BaseButton m_ButtonAdd;
    protected BaseButton m_ButtonCopy;
    protected BaseButton m_ButtonRemove;
    protected BaseButton m_ButtonWorkspace;
    protected BaseFileChooser m_WorkspaceFileChooser;
    private static MultiExplorer m_Explorer;
    protected static Memory m_Memory;

    protected void initialize() {
        super.initialize();
        this.m_WorkspaceFileChooser = WorkspaceHelper.newFileChooser();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new JSplitPane();
        this.add(this.m_SplitPane, "Center");
        this.m_PanelExplorer = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelExplorer.setMinimumSize(new Dimension(100, 0));
        this.m_SplitPane.setBottomComponent((Component)this.m_PanelExplorer);
        this.m_History = new ExplorerEntryPanel();
        this.m_History.setPanel(this.m_PanelExplorer);
        this.m_History.setAllowRename(true);
        this.m_History.addHistoryEntrySelectionListener(this);
        this.m_PanelHistory = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelHistory.setMinimumSize(new Dimension(100, 0));
        this.m_PanelHistory.add((Component)((Object)this.m_History), (Object)"Center");
        this.m_PanelButtons = new BasePanel((LayoutManager)new FlowLayout(0));
        this.m_PanelHistory.add((Component)this.m_PanelButtons, (Object)"South");
        this.m_SplitPane.setTopComponent((Component)this.m_PanelHistory);
        this.m_ButtonAdd = new BaseButton((Icon)ImageManager.getIcon((String)"add.gif"));
        int height = this.m_ButtonAdd.getHeight();
        this.m_ButtonAdd.setSize(height, height);
        this.m_ButtonAdd.setToolTipText("Adds a new Explorer panel");
        this.m_ButtonAdd.addActionListener(e -> {
            String initial = this.m_History.newEntryName(DEFAULT_NAME);
            String name = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter the name for the Explorer panel:", (String)initial);
            if (name == null) {
                return;
            }
            this.addPanel(new ExplorerExt(), name);
        });
        this.m_PanelButtons.add((Component)this.m_ButtonAdd);
        this.m_ButtonCopy = new BaseButton((Icon)ImageManager.getIcon((String)"copy.gif"));
        this.m_ButtonCopy.setSize(height, height);
        this.m_ButtonCopy.setToolTipText("Creates a copy of the currently selected Explorer panel");
        this.m_ButtonCopy.addActionListener(e -> {
            ExplorerExt newExplorer;
            ExplorerExt oldExplorer;
            Object name;
            block3: {
                name = "Copy of " + this.m_History.getSelectedEntry();
                if ((name = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter new name:", (String)name)) == null) {
                    return;
                }
                oldExplorer = (ExplorerExt)((Object)((Object)this.m_History.getEntry(this.m_History.getSelectedIndex())));
                name = this.m_History.newEntryName((String)name);
                try {
                    newExplorer = WorkspaceHelper.copy(oldExplorer, true);
                }
                catch (Exception ex) {
                    System.err.println("Failed to copy explorer instance, creating simple copy.");
                    ex.printStackTrace();
                    newExplorer = new ExplorerExt();
                    if (oldExplorer.getPreprocessPanel().getInstances() == null) break block3;
                    newExplorer.getPreprocessPanel().setInstances(oldExplorer.getPreprocessPanel().getInstances());
                }
            }
            newExplorer.getFileChooser().setCurrentDirectory(oldExplorer.getFileChooser().getCurrentDirectory());
            newExplorer.setCurrentFile(oldExplorer.getCurrentFile());
            this.addPanel(newExplorer, (String)name);
        });
        this.m_PanelButtons.add((Component)this.m_ButtonCopy);
        this.m_ButtonRemove = new BaseButton((Icon)ImageManager.getIcon((String)"remove.gif"));
        this.m_ButtonRemove.setSize(height, height);
        this.m_ButtonRemove.setToolTipText("Removes all selected Explorer panels");
        this.m_ButtonRemove.addActionListener(e -> {
            int[] indices = this.m_History.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.removePanel(indices[i]);
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonRemove);
        this.m_ButtonWorkspace = new BaseButton((Icon)ImageManager.getIcon((String)"workspace.png"));
        this.m_ButtonWorkspace.setSize(height, height);
        this.m_ButtonWorkspace.setToolTipText("Loading/saving of workspaces");
        this.m_ButtonWorkspace.addActionListener(ae -> {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Open...");
            menuitem.addActionListener(ae2 -> this.openWorkspace());
            menu.add(menuitem);
            menuitem = new JMenuItem("Save as...");
            menuitem.addActionListener(ae2 -> this.saveWorkspace());
            menu.add(menuitem);
            menu.show((Component)this.m_ButtonWorkspace, 0, this.m_ButtonWorkspace.getHeight());
        });
        this.m_PanelButtons.add((Component)this.m_ButtonWorkspace);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(0.0);
        this.m_SplitPane.setDividerLocation(250);
    }

    protected void finishInit() {
        super.finishInit();
        SwingUtilities.invokeLater(() -> this.addPanel(new ExplorerExt(), DEFAULT_NAME));
    }

    public void clear() {
        SwingUtilities.invokeLater(() -> {
            this.m_History.clear();
            this.m_PanelExplorer.removeAll();
        });
    }

    public int count() {
        return this.m_History.count();
    }

    public ExplorerEntryPanel getHistory() {
        return this.m_History;
    }

    public synchronized void addPanel(ExplorerExt panel, String name) {
        this.m_History.addEntry(this.m_History.newEntryName(name), (Object)panel);
        this.m_History.setSelectedIndex(this.count() - 1);
    }

    public synchronized boolean removePanel(String name) {
        boolean result;
        if (!this.m_History.hasEntry(name)) {
            return false;
        }
        int index = this.m_History.indexOfEntry(name);
        boolean bl = result = this.m_History.removeEntry(name) != null;
        if (this.m_History.count() > 0) {
            if (this.m_History.count() <= index) {
                --index;
            }
            this.m_History.updateEntry(this.m_History.getEntryName(index));
        }
        return result;
    }

    public synchronized boolean removePanel(int index) {
        return this.removePanel(this.m_History.getEntryName(index));
    }

    public ExplorerExt getPanel(String name) {
        return (ExplorerExt)((Object)this.m_History.getEntry(name));
    }

    public void load(File file) {
        this.load(new File[]{file});
    }

    public void load(File[] files) {
        for (File file : files) {
            String name = file.getName();
            if (name.lastIndexOf(46) > -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            ExplorerExt panel = new ExplorerExt();
            this.addPanel(panel, name);
            SwingUtilities.invokeLater(() -> panel.open(file));
        }
    }

    protected void openWorkspace() {
        int retVal = this.m_WorkspaceFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        File file = this.m_WorkspaceFileChooser.getSelectedFile();
        try {
            WorkspaceHelper.read(file, this);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to open workspace '" + file + "'!\n" + LoggingHelper.throwableToString((Throwable)e)));
        }
    }

    public void saveWorkspace() {
        int retVal = this.m_WorkspaceFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        File file = this.m_WorkspaceFileChooser.getSelectedFile();
        try {
            WorkspaceHelper.write(this, file);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save workspace to '" + file + "'!\n" + LoggingHelper.throwableToString((Throwable)e)));
        }
    }

    public ExplorerEntryPanel getEntryPanel() {
        return this.m_History;
    }

    public void historyEntrySelected(AbstractNamedHistoryPanel.HistoryEntrySelectionEvent e) {
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonRemove.setEnabled(this.m_History.getSelectedIndex() > -1);
        this.m_ButtonCopy.setEnabled(this.m_History.getSelectedIndices().length == 1);
    }

    public static void runExplorer(String[] args) {
        String env;
        try {
            env = Utils.getOption((String)"env", (String[])args);
        }
        catch (Exception e) {
            env = "";
        }
        if (env.isEmpty()) {
            env = Environment.class.getName();
        }
        try {
            Environment.setEnvironmentClass(Class.forName(env));
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate environment class: " + env);
            e.printStackTrace();
            Environment.setEnvironmentClass(Environment.class);
        }
        Logger.log((Logger.Level)Logger.Level.INFO, (String)"Logging started");
        LookAndFeel.setLookAndFeel();
        GenericObjectEditor.determineClasses();
        try {
            m_Explorer = new MultiExplorer();
            final BaseFrame frame = new BaseFrame("Multi-Explorer");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)((Object)m_Explorer), "Center");
            frame.pack();
            frame.setSize(GUIHelper.getDefaultLargeDialogDimension());
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        frame.dispose();
                        m_Explorer = null;
                        System.gc();
                        System.err.println("\ndisplayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting");
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            Logger.log((Logger.Level)Logger.Level.SEVERE, (String)LoggingHelper.throwableToString((Throwable)ex));
            System.err.println("An Exception occurred: ");
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MultiExplorer.runExplorer(args);
    }

    static {
        m_Memory = new Memory(true);
    }
}

