/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.ClassCrossReference;
import adams.data.conversion.AbstractStringConversion;
import adams.data.conversion.Conversion;
import adams.data.conversion.DOMToString;
import adams.data.conversion.MultiConversion;
import adams.data.conversion.XMLToDOM;

public class PrettyPrintXML
extends AbstractStringConversion
implements ClassCrossReference {
    private static final long serialVersionUID = -3082296139248705157L;
    protected int m_NumSpaces;

    public String globalInfo() {
        return "Turns the XML string into a pretty-printed XML string.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{XMLToDOM.class, DOMToString.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-spaces", "numSpaces", (Object)2, (Number)0, null);
    }

    public void setNumSpaces(int value) {
        if (this.getOptionManager().isValid("numSpaces", (Number)value)) {
            this.m_NumSpaces = value;
            this.reset();
        }
    }

    public int getNumSpaces() {
        return this.m_NumSpaces;
    }

    public String numSpacesTipText() {
        return "The number of spaces to use for indentation.";
    }

    protected Object doConvert() throws Exception {
        XMLToDOM xml2dom = new XMLToDOM();
        DOMToString dom2str = new DOMToString();
        dom2str.setPrettyPrinting(true);
        dom2str.setNumSpaces(this.m_NumSpaces);
        MultiConversion multi = new MultiConversion();
        multi.setSubConversions(new Conversion[]{xml2dom, dom2str});
        multi.setInput(this.m_Input);
        return multi.doConvert();
    }
}

