/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddDOMAttribute
extends AbstractTransformer {
    private static final long serialVersionUID = 665475246547884486L;
    protected String m_Attribute;
    protected String m_Value;

    public String globalInfo() {
        return "Adds a new attribute to the incoming " + Node.class.getName() + " and forwards the new updated node.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("attribute", "attribute", (Object)"name");
        this.m_OptionManager.add("value", "value", (Object)"value");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"attribute", (Object)this.m_Attribute, (String)"att: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)", value: ");
        return result;
    }

    public void setAttribute(String value) {
        this.m_Attribute = value;
        this.reset();
    }

    public String getAttribute() {
        return this.m_Attribute;
    }

    public String attributeTipText() {
        return "The name of the attribute to add.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value of the attribute to add.";
    }

    public Class[] accepts() {
        return new Class[]{Node.class};
    }

    public Class[] generates() {
        return new Class[]{Node.class};
    }

    protected String doExecute() {
        String result = null;
        Node node = (Node)this.m_InputToken.getPayload();
        if (node instanceof Element) {
            ((Element)node).setAttribute(this.m_Attribute, this.m_Value);
        } else {
            result = "Cannot add attribute: " + node.getClass().getName() + "/" + node;
        }
        this.m_OutputToken = new Token((Object)node);
        return result;
    }
}

