/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AddDOMNode
extends AbstractTransformer {
    private static final long serialVersionUID = 665475246547884486L;
    protected String m_NodeName;
    protected boolean m_HasValue;
    protected String m_NodeValue;

    public String globalInfo() {
        return "Adds a new node below the incoming " + Node.class.getName() + " and forwards the new node.\nIn case of an incoming " + Document.class.getName() + ", the node gets added below the root node.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("node-name", "nodeName", (Object)"node");
        this.m_OptionManager.add("has-value", "hasValue", (Object)false);
        this.m_OptionManager.add("node-value", "nodeValue", (Object)"");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"nodeName", (Object)this.m_NodeName, (String)"name: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"hasValue", (boolean)this.m_HasValue, (String)"with value", (String)", ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"nodeValue", (Object)this.m_NodeValue, (String)", value: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setNodeName(String value) {
        this.m_NodeName = value;
        this.reset();
    }

    public String getNodeName() {
        return this.m_NodeName;
    }

    public String nodeNameTipText() {
        return "The name of the node to add.";
    }

    public void setHasValue(boolean value) {
        this.m_HasValue = value;
        this.reset();
    }

    public boolean getHasValue() {
        return this.m_HasValue;
    }

    public String hasValueTipText() {
        return "If enabled, the node gets the specified textual value.";
    }

    public void setNodeValue(String value) {
        this.m_NodeValue = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getNodeValue() {
        return Utils.backQuoteChars((String)this.m_NodeValue);
    }

    public String nodeValueTipText() {
        return "The value of the node to add; new lines, carriage returns or tabs can be escaped like '\\n', '\\r' or '\\t'.";
    }

    public Class[] accepts() {
        return new Class[]{Document.class, Node.class};
    }

    public Class[] generates() {
        return new Class[]{Node.class};
    }

    protected String doExecute() {
        Document doc;
        String result = null;
        Node node = null;
        Node child = null;
        if (this.m_InputToken.getPayload() instanceof Document && (node = (doc = (Document)this.m_InputToken.getPayload()).getDocumentElement()) == null) {
            child = doc.createElement(this.m_NodeName);
            doc.appendChild(child);
        }
        if (child == null) {
            node = (Node)this.m_InputToken.getPayload();
            doc = node.getOwnerDocument();
            child = node.getOwnerDocument().createElement(this.m_NodeName);
            node.appendChild(child);
        }
        if (this.m_HasValue) {
            Text text = node.getOwnerDocument().createTextNode(this.m_NodeValue);
            child.appendChild(text);
        }
        this.m_OutputToken = new Token(child);
        return result;
    }
}

