/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.io.FileUtils;
import adams.core.io.PrettyPrintingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractFileWriter;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFileWriter
extends AbstractFileWriter
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = 3613018887562327088L;
    protected BaseCharset m_Encoding;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Writes a " + Document.class.getName() + " to an XML file.\nIn case of " + Node.class.getName() + " objects, the owning document is written to disk.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public String outputFileTipText() {
        return "The name of the output file.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when writing to the file.";
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the XML is output in pretty-print format.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding, (String)", encoding: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"prettyPrinting", (Object)(this.m_PrettyPrinting ? "pretty" : "not-so-pretty"), (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Document.class, Node.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        try {
            Document doc = this.m_InputToken.getPayload() instanceof Document ? (Document)this.m_InputToken.getPayload() : ((Node)this.m_InputToken.getPayload()).getOwnerDocument();
            Document document = doc;
            synchronized (document) {
                if (this.m_PrettyPrinting) {
                    doc = (Document)doc.cloneNode(true);
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", doc, XPathConstants.NODESET);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        node.getParentNode().removeChild(node);
                    }
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                if (this.m_PrettyPrinting) {
                    factory.setAttribute("indent-number", 2);
                }
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("encoding", this.m_Encoding.charsetValue().toString());
                if (this.m_PrettyPrinting) {
                    transformer.setOutputProperty("indent", "yes");
                }
                StringWriter swriter = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(swriter));
                result = FileUtils.writeToFileMsg((String)this.m_OutputFile.getAbsolutePath(), (Object)swriter.toString(), (boolean)false, (String)this.m_Encoding.charsetValue().name());
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to write DOM document to " + this.m_OutputFile, e);
        }
        return result;
    }
}

