/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.dom;

import adams.data.conversion.DOMNodeToString;
import adams.gui.core.BaseTreeNode;
import com.github.fracpete.jclipboardhelper.TransferableString;
import java.awt.datatransfer.Transferable;
import org.w3c.dom.Node;

public class DOMNode
extends BaseTreeNode {
    private static final long serialVersionUID = 9062259637831548370L;
    public static final String ROOT = "root";
    protected Object m_Value;

    public DOMNode(String label, Object value) {
        super((Object)label);
        this.m_Value = value;
    }

    public String getLabel() {
        return (String)this.getUserObject();
    }

    public boolean hasValue() {
        return this.m_Value != null;
    }

    public Object getValue() {
        return this.m_Value;
    }

    public Transferable toTransferable() {
        TransferableString result = null;
        if (!(this.getValue() instanceof Node)) {
            return result;
        }
        try {
            DOMNodeToString conv = new DOMNodeToString();
            conv.setInput(this.getValue());
            String msg = conv.convert();
            if (msg == null) {
                result = new TransferableString((String)conv.getOutput());
            } else {
                System.err.println("Failed to convert value to string: " + msg);
            }
            conv.cleanUp();
        }
        catch (Exception e) {
            System.err.println("Failed to convert value to string:");
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

